/*
 * Decompiled with CFR 0.152.
 */
package physicon.objava3.more;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import physicon.controls.CUtil;
import physicon.objava3.SimObject;
import physicon.objava3.SimWindow;
import physicon.objava3.more.RectRegion;

public class SimImage
extends RectRegion {
    private Image m_image;

    public SimImage(SimObject simObject, Point point, Rectangle rectangle, String string) {
        super(simObject, point, rectangle);
        this.m_image = this.getImage(string, simObject);
    }

    public SimImage(SimObject simObject, Point point, Rectangle rectangle, Image image) {
        super(simObject, point, rectangle);
        this.m_image = image;
    }

    public void paint(Graphics graphics) {
        Rectangle rectangle = this.getRect();
        CUtil.drawImage(graphics, this.m_image, rectangle.x, rectangle.y, null, this);
    }

    public void destroy() {
        super.destroy();
        this.m_image.flush();
        if (SimWindow.isMicrosoft) {
            this.m_image = null;
            System.gc();
        }
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 0xC0) != 0) {
            return false;
        }
        if ((n & 0x20) != 0) {
            SimWindow simWindow = this.getSimWindow();
            simWindow.paintAll();
            simWindow.flushBuffer();
            return false;
        }
        return true;
    }

    public void setImage(Image image) {
        this.m_image = image;
    }

    public void clearBackground() {
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        graphics.setColor(this.getSimWindow().getBkgColor());
        Rectangle rectangle = this.getRect();
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }
}

