/*
 * Decompiled with CFR 0.152.
 */
package physicon.objava3;

import java.awt.Dimension;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import physicon.controls.ISlider;
import physicon.objava3.SequenceController;
import physicon.objava3.SimWindow;

public class SimSlider
extends SimWindow
implements ActionListener,
SequenceController {
    protected ISlider m_sl;
    private String m_eventName;
    private String m_setEventName;

    public boolean isPaintTicks() {
        return this.m_sl.isPaintTicks();
    }

    public void requestFocus() {
        this.m_sl.requestFocus();
    }

    public void setRange(double d, double d2) {
        this.m_sl.setRange(d, d2);
    }

    public void setValue(double d) {
        this.m_sl.setValue(d);
    }

    public double getValue() {
        return this.m_sl.getValue();
    }

    public void setMinValue(double d) {
        this.m_sl.setMinValue(d);
    }

    public double getMinValue() {
        return this.m_sl.getMinValue();
    }

    public SimSlider(SimWindow simWindow, Point point, Dimension dimension, double d, double d2, double d3, double d4, int n, String[] stringArray, String string, String string2) {
        super(simWindow, point, dimension);
        this.m_eventName = string;
        this.m_setEventName = string2;
        this.m_sl = this.getFactory().createSlider(d, d2, d3, d4, n, stringArray);
        this.m_sl.setBounds(0, 0, this.getSize().width, this.getSize().height);
        this.m_sl.addActionListener(this);
        this.m_sl.addMouseListener(this);
    }

    public SimSlider(SimWindow simWindow, Point point, Dimension dimension, double d, double d2, double d3, int n, String string, String string2) {
        this(simWindow, point, dimension, d, d2, d3, 0.0, n, null, string, string2);
    }

    public void notifyLast() {
        if (this.m_setEventName != null) {
            this.publishEvent(this.m_setEventName, new Double(this.getValue()));
        }
    }

    public void notifyChange() {
        if (this.m_eventName != null) {
            this.publishEvent(this.m_eventName, new Double(this.getValue()));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getID() == 0) {
            this.notifyLast();
            return;
        }
        this.notifyChange();
    }

    public void setMaxValue(double d) {
        this.m_sl.setMaxValue(d);
    }

    public double getMaxValue() {
        return this.m_sl.getMaxValue();
    }

    public void setStep(double d) {
        this.m_sl.setStep(d);
    }

    public double getStep() {
        return this.m_sl.getStep();
    }

    public void setLabels(String[] stringArray) {
        this.m_sl.setLabels(stringArray);
    }

    public String[] getLabels() {
        return this.m_sl.getLabels();
    }

    public void setStringValue(String string) {
        this.setValue(new Double(string));
        this.notifyChange();
        this.notifyLast();
    }

    public String getStringValue() {
        return "" + this.getValue();
    }

    public void setPaintTicks(boolean bl) {
        this.m_sl.setPaintTicks(bl);
    }

    public void setDashes(double d, int n) {
        this.m_sl.setDashes(d, n);
    }

    public Panel createComponent() {
        Panel panel = super.createComponent();
        panel.add(this.m_sl.getAWTComponent());
        return panel;
    }

    public void setEnabled(boolean bl) {
        this.m_sl.setEnabled(bl);
        super.setEnabled(bl);
    }

    public boolean isFocused() {
        return this.m_sl.isFocused();
    }
}

