/*
 * Decompiled with CFR 0.152.
 */
package physicon.metatex3;

import java.awt.Graphics;

public class MetaTexGraphics {
    private Graphics g;
    private int[] xs;
    private int[] ys;
    private int quaverHight;
    private int quaverWidth;

    public void drawQuaver2(int n, int n2, int n3, int n4) {
        this.g.translate(n2, n3);
        this.prepareQuaver(n4);
        if (n == 1) {
            this.inverse(this.ys);
            this.g.translate(0, n4);
            this.putPixels(this.xs, this.ys);
            this.g.translate(0, -n4);
        } else if (n == 2) {
            this.g.translate(this.quaverHight, n4);
            this.inverse(this.xs);
            this.inverse(this.ys);
            this.putPixels(this.xs, this.ys);
            this.g.translate(-this.quaverHight, -n4);
        } else if (n == 3) {
            this.inverse(this.xs);
            this.g.translate(this.quaverHight, -this.quaverHight);
            this.putPixels(this.xs, this.ys);
            this.g.translate(-this.quaverHight, this.quaverHight);
        } else {
            this.g.translate(0, -this.quaverHight);
            this.putPixels(this.xs, this.ys);
            this.g.translate(0, this.quaverHight);
        }
        this.g.translate(-n2, -n3);
    }

    public void drawQuaver(int n, int n2, int n3, int n4) {
        this.g.translate(n2, n3);
        this.prepareQuaver(n4);
        if (n == 1) {
            this.inverse(this.xs);
            this.g.translate(-this.quaverHight, this.quaverHight);
            this.putPixels(this.ys, this.xs);
            this.g.translate(this.quaverHight, -this.quaverHight);
        } else if (n == 2) {
            this.inverse(this.xs);
            this.inverse(this.ys);
            this.g.translate(n4, this.quaverHight);
            this.putPixels(this.ys, this.xs);
            this.g.translate(-n4, -this.quaverHight);
        } else if (n == 3) {
            this.inverse(this.ys);
            this.g.translate(n4, 0);
            this.putPixels(this.ys, this.xs);
            this.g.translate(-n4, 0);
        } else {
            this.g.translate(-this.quaverHight, 0);
            this.putPixels(this.ys, this.xs);
            this.g.translate(this.quaverHight, 0);
        }
        this.g.translate(-n2, -n3);
    }

    private void inverse(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = -nArray[n];
            ++n;
        }
    }

    private void draw(int[] nArray, int[] nArray2) {
        this.putPixels(nArray, nArray2);
        this.putPixels(nArray2, nArray);
    }

    public MetaTexGraphics(Graphics graphics) {
        this.g = graphics;
    }

    private void putPixels(int[] nArray, int[] nArray2) {
        int n = 0;
        while (n < nArray.length) {
            this.g.drawLine(nArray[n], nArray2[n], nArray[n], nArray2[n]);
            ++n;
        }
    }

    public void prepareQuaver(int n) {
        int n2 = n * n;
        int n3 = n;
        int n4 = n2;
        int n5 = 0;
        int n6 = (int)(1.0 + (double)n * Math.sqrt(2.0) / 2.0);
        this.xs = new int[n6];
        this.ys = new int[n6];
        int n7 = 0;
        while (n7 < n6) {
            if (n4 + n5 + (n7 << 1) + 1 > n2) {
                n4 -= (n3 << 1) - 1;
            }
            n5 += (n7 << 1) + 1;
            this.xs[n7] = n7;
            this.ys[n7] = --n3;
            ++n7;
        }
        this.quaverWidth = n - this.ys[this.xs.length - 1];
        this.quaverHight = this.xs[this.xs.length - 1];
    }

    public int getQuaverHeight() {
        return this.quaverHight;
    }

    public void drawQuater(int n, int n2, int n3, int n4) {
        this.g.translate(n2, n3);
        this.prepareQuaver(n4);
        if (n == 1) {
            this.inverse(this.ys);
            this.putPixels(this.xs, this.ys);
            this.inverse(this.ys);
            this.inverse(this.xs);
            this.putPixels(this.ys, this.xs);
        } else if (n == 2) {
            this.inverse(this.xs);
            this.inverse(this.ys);
            this.draw(this.xs, this.ys);
        } else if (n == 3) {
            this.inverse(this.xs);
            this.putPixels(this.xs, this.ys);
            this.inverse(this.ys);
            this.inverse(this.xs);
            this.putPixels(this.ys, this.xs);
        } else {
            this.draw(this.xs, this.ys);
        }
        this.g.translate(-n2, -n3);
    }

    public int getQuaverWidth() {
        return this.quaverWidth;
    }
}

