/*
 * Decompiled with CFR 0.152.
 */
package physicon.metatex3;

import java.awt.Graphics;
import java.util.Vector;
import physicon.metatex3.Block;

public class LongdivBlock
extends Block {
    private int rad;
    private int wl;

    public boolean testArgs(Vector vector) {
        return vector.size() == 2;
    }

    public LongdivBlock() {
        super(2);
    }

    public void sizeSelf() {
        double d = (double)(this.blocks[0].getHeight() + 2) / (2.0 * Math.sin(0.6283185307179586));
        this.wl = (int)(d * (1.0 - Math.cos(0.6283185307179586)));
        this.rad = (int)d;
        this.width = Math.max(this.blocks[0].width, this.blocks[1].width) + this.wl + 2;
        int n = this.blocks[1].getHeight() + this.blocks[0].getHeight() + 3;
        this.ascent = this.blocks[1].getHeight() + this.blocks[0].ascent + 3;
        this.descent = n - this.ascent;
        this.coords[0].x = this.width - this.blocks[0].width;
        this.coords[0].y = this.ascent - this.blocks[0].ascent;
        this.coords[1].x = this.width - this.blocks[1].width;
        this.coords[1].y = 0;
    }

    public int getArgType(int n) {
        if (n < 2) {
            return 1;
        }
        return -1;
    }

    public void paintSelf(Graphics graphics) {
        graphics.drawLine(0, this.blocks[1].getHeight() + 2, this.width - 1, this.blocks[1].getHeight() + 2);
        int n = this.wl - 2 * this.rad;
        int n2 = this.blocks[1].getHeight() + this.blocks[0].getHeight() / 2 - this.rad + 3;
        graphics.drawArc(n, n2, 2 * this.rad, 2 * this.rad, -36, 72);
    }
}

