/*
 * Decompiled with CFR 0.152.
 */
package physicon.metatex3;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.util.Vector;
import physicon.metatex3.MetaTexFont;
import physicon.metatex3.MetaTexProperties;

public class Block
implements Cloneable {
    public static final int TEXT = 0;
    public static final int BLOCK = 1;
    public static final int ERROR = -1;
    protected int width = 0;
    protected int ascent = 0;
    protected int descent = 0;
    protected int lspace = 0;
    protected int rspace = 0;
    protected boolean ltext = false;
    protected boolean rtext = false;
    protected int style = -1;
    protected int scale = 0;
    protected Color background = Color.white;
    private int start;
    private int end;
    protected Block[] blocks;
    protected Point[] coords;
    protected MetaTexProperties props;
    protected String name = "";
    protected static Toolkit toolkit = Toolkit.getDefaultToolkit();
    private Dimension size;
    private boolean deleted;
    private static /* synthetic */ Class class$physicon$metatex3$Block;

    public boolean testArgs(Vector vector) {
        return true;
    }

    public Object getProperty(String string) {
        return this.props.get(string);
    }

    public final int getAscent() {
        return this.ascent;
    }

    public final int getShiftedAscent() {
        MetaTexFont metaTexFont = this.props.getFont(0);
        int[] nArray = metaTexFont.getFontMetric();
        int n = nArray[2] - metaTexFont.getSize() / 2;
        return this.ascent + n;
    }

    public final int getDescent() {
        return this.descent;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    protected void setBorders() {
        if (this.getClass().equals(class$physicon$metatex3$Block != null ? class$physicon$metatex3$Block : (class$physicon$metatex3$Block = Block.class$("physicon.metatex3.Block"))) && this.blocks.length != 0) {
            if (this.blocks[0] != null) {
                this.ltext = this.blocks[0].ltext;
            }
            if (this.blocks[this.blocks.length - 1] != null) {
                this.rtext = this.blocks[this.blocks.length - 1].rtext;
            }
        }
    }

    public void setStart(int n) {
        this.start = n;
    }

    public int getStart() {
        return this.start;
    }

    public void restore() {
        this.setDeleted(false);
        int n = 0;
        while (n < this.blocks.length) {
            if (this.blocks[n] != null) {
                this.blocks[n].restore();
            }
            ++n;
        }
    }

    public void setArgs(Vector vector) {
        int n = Math.min(vector.size(), this.blocks.length);
        int n2 = 0;
        while (n2 < n) {
            if (vector.elementAt(n2) instanceof Block) {
                this.blocks[n2] = (Block)vector.elementAt(n2);
            }
            ++n2;
        }
        this.setChildrenScale(this.scale);
    }

    public int getArgType(int n) {
        return -1;
    }

    public Block[] getChildren() {
        return this.blocks;
    }

    protected void paintSelf(Graphics graphics) {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Dimension getSize() {
        if (this.size == null) {
            int n = 0;
            while (n < this.blocks.length) {
                if (this.blocks[n] != null) {
                    this.blocks[n].getSize();
                }
                ++n;
            }
            this.setBorders();
            this.sizeSelf();
            this.setSpaces();
            this.size = new Dimension(this.width, this.getHeight());
        }
        return this.size;
    }

    public boolean isEmpty() {
        int n = 0;
        while (n < this.blocks.length) {
            if (this.blocks[n] != null && !this.blocks[n].isDeleted()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public Object clone() {
        try {
            Block block = (Block)super.clone();
            block.background = new Color(this.background.getRGB());
            block.props = (MetaTexProperties)this.props.clone();
            int n = 0;
            while (n < this.blocks.length) {
                block.blocks[n] = (Block)this.blocks[n].clone();
                block.coords[n] = new Point(this.coords[n].x, this.coords[n].y);
                ++n;
            }
            return block;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException.getMessage());
        }
    }

    public int getLength() {
        return this.end - this.start;
    }

    public final int getWidth() {
        return this.width;
    }

    public void setFontStyle(int n) {
        if (this.style == -1) {
            this.style = n;
        } else if (this.style != 0 && n != 0) {
            this.style |= n;
        }
        int n2 = 0;
        while (n2 < this.blocks.length) {
            if (this.blocks[n2] != null) {
                this.blocks[n2].setFontStyle(n);
            }
            ++n2;
        }
    }

    public int getFontStyle() {
        if (this.style == -1) {
            return 0;
        }
        return this.style;
    }

    public boolean isText() {
        if (this.getClass().equals(class$physicon$metatex3$Block != null ? class$physicon$metatex3$Block : (class$physicon$metatex3$Block = Block.class$("physicon.metatex3.Block")))) {
            if (this.blocks.length == 0) {
                return false;
            }
            int n = 0;
            while (n < this.blocks.length) {
                if (!this.blocks[n].isText()) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    protected void setChildrenScale(int n) {
        int n2 = 0;
        while (n2 < this.blocks.length) {
            if (this.blocks[n2] != null) {
                this.blocks[n2].setScale(n);
            }
            ++n2;
        }
    }

    public void remove(Block block) {
        int n = 0;
        while (n < this.blocks.length) {
            if (this.blocks[n] == block) {
                this.blocks[n].setDeleted(true);
                return;
            }
            ++n;
        }
    }

    public int getLspace() {
        return this.lspace;
    }

    public int getRspace() {
        return this.rspace;
    }

    public void setEnd(int n) {
        this.end = n;
    }

    public int getEnd() {
        return this.end;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color color) {
        this.background = color;
        int n = 0;
        while (n < this.blocks.length) {
            if (this.blocks[n] != null) {
                this.blocks[n].setBackground(color);
            }
            ++n;
        }
    }

    public Block() {
        this(0);
    }

    public Block(int n) {
        this.allocate(n);
    }

    protected void allocate(int n) {
        this.blocks = new Block[n];
        this.coords = new Point[n];
        int n2 = 0;
        while (n2 < n) {
            this.coords[n2] = new Point();
            ++n2;
        }
    }

    public void paint(Graphics graphics) {
        int n = 0;
        while (n < this.blocks.length) {
            if (this.blocks[n] != null) {
                Point point = this.coords[n];
                graphics.translate(point.x, point.y);
                this.blocks[n].paint(graphics);
                graphics.translate(-point.x, -point.y);
            }
            ++n;
        }
        this.paintSelf(graphics);
    }

    public String toString() {
        return "Block[" + this.start + ", " + this.end + "]";
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int n) {
        this.scale = n;
        this.setChildrenScale(this.scale);
    }

    protected void sizeSelf() {
        this.descent = 0;
        this.ascent = 0;
        int n = 0;
        while (n < this.blocks.length) {
            this.ascent = Math.max(this.ascent, this.blocks[n].ascent);
            this.descent = Math.max(this.descent, this.blocks[n].descent);
            ++n;
        }
        n = 0;
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.blocks.length) {
            if (n5 > 0) {
                n = this.blocks[n5 - 1].rtext ? 1 : 0;
            }
            bl = this.blocks[n5].ltext;
            if (n != 0 && bl) {
                n2 += this.blocks[n5 - 1].rspace + this.blocks[n5].lspace;
            } else if (n5 > 0) {
                if (n == 0) {
                    n2 += this.blocks[n5 - 1].rspace;
                }
                if (!bl) {
                    n2 += this.blocks[n5].lspace;
                }
            }
            if (n2 < n4) {
                n4 = n2;
            }
            this.coords[n5].x = n2;
            this.coords[n5].y = this.ascent - this.blocks[n5].ascent;
            if ((n2 += this.blocks[n5].width) > n3) {
                n3 = n2;
            }
            ++n5;
        }
        this.width = n3;
        if (n4 < 0) {
            n5 = 0;
            while (n5 < this.blocks.length) {
                this.coords[n5].x -= n4;
                ++n5;
            }
            this.width -= n4;
        }
    }

    public boolean contains(Block block) {
        return this.end >= block.getEnd() && this.start <= block.getStart();
    }

    public Block getBlockByName(String string) {
        if (string.equals(this.name)) {
            return this;
        }
        int n = 0;
        while (n < this.blocks.length) {
            Block block;
            if (this.blocks[n] != null && (block = this.blocks[n].getBlockByName(string)) != null) {
                return block;
            }
            ++n;
        }
        return null;
    }

    public Point[] getChildrenCoords() {
        return this.coords;
    }

    protected MetaTexFont getFont() {
        return this.props.getFont(this.scale).getStyled(this.getFontStyle());
    }

    public boolean getLtext() {
        return this.ltext;
    }

    public boolean getRtext() {
        return this.rtext;
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void setProperties(MetaTexProperties metaTexProperties) {
        this.props = metaTexProperties;
    }

    protected void setSpaces() {
        if (this.getClass().equals(class$physicon$metatex3$Block != null ? class$physicon$metatex3$Block : (class$physicon$metatex3$Block = Block.class$("physicon.metatex3.Block")))) {
            if (this.blocks.length != 0) {
                if (this.blocks[0] != null) {
                    this.lspace = this.blocks[0].lspace;
                }
                if (this.blocks[this.blocks.length - 1] != null) {
                    this.rspace = this.blocks[this.blocks.length - 1].rspace;
                    return;
                }
            }
        } else {
            try {
                int n = (Integer)this.getProperty("space");
                this.lspace = n / 2;
                this.rspace = n - this.lspace;
                return;
            }
            catch (Exception exception) {
                this.rspace = 0;
                this.lspace = 0;
            }
        }
    }

    public final int getHeight() {
        return this.ascent + this.descent;
    }

    public void setDeleted(boolean bl) {
        this.deleted = bl;
    }

    public int getInternalStyle() {
        return this.style;
    }
}

