/*
 * Decompiled with CFR 0.152.
 */
package physicon.graphLib2;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import physicon.graphLib2.LabelDrawer;

public class TextLabelDrawer
extends LabelDrawer {
    String text;

    public TextLabelDrawer(String string) {
        this.text = string;
    }

    public TextLabelDrawer(String string, int n, int n2) {
        super(n, n2);
        this.text = string;
    }

    public void drawLocal(Graphics graphics) {
        Font font = graphics.getFont();
        graphics.setFont(this.font);
        Color color = graphics.getColor();
        Rectangle rectangle = this.getLocalRoughRect();
        if (this.getBackColor() != null) {
            graphics.setColor(this.getBackColor());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        graphics.setColor(this.getTextColor());
        graphics.drawString(this.text, rectangle.x, rectangle.y + this.fm.getAscent());
        graphics.setFont(font);
        graphics.setColor(color);
    }

    public Rectangle getLocalRoughRect() {
        Rectangle rectangle = new Rectangle(0, 0, this.fm.stringWidth(this.text), this.fm.getHeight());
        switch (this.hAlignment) {
            case 1: {
                rectangle.x -= this.fm.stringWidth(this.text);
                break;
            }
            case 2: {
                rectangle.x -= this.fm.stringWidth(this.text) / 2;
            }
        }
        switch (this.vAlignment) {
            case 1: {
                rectangle.y -= this.fm.getHeight();
                break;
            }
            case 3: {
                rectangle.y -= this.fm.getAscent();
                break;
            }
            case 2: {
                rectangle.y -= this.fm.getAscent() - this.fm.getHeight() / 2;
            }
        }
        rectangle.grow(1, 1);
        return rectangle;
    }

    public void setText(String string) {
        this.text = string;
    }

    public String getText() {
        return this.text;
    }
}

