/*
 * Decompiled with CFR 0.152.
 */
package physicon.graphLib2;

import physicon.graphLib2.CurveDrawerBase;
import physicon.graphLib2.DoublePoint;
import physicon.graphLib2.GraphElementBase;

public abstract class GraphCurveBase
extends GraphElementBase {
    public double normilizeParamValue(double d) {
        if (d <= this.getMinParamValue()) {
            return 0.0;
        }
        if (d >= this.getMaxParamValue()) {
            return 1.0;
        }
        return (d - this.getMinParamValue()) / (this.getMaxParamValue() - this.getMinParamValue());
    }

    public DoublePoint getGlobalPoint(double d) {
        DoublePoint doublePoint = this.getLocalPoint(d);
        doublePoint.translate(this.getRefPoint());
        return doublePoint;
    }

    public GraphCurveBase(CurveDrawerBase curveDrawerBase) {
        super(curveDrawerBase);
    }

    public abstract double getMinParamValue();

    public abstract DoublePoint getLocalPoint(double var1);

    public abstract double getMaxParamValue();

    public DoublePoint getNormLocalPoint(double d) {
        return this.getLocalPoint(this.restoreParamValue(d));
    }

    public double restoreParamValue(double d) {
        if (d < 0.0) {
            return this.getMinParamValue();
        }
        if (d > 1.0) {
            return this.getMaxParamValue();
        }
        return this.getMinParamValue() + d * (this.getMaxParamValue() - this.getMinParamValue());
    }
}

