/*
 * Decompiled with CFR 0.152.
 */
package physicon.graphLib2;

import java.awt.Component;
import java.awt.Point;
import java.util.Vector;
import physicon.graphLib2.DoublePoint;
import physicon.graphLib2.GraphContextBase;
import physicon.graphLib2.GraphElementBase;
import physicon.graphLib2.GraphElementInterface;
import physicon.graphLib2.GraphScaleBase;

public abstract class GraphContainerBase {
    private GraphContextBase context;
    private Vector elements;
    private Vector scales;

    public GraphContextBase getContext() {
        this.context.setOffset(new Point(0, 0));
        this.context.setOffset(this.context.lp2gp(new DoublePoint(0.0, 0.0)));
        return this.context;
    }

    public final int scalesNumber() {
        return this.scales.size();
    }

    public final void removeAllScales() {
        int n = this.scales.size();
        int n2 = 0;
        while (n2 < n) {
            this.removeScaleAt(0);
            ++n2;
        }
    }

    public void showAllElements(boolean bl) {
        int n = this.elementsNumber();
        int n2 = 0;
        while (n2 < n) {
            this.showElement(this.realElementAt(n2), bl);
            ++n2;
        }
    }

    public final synchronized void insertScaleAt(GraphElementInterface graphElementInterface, int n) {
        GraphElementBase graphElementBase = graphElementInterface.getGraphElement();
        if (!(graphElementBase instanceof GraphScaleBase)) {
            System.out.println("Warning!!! You are attempting to add non - scale object");
            System.out.println("to scale array of container");
            System.out.println("This element will be added to the begining of the element array");
            this.addElement(graphElementInterface);
            return;
        }
        if (n > this.scales.size()) {
            n = this.scales.size();
        }
        double d = n == 0 ? 0.0 : this.scaleAt(n - 1).getZLevel();
        double d2 = n == this.scales.size() ? 10.0 : this.scaleAt(n).getZLevel();
        graphElementBase.setZLevel((d + d2) / 2.0);
        this.scales.insertElementAt(graphElementInterface, n);
        graphElementBase.setContainer(this);
        this.showScale(graphElementInterface, true);
    }

    public abstract void showElement(GraphElementInterface var1, boolean var2);

    public final GraphElementInterface realElementAt(int n) {
        return (GraphElementInterface)this.elements.elementAt(n);
    }

    public GraphContainerBase(GraphContextBase graphContextBase) {
        this.context = graphContextBase;
        this.elements = new Vector();
        this.scales = new Vector();
    }

    public final synchronized void insertElementAt(GraphElementInterface graphElementInterface, int n) {
        GraphElementBase graphElementBase = graphElementInterface.getGraphElement();
        if (n > this.elements.size()) {
            n = this.elements.size();
        }
        double d = n == 0 ? 10.0 : this.elementAt(n - 1).getZLevel();
        double d2 = n == this.elements.size() ? 50.0 : this.elementAt(n).getZLevel();
        graphElementBase.setZLevel((d + d2) / 2.0);
        this.elements.insertElementAt(graphElementInterface, n);
        graphElementBase.setContainer(this);
        this.showElement(graphElementInterface, true);
    }

    public void removeElement(GraphElementInterface graphElementInterface) {
        int n = this.indexOfElement(graphElementInterface);
        if (n == -1) {
            System.out.println("GraphContainerBase: no such element");
            return;
        }
        this.removeElementAt(n);
    }

    public abstract void showScale(GraphElementInterface var1, boolean var2);

    public final void removeAllElements() {
        int n = this.elements.size();
        int n2 = 0;
        while (n2 < n) {
            this.removeElementAt(0);
            ++n2;
        }
    }

    public abstract boolean contains(DoublePoint var1);

    public final synchronized void addElement(GraphElementInterface graphElementInterface) {
        GraphElementBase graphElementBase = graphElementInterface.getGraphElement();
        int n = this.elements.size();
        double d = n == 0 ? 10.0 : this.elementAt(n - 1).getZLevel();
        double d2 = 50.0;
        graphElementBase.setZLevel((d + d2) / 2.0);
        this.elements.addElement(graphElementInterface);
        graphElementBase.setContainer(this);
        this.showElement(graphElementInterface, true);
    }

    public final GraphElementBase elementAt(int n) {
        return ((GraphElementInterface)this.elements.elementAt(n)).getGraphElement();
    }

    public void removeScaleAt(int n) {
        GraphElementInterface graphElementInterface = (GraphElementInterface)this.scales.elementAt(n);
        this.showScale(graphElementInterface, false);
        this.scales.removeElementAt(n);
    }

    public abstract Component getComponent();

    public void removeScale(GraphElementInterface graphElementInterface) {
        int n = this.indexOfScale(graphElementInterface);
        if (n == -1) {
            System.out.println("GraphContainerBase: no such element");
            return;
        }
        this.removeScaleAt(n);
    }

    public synchronized void invalidateAll() {
        int n = this.scales.size();
        int n2 = 0;
        while (n2 < n) {
            this.scaleAt(n2).setRedrawFlag(true);
            ++n2;
        }
        n2 = this.elements.size();
        int n3 = 0;
        while (n3 < n2) {
            this.elementAt(n3).setRedrawFlag(true);
            ++n3;
        }
    }

    protected void finalize() {
        this.removeAllScales();
        this.removeAllElements();
    }

    public final int elementsNumber() {
        return this.elements.size();
    }

    public void showAllScales(boolean bl) {
        int n = this.scalesNumber();
        int n2 = 0;
        while (n2 < n) {
            this.showScale(this.realScaleAt(n2), bl);
            ++n2;
        }
    }

    public final GraphScaleBase scaleAt(int n) {
        return (GraphScaleBase)((GraphElementInterface)this.scales.elementAt(n)).getGraphElement();
    }

    public final GraphElementInterface realScaleAt(int n) {
        return (GraphElementInterface)this.scales.elementAt(n);
    }

    public final int indexOfElement(GraphElementInterface graphElementInterface) {
        return this.elements.indexOf(graphElementInterface);
    }

    public void removeElementAt(int n) {
        GraphElementInterface graphElementInterface = (GraphElementInterface)this.elements.elementAt(n);
        this.showElement(graphElementInterface, false);
        this.elements.removeElementAt(n);
    }

    public final synchronized void addScale(GraphElementInterface graphElementInterface) {
        GraphElementBase graphElementBase = graphElementInterface.getGraphElement();
        if (!(graphElementBase instanceof GraphScaleBase)) {
            System.out.println("Warning!!! You are attempting to add non - scale object");
            System.out.println("to scale array of the graph container");
            System.out.println("This element will be added to the begining of the element array");
            this.addElement(graphElementInterface);
            return;
        }
        int n = this.scales.size();
        double d = n == 0 ? 0.0 : this.scaleAt(n - 1).getZLevel();
        double d2 = 10.0;
        graphElementBase.setZLevel((d + d2) / 2.0);
        this.scales.addElement(graphElementInterface);
        graphElementBase.setContainer(this);
        this.showScale(graphElementInterface, true);
    }

    public final int indexOfScale(GraphElementInterface graphElementInterface) {
        return this.scales.indexOf(graphElementInterface);
    }
}

