/*
 * Decompiled with CFR 0.152.
 */
package physicon.gas2d;

import java.awt.Rectangle;

public final class Grid {
    public static final int EMPTY = -1;
    private int[][] m_indexes;
    private int m_cellSize;
    private int m_offsetX;
    private int m_offsetY;
    private int m_width;
    private int m_height;

    public final void clearAllCells() {
        int n = 0;
        while (n < this.m_width) {
            int n2 = 0;
            while (n2 < this.m_height) {
                this.m_indexes[n][n2] = -1;
                ++n2;
            }
            ++n;
        }
    }

    public Grid(Rectangle rectangle, int n) {
        this.m_cellSize = n;
        this.m_width = (rectangle.width + 1) / n + 1;
        this.m_height = (rectangle.height + 1) / n + 1;
        this.m_indexes = new int[this.m_width][];
        int n2 = 0;
        while (n2 < this.m_width) {
            this.m_indexes[n2] = new int[this.m_height];
            ++n2;
        }
        this.m_offsetX = rectangle.x;
        this.m_offsetY = rectangle.y;
        this.clearAllCells();
    }

    public final int getIndex(int n, int n2) {
        int n3 = (n - this.m_offsetX) / this.m_cellSize;
        int n4 = (n2 - this.m_offsetY) / this.m_cellSize;
        if (n3 < 0 || n4 < 0 || this.m_indexes == null || this.m_indexes.length <= n3 || this.m_indexes[n3] == null || this.m_indexes[n3].length <= n4) {
            return 0;
        }
        return this.m_indexes[n3][n4];
    }

    public final void setIndex(int n, int n2, int n3) {
        int n4 = (n - this.m_offsetX) / this.m_cellSize;
        int n5 = (n2 - this.m_offsetY) / this.m_cellSize;
        if (n4 < 0 || n5 < 0 || this.m_indexes == null || this.m_indexes.length <= n4 || this.m_indexes[n4] == null || this.m_indexes[n4].length <= n5) {
            return;
        }
        this.m_indexes[n4][n5] = n3;
    }

    public void setRect(Rectangle rectangle) {
        this.m_width = (rectangle.width + 1) / this.m_cellSize + 1;
        this.m_height = (rectangle.height + 1) / this.m_cellSize + 1;
        this.m_indexes = new int[this.m_width][];
        int n = 0;
        while (n < this.m_width) {
            this.m_indexes[n] = new int[this.m_height];
            ++n;
        }
        this.m_offsetX = rectangle.x;
        this.m_offsetY = rectangle.y;
        this.clearAllCells();
    }
}

