/*
 * Decompiled with CFR 0.152.
 */
package physicon.gas2d;

import java.awt.Graphics;
import java.awt.Rectangle;
import physicon.gas2d.Gas;
import physicon.gas2d.Molecule;

public abstract class GasContainer {
    private Gas m_gas;
    private boolean m_gasEnabled = true;

    public abstract boolean contains(int var1, int var2);

    public final Gas getGas() {
        return this.m_gas;
    }

    public void setGas(Gas gas) {
        this.m_gas = gas;
    }

    public void enableGas(boolean bl) {
        this.m_gasEnabled = bl;
    }

    public final void resetGas() {
        this.m_gas.reset();
    }

    public final void doStepGas() {
        if (this.m_gasEnabled) {
            this.m_gas.doStep();
        }
    }

    public abstract void interactWithWalls(Molecule var1);

    public final void paintGas(Graphics graphics) {
        if (this.m_gasEnabled) {
            this.m_gas.paint(graphics);
        }
    }

    public abstract Rectangle getRoughRect();

    public final boolean isGasEnabled() {
        return this.m_gasEnabled;
    }
}

