/*
 * Decompiled with CFR 0.152.
 */
package physicon.ap.flux;

import java.awt.Dimension;
import java.awt.Point;
import physicon.controls.CUtil;
import physicon.objava3.CompositeTextBlock;
import physicon.objava3.EventSubscriber;
import physicon.objava3.SimWindow;
import physicon.objava3.more.ReliefDecoration;

class OutputBox
extends SimWindow
implements EventSubscriber {
    private CompositeTextBlock text;
    private int accuracy = 0;
    private double v;

    OutputBox(SimWindow parent, Point refpoint, Dimension size, String evtName, int accuracy) {
        super(parent, refpoint, size);
        new ReliefDecoration(this);
        this.accuracy = accuracy;
        this.subscribe(evtName, this);
    }

    public void receiveEvent(Object event) {
        double v = (Double)event;
        if (this.v == v) {
            return;
        }
        this.v = v;
        this.text.setString(CUtil.fString(v, this.accuracy));
        this.repaint();
    }

    void setCompositeTextBlock(CompositeTextBlock text) {
        if (this.text != null) {
            return;
        }
        this.text = text;
    }

    public void repaint() {
        this.paintAll();
        this.flushBuffer();
    }
}

