/*
 * Decompiled with CFR 0.152.
 */
package physicon.objava3.physics;

import java.awt.Dimension;
import java.awt.Point;
import physicon.controls.CUtil;
import physicon.objava3.CompositeTextBlock;
import physicon.objava3.SequenceController;
import physicon.objava3.SimConfig;
import physicon.objava3.SimWindow;
import physicon.objava3.more.ReliefDecoration;
import physicon.objava3.physics.BandCanvas;

public class FloatingBand
extends SimWindow
implements SequenceController {
    protected SimWindow output;
    private BandCanvas control;
    CompositeTextBlock text;
    private int accuracy = 0;
    private String m_eventChoiceName;
    private String m_eventSetName;

    public CUtil.ScaleDrawer getScaleDrawer() {
        return this.control.getScaleDrawer();
    }

    public void setScaleDrawer(CUtil.ScaleDrawer scaleDrawer) {
        this.control.setScaleDrawer(scaleDrawer);
    }

    public synchronized void setRange(double d, double d2) {
        this.control.setRange(d, d2);
    }

    public synchronized void setValue(double d) {
        this.text.setString(CUtil.fString(d, this.getAccuracy()));
        this.output.paintAll();
        this.output.flushBuffer();
        this.control.setValue(d);
    }

    public double getValue() {
        return this.control.getValue();
    }

    public synchronized void setMinValue(double d) {
        this.control.setMinValue(d);
    }

    public double getMinValue() {
        return this.control.getMinValue();
    }

    public FloatingBand(SimWindow simWindow, Point point, Dimension dimension, double d, double d2, double d3, double d4, String string, String string2) {
        this(simWindow, point, dimension, d, d2, d3, d4, string, string2, 40);
    }

    public FloatingBand(SimWindow simWindow, Point point, Dimension dimension, double d, double d2, double d3, double d4, String string, String string2, int n) {
        super(simWindow, point, dimension);
        this.setBkgColor(SimConfig.hostBkgColor);
        this.m_eventChoiceName = string;
        this.m_eventSetName = string2;
        this.accuracy = CUtil.getNumberOfSignificantDigits(d4);
        this.output = new SimWindow(this, new Point(), new Dimension(n, dimension.height));
        new ReliefDecoration(this.output);
        this.text = this.createTextBlock();
        this.text.setString(CUtil.fString(d, this.getAccuracy()));
        this.control = new BandCanvas(this, new Point(n + 5, 0), new Dimension(dimension.width - (n + 5), dimension.height), d, d2, d3, d4){
            {
                FloatingBand.this.getClass();
            }

            public void notifyChange() {
                double d = this.getValue();
                FloatingBand.this.text.setString(CUtil.fString(d, FloatingBand.this.getAccuracy()));
                FloatingBand.this.output.paintAll();
                FloatingBand.this.output.flushBuffer();
                FloatingBand.this.notifyChange();
            }

            public void notifyLast() {
                FloatingBand.this.notifyLast();
            }
        };
    }

    public int getAccuracy() {
        return this.accuracy;
    }

    public void setAccuracy(int n) {
        this.accuracy = n;
        this.getTextBlock().setString(CUtil.fString(this.getValue(), this.getAccuracy()));
    }

    public void removeScaleDrawer(CUtil.ScaleDrawer scaleDrawer) {
        this.control.removeScaleDrawer(scaleDrawer);
    }

    public CompositeTextBlock getTextBlock() {
        return this.text;
    }

    public void notifyLast() {
        if (this.m_eventSetName != null) {
            this.publishEvent(this.m_eventSetName, new Double(this.getValue()));
        }
    }

    public void notifyChange() {
        if (this.m_eventChoiceName != null) {
            this.publishEvent(this.m_eventChoiceName, new Double(this.getValue()));
        }
    }

    public synchronized void setMaxValue(double d) {
        this.control.setMaxValue(d);
    }

    public double getMaxValue() {
        return this.control.getMaxValue();
    }

    public synchronized void setStep(double d) {
        this.control.setStep(d);
    }

    public double getStep() {
        return this.control.getStep();
    }

    public void setStringValue(String string) {
        this.setValue(new Double(string));
        this.control.notifyChange();
        this.control.notifyLast();
    }

    public String getStringValue() {
        return "" + this.getValue();
    }

    public void addScaleDrawer(CUtil.ScaleDrawer scaleDrawer) {
        this.control.addScaleDrawer(scaleDrawer);
    }

    protected CompositeTextBlock createTextBlock() {
        return new CompositeTextBlock(this.output, new Point(5, this.getSize().height / 2), "\\:", "", "\\:", 33);
    }

    public int getSpace() {
        return this.control.getSpace();
    }

    public void setSpace(int n) {
        this.control.setSpace(n);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.control.setEnabled(bl);
    }
}

