/*
 * Decompiled with CFR 0.152.
 */
package physicon.objava3.physics;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import physicon.controls.CUtil;
import physicon.controls.Image1x1;
import physicon.controls.ViewPane;
import physicon.controls.mart.SButton;
import physicon.objava3.SequenceController;
import physicon.objava3.SimButton;
import physicon.objava3.SimConfig;
import physicon.objava3.SimSlider;
import physicon.objava3.SimWindow;

public abstract class BandCanvas
extends SimWindow
implements SequenceController {
    private CUtil.ScaleDrawer scale;
    private SimButton leftBtn;
    private SimButton rightBtn;
    private SimSlider slider;
    ViewPane band;
    Image m_pointerImageUpper = new Image1x1("uwlpointer.gif");
    private int space = 4;
    private int bandHeight = 19;
    int bandWidth;
    Image buffer;
    private Vector scaleDrawers = new Vector();

    public CUtil.ScaleDrawer getScaleDrawer() {
        return this.scale;
    }

    public void setScaleDrawer(CUtil.ScaleDrawer scaleDrawer) {
        this.scale = scaleDrawer;
    }

    public void setRange(double d, double d2) {
        double d3 = this.getMinValue();
        double d4 = this.getMaxValue();
        this.slider.setRange(d, d2);
        if (d3 == this.getMinValue() && d4 == this.getMaxValue()) {
            return;
        }
        this.scale.setMin(this.getMinValue());
        this.scale.setMax(this.getMaxValue());
        this.updateBandImage();
    }

    public void setValue(double d) {
        this.slider.setValue(d);
        int n = (int)Math.round((double)this.bandWidth * (this.getValue() - this.getMinValue()) / (this.getMaxValue() - this.getMinValue()));
        this.band.setXPos(n);
    }

    public double getValue() {
        return this.slider.getValue();
    }

    public void setMinValue(double d) {
        this.slider.setMinValue(d);
        this.scale.setMin(d);
        this.updateBandImage();
    }

    public double getMinValue() {
        return this.slider.getMinValue();
    }

    public void onCreate() {
        super.onCreate();
        this.buffer = this.getComponent().createImage(this.getSize().width, this.bandHeight);
        this.updateBandImage();
    }

    public BandCanvas(SimWindow simWindow, Point point, Dimension dimension, double d, double d2, double d3, double d4) {
        super(simWindow, point, dimension);
        this.setBkgColor(SimConfig.hostBkgColor);
        this.setScaleDrawer(new CUtil.ScaleDrawer(d2, d3, 10.0 * d4, 10, SimConfig.SCALE_FONT_COLOR));
        this.band = new ViewPane(){

            public void paint(Graphics graphics) {
                Graphics graphics2 = BandCanvas.this.buffer.getGraphics();
                super.paint(graphics2);
                BandCanvas.this.getFactory().drawRelief(graphics2, 0, 0, this.getSize().width, this.getSize().height, null, this);
                CUtil.drawImage(graphics2, BandCanvas.this.m_pointerImageUpper, (this.getSize().width - BandCanvas.this.m_pointerImageUpper.getWidth(this)) / 2, 0, null, this);
                graphics.drawImage(BandCanvas.this.buffer, 0, 0, this);
            }
            {
                BandCanvas.this.getClass();
            }

            public void update(Graphics graphics) {
                this.paint(graphics);
            }
        };
        this.band.addActionListener(new ActionListener(){
            {
                BandCanvas.this.getClass();
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getID() == -1) {
                    double d = BandCanvas.this.getValue();
                    BandCanvas.this.setValue(BandCanvas.this.getMinValue() + (BandCanvas.this.getMaxValue() - BandCanvas.this.getMinValue()) * (double)BandCanvas.this.band.getXPos() / (double)BandCanvas.this.bandWidth);
                    if (d != BandCanvas.this.getValue()) {
                        BandCanvas.this.notifyChange();
                        return;
                    }
                } else {
                    BandCanvas.this.notifyLast();
                }
            }
        });
        this.band.addMouseListener(this);
        this.band.setBounds(0, 0, dimension.width, this.bandHeight);
        Image1x1 image1x1 = new Image1x1("eleftbtn.gif");
        Dimension dimension2 = new Dimension(((Image)image1x1).getWidth(null), ((Image)image1x1).getHeight(null));
        this.leftBtn = new SimButton(this, new Point(0, this.bandHeight), dimension2, "", null){

            public void onCreate() {
                super.onCreate();
                ((SButton)this.getComponent().getComponent(0)).setSkin(new Image1x1("eleftbtn.gif"), new Image1x1("dleftbtn.gif"), new Image1x1("pleftbtn.gif"));
            }
            {
                BandCanvas.this.getClass();
            }

            public void notifyChange() {
                if (BandCanvas.this.getValue() <= BandCanvas.this.getMinValue()) {
                    return;
                }
                BandCanvas.this.setValue(BandCanvas.this.getValue() - BandCanvas.this.getStep());
                BandCanvas.this.notifyChange();
            }

            public void notifyLast() {
                BandCanvas.this.notifyLast();
            }
        };
        this.rightBtn = new SimButton(this, new Point(dimension.width - dimension2.width, this.bandHeight), dimension2, "", null){

            public void onCreate() {
                super.onCreate();
                ((SButton)this.getComponent().getComponent(0)).setSkin(new Image1x1("erightbtn.gif"), new Image1x1("drightbtn.gif"), new Image1x1("prightbtn.gif"));
            }
            {
                BandCanvas.this.getClass();
            }

            public void notifyChange() {
                if (BandCanvas.this.getValue() >= BandCanvas.this.getMaxValue()) {
                    return;
                }
                BandCanvas.this.setValue(BandCanvas.this.getValue() + BandCanvas.this.getStep());
                BandCanvas.this.notifyChange();
            }

            public void notifyLast() {
                BandCanvas.this.notifyLast();
            }
        };
        this.slider = new SimSlider(this, new Point(dimension2.width, this.bandHeight), new Dimension(dimension.width - 2 * dimension2.width, dimension2.height), d, d2, d3, d4, 3, new String[0], null, null){
            {
                BandCanvas.this.getClass();
            }

            public void notifyChange() {
                int n = (int)Math.round((double)BandCanvas.this.bandWidth * (this.getValue() - this.getMinValue()) / (this.getMaxValue() - this.getMinValue()));
                BandCanvas.this.band.setXPos(n);
                BandCanvas.this.notifyChange();
            }

            public void notifyLast() {
                BandCanvas.this.notifyLast();
            }
        };
        this.slider.setPaintTicks(false);
    }

    private void drawScale(Graphics graphics, CUtil.ScaleDrawer scaleDrawer) {
        int n = this.getSize().width / 2 + (int)Math.round((double)this.getSpace() * (scaleDrawer.getMin() - this.getMinValue()) / this.getStep());
        int n2 = (int)Math.round((double)this.getSpace() * (scaleDrawer.getMax() - scaleDrawer.getMin()) / this.getStep());
        scaleDrawer.draw(graphics, new Rectangle(n, 2, n2, this.bandHeight - 2));
    }

    public void removeScaleDrawer(CUtil.ScaleDrawer scaleDrawer) {
        this.scaleDrawers.removeElement(scaleDrawer);
        if (this.isCreated()) {
            this.updateBandImage();
        }
    }

    public abstract void notifyLast();

    public abstract void notifyChange();

    private void updateBandImage() {
        if (!this.isCreated()) {
            return;
        }
        Dimension dimension = this.getSize();
        this.bandWidth = (int)Math.round((double)this.getSpace() * (this.getMaxValue() - this.getMinValue()) / this.getStep());
        Image image = this.getComponent().createImage(dimension.width + this.bandWidth, this.bandHeight);
        Graphics graphics = image.getGraphics();
        graphics.setColor(SimConfig.bkgColor);
        graphics.fillRect(0, 0, dimension.width + this.bandWidth, this.bandHeight);
        graphics.setFont(new Font(SimConfig.CONTROL_FONT.getFamily(), SimConfig.CONTROL_FONT.getStyle(), 10));
        int n = 0;
        while (n < this.scaleDrawers.size()) {
            this.drawScale(graphics, (CUtil.ScaleDrawer)this.scaleDrawers.elementAt(n));
            ++n;
        }
        this.getScaleDrawer().draw(graphics, new Rectangle(dimension.width / 2, 2, this.bandWidth, this.bandHeight - 2));
        this.band.setImage(image);
        this.band.setXstep(this.getSpace());
        n = (int)Math.round((double)this.bandWidth * (this.getValue() - this.getMinValue()) / (this.getMaxValue() - this.getMinValue()));
        this.band.setXPos(n);
    }

    public void setMaxValue(double d) {
        this.slider.setMaxValue(d);
        this.scale.setMax(d);
        this.updateBandImage();
    }

    public double getMaxValue() {
        return this.slider.getMaxValue();
    }

    public double getStep() {
        return this.slider.getStep();
    }

    public void setStep(double d) {
        this.slider.setStep(d);
        this.updateBandImage();
    }

    public void addScaleDrawer(CUtil.ScaleDrawer scaleDrawer) {
        this.scaleDrawers.addElement(scaleDrawer);
        if (this.isCreated()) {
            this.updateBandImage();
        }
    }

    public int getSpace() {
        return this.space;
    }

    public void setSpace(int n) {
        this.space = n;
        this.updateBandImage();
    }

    public Panel createComponent() {
        Panel panel = super.createComponent();
        panel.add(this.band);
        return panel;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.slider.setEnabled(bl);
        this.leftBtn.setEnabled(bl);
        this.rightBtn.setEnabled(bl);
    }
}

