/*
 * Decompiled with CFR 0.152.
 */
package physicon.objava3.more;

public final class Complex {
    public double r = 0.0;
    public double i = 0.0;

    public Complex() {
        this(0.0, 0.0);
    }

    public Complex(double d, double d2) {
        this.r = d;
        this.i = d2;
    }

    public static Complex add(Complex complex, double d) {
        return new Complex(complex.r + d, complex.i);
    }

    public static Complex add(Complex complex, Complex complex2) {
        return new Complex(complex.r + complex2.r, complex.i + complex2.i);
    }

    public static Complex exp(Complex complex) {
        double d = Math.exp(complex.r);
        return new Complex(Math.cos(complex.i) * d, Math.sin(complex.i) * d);
    }

    public static Complex sqrt(Complex complex) {
        double d;
        double d2;
        Complex complex2 = new Complex();
        if (complex.r == 0.0 && complex.i == 0.0) {
            complex2.r = 0.0;
            complex2.i = 0.0;
            return complex2;
        }
        double d3 = Math.abs(complex.r);
        if (d3 >= (d2 = Math.abs(complex.i))) {
            double d4 = d2 / d3;
            d = Math.sqrt(d3) * Math.sqrt(0.5 * (1.0 + Math.sqrt(1.0 + d4 * d4)));
        } else {
            double d5 = d3 / d2;
            d = Math.sqrt(d2) * Math.sqrt(0.5 * (d5 + Math.sqrt(1.0 + d5 * d5)));
        }
        if (complex.r >= 0.0) {
            complex2.r = d;
            complex2.i = complex.i / (2.0 * d);
        } else {
            complex2.i = complex.i >= 0.0 ? d : -d;
            complex2.r = complex.i / (2.0 * complex2.i);
        }
        return complex2;
    }

    public static Complex sub(Complex complex, double d) {
        return new Complex(complex.r - d, complex.i);
    }

    public static Complex sub(Complex complex, Complex complex2) {
        return new Complex(complex.r - complex2.r, complex.i - complex2.i);
    }

    public static double abs(Complex complex) {
        double d;
        double d2 = Math.abs(complex.r);
        double d3 = Math.abs(complex.i);
        if (d2 == 0.0) {
            d = d3;
        } else if (d3 == 0.0) {
            d = d2;
        } else if (d2 > d3) {
            double d4 = d3 / d2;
            d = d2 * Math.sqrt(1.0 + d4 * d4);
        } else {
            double d5 = d2 / d3;
            d = d3 * Math.sqrt(1.0 + d5 * d5);
        }
        return d;
    }

    public static Complex mul(Complex complex, double d) {
        return new Complex(complex.r * d, complex.i * d);
    }

    public static Complex mul(Complex complex, Complex complex2) {
        return new Complex(complex.r * complex2.r - complex.i * complex2.i, complex.i * complex2.r + complex.r * complex2.i);
    }

    public static Complex div(Complex complex, double d) {
        return new Complex(complex.r / d, complex.i / d);
    }

    public static Complex div(double d, Complex complex) {
        return Complex.div(new Complex(d, 0.0), complex);
    }

    public static Complex div(Complex complex, Complex complex2) {
        Complex complex3 = new Complex();
        if (complex2.r == 0.0) {
            complex3.r = complex.i / complex2.i;
            complex3.i = -(complex.r / complex2.i);
        } else if (Math.abs(complex2.r) >= Math.abs(complex2.i)) {
            double d = complex2.i / complex2.r;
            double d2 = complex2.r + d * complex2.i;
            complex3.r = (complex.r + d * complex.i) / d2;
            complex3.i = (complex.i - d * complex.r) / d2;
        } else if (complex2.i == 0.0) {
            complex3.r = complex.r / complex2.r;
            complex3.i = complex.i / complex2.i;
        } else {
            double d = complex2.r / complex2.i;
            double d3 = complex2.i + d * complex2.r;
            complex3.r = (complex.r * d + complex.i) / d3;
            complex3.i = (complex.i * d - complex.r) / d3;
        }
        return complex3;
    }

    public static Complex conj(Complex complex) {
        return new Complex(complex.r, -complex.i);
    }
}

