/*
 * Decompiled with CFR 0.152.
 */
package physicon.objava3;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.Toolkit;
import physicon.objava3.SimConfig;
import physicon.objava3.SimObject;
import physicon.objava3.TextRegion;

public class TextDecoration
extends TextRegion {
    private Font m_font;
    private Color m_color;

    public void drawContent(Graphics graphics) {
        Toolkit toolkit = ((Component)((Object)this.getHost().getHostContainer())).getToolkit();
        FontMetrics fontMetrics = toolkit.getFontMetrics(this.m_font);
        graphics.drawString(this.m_string, 0, this.getHeight() - fontMetrics.getDescent());
    }

    public TextDecoration(SimObject simObject, Point point, String string, int n, Font font, Color color) {
        super(simObject, point, string, n);
        this.m_font = font;
        this.m_color = color;
    }

    public TextDecoration(SimObject simObject, Point point, String string, int n, Color color) {
        this(simObject, point, string, n, SimConfig.OUTPUT_FONT, color);
    }

    public TextDecoration(SimObject simObject, Point point, String string) {
        this(simObject, point, string, 0, SystemColor.controlText);
    }

    public void setColor(Color color) {
        this.m_color = color;
    }

    public void paint(Graphics graphics) {
        Color color = graphics.getColor();
        Font font = graphics.getFont();
        graphics.setColor(this.m_color);
        graphics.setFont(this.m_font);
        super.paint(graphics);
        graphics.setColor(color);
        graphics.setFont(font);
    }

    public void setFont(Font font) {
        this.m_font = font;
    }

    public int getHeight() {
        Toolkit toolkit = ((Component)((Object)this.getHost().getHostContainer())).getToolkit();
        FontMetrics fontMetrics = toolkit.getFontMetrics(this.m_font);
        return fontMetrics.getHeight();
    }

    public int getWidth() {
        Toolkit toolkit = ((Component)((Object)this.getHost().getHostContainer())).getToolkit();
        FontMetrics fontMetrics = toolkit.getFontMetrics(this.m_font);
        return fontMetrics.stringWidth(this.m_string);
    }
}

