/*
 * Decompiled with CFR 0.152.
 */
package physicon.objava3;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.util.ResourceBundle;
import physicon.controls.IFactory;
import physicon.graphLib2.GraphLibData;
import physicon.objava3.SimConstants;

public class SimConfig
implements SimConstants {
    public static final ResourceBundle res = ResourceBundle.getBundle("physicon.objava3.SimResources");
    public static IFactory factory;
    public static Font SCALE_FONT;
    public static Color SCALE_FONT_COLOR;
    public static Font OUTPUT_FONT;
    public static Color OUTPUT_FONT_COLOR;
    public static Font CONTROL_FONT;
    public static Color CONTROL_FONT_COLOR;
    public static Font PICTURE_FONT;
    public static Color PICTURE_FONT_COLOR;
    public static Color hostBkgColor;
    public static Color bkgColor;
    public static final Dimension stdBtnSize;
    public static final int MACINTOSH = 1;
    public static final int WINDOWS = 2;
    public static final int UNKNOWN = 4;

    protected static final void updateUI() {
        SCALE_FONT = (Font)factory.getAxisFont()[0];
        SCALE_FONT_COLOR = (Color)factory.getAxisFont()[1];
        OUTPUT_FONT = (Font)factory.getOutputFont()[0];
        OUTPUT_FONT_COLOR = (Color)factory.getOutputFont()[1];
        CONTROL_FONT = (Font)factory.getControlFont()[0];
        CONTROL_FONT_COLOR = (Color)factory.getControlFont()[1];
        PICTURE_FONT = (Font)factory.getPictureFont()[0];
        PICTURE_FONT_COLOR = (Color)factory.getPictureFont()[1];
        hostBkgColor = factory.getHostColor();
        int n = ((bkgColor = factory.getPanelColor()).getRed() + bkgColor.getGreen() + bkgColor.getBlue()) / 3;
        GraphLibData.updateUI(SCALE_FONT, SCALE_FONT_COLOR, bkgColor, n > 150 ? Color.lightGray : Color.gray);
    }

    static {
        try {
            Class<?> clazz = Class.forName(res.getString("factory"));
            factory = (IFactory)clazz.newInstance();
            SimConfig.updateUI();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("Can't load control factory " + res.getString("factory"));
        }
        stdBtnSize = new Dimension(64, 22);
    }

    public static int getOSType() {
        String string = System.getProperty("os.name").toLowerCase();
        if (string.indexOf("windows") != -1) {
            return 2;
        }
        if (string.indexOf("mac") != -1) {
            return 1;
        }
        return 4;
    }
}

