/*
 * Decompiled with CFR 0.152.
 */
package physicon.metatex3;

import java.util.Vector;
import physicon.metatex3.Block;
import physicon.metatex3.TagParser;

public class LeftindexBlock
extends Block
implements TagParser {
    private static String HANDLED_TAG = "leftindex";

    public boolean testArgs(Vector vector) {
        return vector.size() == 3;
    }

    public Block parseTag(String string) {
        if (string.equals("leftindex")) {
            return new LeftindexBlock();
        }
        throw new IllegalArgumentException(string + " is not supported by " + this.getClass().getName());
    }

    public LeftindexBlock() {
        super(3);
    }

    public void sizeSelf() {
        Block block = this.blocks[0];
        Block block2 = this.blocks[1];
        Block block3 = this.blocks[2];
        int n = Math.max(block.width, block2.width);
        this.width = n + this.blocks[2].width + 2;
        double d = 0.15;
        double d2 = 0.5;
        double d3 = 0.4;
        int n2 = this.blocks[0].getHeight();
        int n3 = this.blocks[1].getHeight();
        int n4 = (int)(d2 * (double)n2);
        int n5 = (int)((1.0 - d2) * (double)n2);
        int n6 = (int)((1.0 - d3) * (double)n3);
        int n7 = (int)(d3 * (double)n3);
        int n8 = (int)((double)block3.getHeight() * d);
        if (block3.ascent - n5 < n8) {
            n4 = n2 + n8 - block3.ascent;
        }
        this.ascent = block3.ascent + n4;
        if (this.ascent + block3.descent - n6 < this.ascent + n8) {
            n6 = block3.descent - n8;
            n7 = n3 - n6;
        }
        this.descent = block3.descent + n7;
        this.coords[0].x = n - block.width;
        this.coords[0].y = 0;
        this.coords[1].x = n - block2.width;
        this.coords[1].y = this.ascent + block3.descent - n6;
        this.coords[2].x = n + 2;
        this.coords[2].y = n4;
    }

    public int getArgType(int n) {
        if (n < 3) {
            return 1;
        }
        return -1;
    }

    public String[] getHandledTags() {
        return new String[]{HANDLED_TAG};
    }

    protected void setChildrenScale(int n) {
        this.blocks[0].setScale(n - 1);
        this.blocks[1].setScale(n - 1);
        this.blocks[2].setScale(n);
    }
}

