/*
 * Decompiled with CFR 0.152.
 */
package physicon.metatex3;

import java.awt.Image;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import physicon.metatex3.CharCoder;
import physicon.metatex3.CharacterProcessor;
import physicon.metatex3.ExtraSymbolProcessor;
import physicon.metatex3.ImageCreator;
import physicon.metatex3.MetaTexFont;
import physicon.metatex3.ResourceLoader;
import physicon.metatex3.SpecialSymbolProcessor;
import physicon.metatex3.SymbolProcessor;

public class FontCache {
    static Hashtable font2SymbolMetric = new Hashtable();
    static Hashtable font2ExtraMetric = new Hashtable();
    static Hashtable font2CharMetric = new Hashtable();
    static Hashtable font2SymbolImageData = new Hashtable();
    static Hashtable font2ExtraImageData = new Hashtable();
    static Hashtable font2CharImageData = new Hashtable();
    static Vector loadedFonts = new Vector();

    public static Image getSymbolImage(MetaTexFont metaTexFont, String string) {
        int[] nArray = FontCache.getSymbolMetric(metaTexFont, string);
        byte[] byArray = (byte[])font2SymbolImageData.get(metaTexFont);
        return FontCache.createImage(byArray, nArray);
    }

    public static Image getExtraImage(MetaTexFont metaTexFont, String string) {
        int[] nArray = FontCache.getExtraMetric(metaTexFont, string);
        byte[][] byArray = (byte[][])font2ExtraImageData.get(metaTexFont);
        return FontCache.createImage(byArray[metaTexFont.getStyle() & 3], nArray);
    }

    private static Image createImage(byte[] byArray, int[] nArray) {
        FilteredImageSource filteredImageSource = new FilteredImageSource(ImageCreator.createImage(byArray).getSource(), new CropImageFilter(nArray[7], nArray[8], nArray[0], nArray[1]));
        Image image = ImageCreator.createImage(filteredImageSource);
        return image;
    }

    public static int[] getSymbolMetric(MetaTexFont metaTexFont, String string) {
        Hashtable hashtable = (Hashtable)font2SymbolMetric.get(metaTexFont);
        return (int[])hashtable.get(string);
    }

    public static synchronized int[] getExtraMetric(MetaTexFont metaTexFont, String string) {
        Hashtable[] hashtableArray = (Hashtable[])font2ExtraMetric.get(metaTexFont);
        return (int[])hashtableArray[metaTexFont.getStyle() & 3].get(string);
    }

    public static synchronized void loadFont(MetaTexFont metaTexFont, Class clazz) {
        if (!loadedFonts.contains(metaTexFont)) {
            FontCache.doLoadFont(metaTexFont, clazz);
            loadedFonts.addElement(metaTexFont);
        }
    }

    private static void doLoadFont(MetaTexFont metaTexFont, Class clazz) {
        String string = "fonts/" + metaTexFont.getFamily() + "-" + metaTexFont.getSize();
        byte[][] byArrayArray = new byte[4][];
        font2CharImageData.put(metaTexFont, byArrayArray);
        Hashtable[] hashtableArray = new Hashtable[4];
        int n = 0;
        while (n < hashtableArray.length) {
            hashtableArray[n] = new Hashtable();
            ++n;
        }
        font2CharMetric.put(metaTexFont, hashtableArray);
        byArrayArray = new byte[4][];
        font2ExtraImageData.put(metaTexFont, byArrayArray);
        hashtableArray = new Hashtable[4];
        n = 0;
        while (n < hashtableArray.length) {
            hashtableArray[n] = new Hashtable();
            ++n;
        }
        font2ExtraMetric.put(metaTexFont, hashtableArray);
        font2SymbolMetric.put(metaTexFont, new Hashtable());
        SymbolProcessor symbolProcessor = new CharacterProcessor(metaTexFont.getStyled(0));
        FontCache.loadFile(string + "-char-" + 0, clazz, symbolProcessor);
        symbolProcessor = new CharacterProcessor(metaTexFont.getStyled(1));
        FontCache.loadFile(string + "-char-" + 1, clazz, symbolProcessor);
        symbolProcessor = new CharacterProcessor(metaTexFont.getStyled(2));
        FontCache.loadFile(string + "-char-" + 2, clazz, symbolProcessor);
        symbolProcessor = new CharacterProcessor(metaTexFont.getStyled(3));
        FontCache.loadFile(string + "-char-" + 3, clazz, symbolProcessor);
        symbolProcessor = new ExtraSymbolProcessor(metaTexFont.getStyled(0));
        FontCache.loadFile(string + "-extra-" + 0, clazz, symbolProcessor);
        symbolProcessor = new ExtraSymbolProcessor(metaTexFont.getStyled(1));
        FontCache.loadFile(string + "-extra-" + 1, clazz, symbolProcessor);
        symbolProcessor = new ExtraSymbolProcessor(metaTexFont.getStyled(2));
        FontCache.loadFile(string + "-extra-" + 2, clazz, symbolProcessor);
        symbolProcessor = new ExtraSymbolProcessor(metaTexFont.getStyled(3));
        FontCache.loadFile(string + "-extra-" + 3, clazz, symbolProcessor);
        symbolProcessor = new SpecialSymbolProcessor(metaTexFont);
        FontCache.loadFile(string + "-symbol", clazz, symbolProcessor);
    }

    private static void loadFile(String string, Class clazz, SymbolProcessor symbolProcessor) {
        String string2 = string + ".gif";
        String string3 = string + ".txt";
        int n = 0;
        try {
            String string4;
            LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(ResourceLoader.getResourceStream(string3, clazz)));
            BufferedInputStream bufferedInputStream = new BufferedInputStream(ResourceLoader.getResourceStream(string2, clazz), 8);
            int n2 = ((InputStream)bufferedInputStream).available();
            byte[] byArray = new byte[n2];
            ((InputStream)bufferedInputStream).read(byArray);
            symbolProcessor.memorizeImageData(byArray);
            while ((string4 = lineNumberReader.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string4, " \t");
                String string5 = CharCoder.toWin1251(stringTokenizer.nextToken());
                int[] nArray = new int[9];
                int n3 = 0;
                do {
                    int n4 = Integer.parseInt(stringTokenizer.nextToken());
                    if (n3 == 0) {
                        nArray[7] = n4;
                        continue;
                    }
                    if (n3 == 1) {
                        nArray[8] = n4;
                        continue;
                    }
                    nArray[n3 - 2] = n4;
                } while (++n3 < 9);
                symbolProcessor.processMetrics(string5, nArray);
                ++n;
            }
            return;
        }
        catch (Exception exception) {
            String string6 = "Failed to load font file due to: " + exception + ". Error at line " + n;
            System.err.println(string6);
            exception.printStackTrace();
            throw new RuntimeException(string6);
        }
    }

    public static Image getCharImage(MetaTexFont metaTexFont, String string) {
        int[] nArray = FontCache.getCharMetric(metaTexFont, string);
        byte[][] byArray = (byte[][])font2CharImageData.get(metaTexFont);
        return FontCache.createImage(byArray[metaTexFont.getStyle() & 3], nArray);
    }

    public static synchronized boolean testSymbol(MetaTexFont metaTexFont, String string) {
        return FontCache.getSymbolMetric(metaTexFont, string) != null || FontCache.getExtraMetric(metaTexFont, string) != null;
    }

    public static int[] getCharMetric(MetaTexFont metaTexFont, String string) {
        Hashtable[] hashtableArray = (Hashtable[])font2CharMetric.get(metaTexFont);
        return (int[])hashtableArray[metaTexFont.getStyle() & 3].get(string);
    }
}

