/*
 * Decompiled with CFR 0.152.
 */
package physicon.graphLib2;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import physicon.graphLib2.DrawerBase;
import physicon.graphLib2.GraphLibData;

public abstract class LineDrawer
extends DrawerBase {
    Point p1 = new Point(0, 0);
    Point p2 = new Point(0, 0);
    double len = 0.0;
    double cos;
    double sin;
    Color color;

    public LineDrawer() {
        this(GraphLibData.scaleColor);
    }

    public LineDrawer(Color color) {
        this.color = color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Point getLastPoint() {
        return new Point(this.p2.x, this.p2.y);
    }

    public Rectangle getLocalRoughRect() {
        Rectangle rectangle = new Rectangle(this.p1.x, this.p1.y, this.p2.x - this.p1.x, this.p2.y - this.p1.y);
        if (rectangle.width < 0) {
            rectangle.width = -rectangle.width;
            rectangle.x -= rectangle.width;
        }
        if (rectangle.height < 0) {
            rectangle.height = -rectangle.height;
            rectangle.y -= rectangle.height;
        }
        rectangle.grow(1, 1);
        return rectangle;
    }

    public void setPoints(Point point, Point point2) {
        this.p1 = new Point(point);
        this.p2 = new Point(point2);
        double d = this.p2.x - this.p1.x;
        double d2 = this.p2.y - this.p1.y;
        this.len = Math.sqrt(d * d + d2 * d2);
        if (this.len != 0.0) {
            this.cos = d / this.len;
            this.sin = d2 / this.len;
        }
    }

    public Point getFirstPoint() {
        return new Point(this.p1.x, this.p1.y);
    }
}

