/*
 * Decompiled with CFR 0.152.
 */
package physicon.ap.flux;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import physicon.ap.flux.Apparatus;
import physicon.ap.flux.Data;
import physicon.graphLib2.DoublePoint;
import physicon.objava3.DecUtil;

class Physics {
    private static final int DRAWARROW = 60;
    private static final double ACCU = 1.0;
    private Apparatus apparat;
    private double charge1Value;
    private double charge2Value;
    private double delta1Angle;
    private double start1Angle;
    private double delta2Angle;
    private double start2Angle;
    private boolean isOneCharge = true;
    private double pixelDistanceHalf;
    private double globalRadius;
    private Rectangle parentRect;

    Physics(Apparatus apparat) {
        this.apparat = apparat;
        this.pixelDistanceHalf = 0.0;
        this.needUpdate(3.0, -3.0, 98.0, true);
        this.globalRadius = this.hypot(apparat.getSize().width / 2, apparat.getSize().height / 2);
        this.parentRect = new Rectangle(-apparat.getSize().width / 2, -apparat.getSize().height / 2, apparat.getSize().width, apparat.getSize().height);
    }

    void needUpdate(double q1, double q2, double d, boolean isOneCharge) {
        this.charge1Value = q1;
        if (this.charge1Value == 0.0) {
            this.start1Angle = Math.PI;
        } else {
            this.delta1Angle = Math.PI * 2 / (0.0 + 6.0 * (this.charge1Value > 0.0 ? this.charge1Value : -this.charge1Value));
            this.start1Angle = 0.5 * this.delta1Angle;
        }
        this.charge2Value = q2;
        if (this.charge2Value == 0.0) {
            this.start2Angle = Math.PI;
        } else {
            this.delta2Angle = Math.PI * 2 / (0.0 + 6.0 * (this.charge2Value > 0.0 ? this.charge2Value : -this.charge2Value));
            this.start2Angle = 0.5 * this.delta2Angle;
        }
        this.pixelDistanceHalf = isOneCharge ? 0.0 : d;
        this.isOneCharge = isOneCharge;
    }

    void show(Graphics gc) {
        int rpx = this.apparat.getSize().width / 2;
        int rpy = this.apparat.getSize().height / 2;
        gc.translate(rpx, rpy);
        gc.setColor(Data.fieldColor);
        if (this.isOneCharge) {
            double angle = this.start1Angle;
            while (angle < Math.PI) {
                this.drawPolarVector(gc, new DoublePoint(0.0, 0.0), angle, this.globalRadius, this.charge1Value > 0.0);
                this.drawPolarVector(gc, new DoublePoint(0.0, 0.0), -angle, this.globalRadius, this.charge1Value > 0.0);
                angle += this.delta1Angle;
            }
        } else if (Math.abs(this.charge1Value) >= Math.abs(this.charge2Value) || this.charge1Value * this.charge2Value >= 0.0) {
            DoublePoint addVector;
            DoublePoint sopVector;
            DoublePoint curVector;
            double end2Angle = Math.PI;
            int drawArrow = 0;
            double angle = this.start1Angle;
            while (angle < Math.PI) {
                curVector = this.getInitVector(-this.pixelDistanceHalf, angle);
                sopVector = new DoublePoint(curVector.x, -curVector.y);
                boolean nextStep = false;
                do {
                    addVector = this.getCorrection(curVector, this.charge1Value > 0.0);
                    if (drawArrow == 60) {
                        this.drawIndefPointer(gc, curVector, this.addDP(curVector, addVector), this.charge1Value > 0.0);
                    }
                    this.drawLine(gc, curVector, this.addDP(curVector, addVector));
                    curVector = this.addDP(curVector, addVector);
                    addVector.y = -addVector.y;
                    if (++drawArrow > 60) {
                        drawArrow = 0;
                        this.drawIndefPointer(gc, sopVector, this.addDP(sopVector, addVector), this.charge1Value > 0.0);
                    }
                    this.drawLine(gc, sopVector, this.addDP(sopVector, addVector));
                    sopVector = this.addDP(sopVector, addVector);
                    nextStep = false;
                    if (!this.satisfactionField(curVector)) continue;
                    if (this.satisfactionHole(curVector, false)) {
                        nextStep = true;
                        continue;
                    }
                    end2Angle -= this.delta2Angle;
                } while (nextStep);
                angle += this.delta1Angle;
            }
            drawArrow = 0;
            angle = this.start2Angle;
            while (angle < end2Angle) {
                curVector = this.getInitVector(this.pixelDistanceHalf, angle);
                sopVector = new DoublePoint(curVector.x, -curVector.y);
                do {
                    addVector = this.getCorrection(curVector, this.charge2Value > 0.0);
                    if (drawArrow == 60) {
                        this.drawIndefPointer(gc, curVector, this.addDP(curVector, addVector), this.charge2Value > 0.0);
                    }
                    this.drawLine(gc, curVector, this.addDP(curVector, addVector));
                    curVector = this.addDP(curVector, addVector);
                    addVector.y = -addVector.y;
                    if (++drawArrow > 60) {
                        drawArrow = 0;
                        this.drawIndefPointer(gc, sopVector, this.addDP(sopVector, addVector), this.charge2Value > 0.0);
                    }
                    this.drawLine(gc, sopVector, this.addDP(sopVector, addVector));
                    sopVector = this.addDP(sopVector, addVector);
                } while (this.satisfactionField(curVector) && this.satisfactionHole(curVector, true));
                angle += this.delta2Angle;
            }
        } else {
            DoublePoint addVector;
            DoublePoint sopVector;
            DoublePoint curVector;
            double end1Angle = Math.PI;
            int drawArrow = 0;
            double angle = this.start2Angle;
            while (angle < Math.PI) {
                curVector = this.getInitVector(this.pixelDistanceHalf, angle);
                sopVector = new DoublePoint(curVector.x, -curVector.y);
                boolean nextStep = false;
                do {
                    addVector = this.getCorrection(curVector, this.charge2Value > 0.0);
                    if (drawArrow == 60) {
                        this.drawIndefPointer(gc, curVector, this.addDP(curVector, addVector), this.charge2Value > 0.0);
                    }
                    this.drawLine(gc, curVector, this.addDP(curVector, addVector));
                    curVector = this.addDP(curVector, addVector);
                    addVector.y = -addVector.y;
                    if (++drawArrow > 60) {
                        drawArrow = 0;
                        this.drawIndefPointer(gc, sopVector, this.addDP(sopVector, addVector), this.charge2Value > 0.0);
                    }
                    this.drawLine(gc, sopVector, this.addDP(sopVector, addVector));
                    sopVector = this.addDP(sopVector, addVector);
                    nextStep = false;
                    if (!this.satisfactionField(curVector)) continue;
                    if (this.satisfactionHole(curVector, true)) {
                        nextStep = true;
                        continue;
                    }
                    end1Angle -= this.delta1Angle;
                } while (nextStep);
                angle += this.delta2Angle;
            }
            drawArrow = 0;
            angle = Math.PI - this.start1Angle;
            while (angle > Math.PI - end1Angle) {
                curVector = this.getInitVector(-this.pixelDistanceHalf, angle);
                sopVector = new DoublePoint(curVector.x, -curVector.y);
                do {
                    addVector = this.getCorrection(curVector, this.charge1Value > 0.0);
                    if (drawArrow == 60) {
                        this.drawIndefPointer(gc, curVector, this.addDP(curVector, addVector), this.charge1Value > 0.0);
                    }
                    this.drawLine(gc, curVector, this.addDP(curVector, addVector));
                    curVector = this.addDP(curVector, addVector);
                    addVector.y = -addVector.y;
                    if (++drawArrow > 60) {
                        drawArrow = 0;
                        this.drawIndefPointer(gc, sopVector, this.addDP(sopVector, addVector), this.charge1Value > 0.0);
                    }
                    this.drawLine(gc, sopVector, this.addDP(sopVector, addVector));
                    sopVector = this.addDP(sopVector, addVector);
                } while (this.satisfactionField(curVector) && this.satisfactionHole(curVector, false));
                angle -= this.delta1Angle;
            }
        }
        gc.translate(-rpx, -rpy);
    }

    private void drawPolarVector(Graphics gc, DoublePoint _stPoint, double _angle, double _radius, boolean isPositive) {
        int dx = (int)Math.round(_radius * Math.cos(_angle));
        int dy = (int)Math.round(_radius * Math.sin(_angle));
        gc.drawLine((int)Math.round(_stPoint.x), (int)Math.round(_stPoint.y), (int)Math.round(_stPoint.x + (double)dx), (int)Math.round(_stPoint.y + (double)dy));
        double sx = isPositive ? _stPoint.x : _stPoint.x + (double)dx;
        double sy = isPositive ? _stPoint.y : _stPoint.y + (double)dy;
        this.drawPointer(gc, sx, sy, _stPoint.x + (double)dx / 2.0, _stPoint.y + (double)dy / 2.0);
    }

    private void drawIndefPointer(Graphics gc, DoublePoint _stPoint, DoublePoint _endPoint, boolean _dir) {
        double dx = 14.0 * (_endPoint.x - _stPoint.x);
        double dy = 14.0 * (_endPoint.y - _stPoint.y);
        if (_dir) {
            this.drawPointer(gc, _stPoint.x - dx, _stPoint.y - dy, _endPoint.x, _endPoint.y);
        } else {
            this.drawPointer(gc, _endPoint.x - dx, _endPoint.y - dy, _stPoint.x, _stPoint.y);
        }
    }

    private void drawPointer(Graphics gc, double startX, double startY, double endX, double endY) {
        int x1 = (int)Math.round(startX);
        int y1 = (int)Math.round(startY);
        int x2 = (int)Math.round(endX);
        int y2 = (int)Math.round(endY);
        DecUtil.drawPointer(gc, new Point(x1, y1), new Point(x2, y2), 8);
    }

    private DoublePoint getInitVector(double _distToCharge, double _angle) {
        return new DoublePoint(_distToCharge + 5.0 * Math.cos(_angle), 5.0 * Math.sin(_angle));
    }

    private boolean satisfactionHole(DoublePoint _vector, boolean isHole1) {
        double dx = isHole1 ? this.pixelDistanceHalf : -this.pixelDistanceHalf;
        return this.hypot(_vector.x + dx, _vector.y) > 5.0;
    }

    private boolean satisfactionField(DoublePoint _vector) {
        int x = (int)Math.round(_vector.x);
        int y = (int)Math.round(_vector.y);
        return this.parentRect.contains(x, y);
    }

    private DoublePoint getCorrection(DoublePoint _vector, boolean _whatReturn) {
        double rd1 = this.hypot(_vector.x + this.pixelDistanceHalf, _vector.y);
        double rd2 = this.hypot(_vector.x - this.pixelDistanceHalf, _vector.y);
        double coeffA = this.charge1Value / (rd1 * rd1 * rd1);
        double coeffB = this.charge2Value / (rd2 * rd2 * rd2);
        double eleVectorX = coeffA * (_vector.x + this.pixelDistanceHalf) + coeffB * (_vector.x - this.pixelDistanceHalf);
        double eleVectorY = coeffA * _vector.y + coeffB * _vector.y;
        double eleVectorLenght = this.hypot(eleVectorX, eleVectorY);
        DoublePoint c = new DoublePoint(1.0 * eleVectorX / eleVectorLenght, 1.0 * eleVectorY / eleVectorLenght);
        if (!_whatReturn) {
            c.x = -c.x;
            c.y = -c.y;
        }
        return c;
    }

    private void drawLine(Graphics gc, DoublePoint p1, DoublePoint p2) {
        gc.drawLine((int)Math.round(p1.x), (int)Math.round(p1.y), (int)Math.round(p2.x), (int)Math.round(p2.y));
    }

    private DoublePoint addDP(DoublePoint p1, DoublePoint p2) {
        return new DoublePoint(p1.x + p2.x, p1.y + p2.y);
    }

    private double hypot(double x, double y) {
        return Math.sqrt(x * x + y * y);
    }
}

