/*
 * Decompiled with CFR 0.152.
 */
package physicon.ap.flux;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import physicon.ap.flux.Apparatus;
import physicon.ap.flux.Data;
import physicon.ap.flux.OutputBox;
import physicon.controls.CUtil;
import physicon.objava3.CompositeTextBlock;
import physicon.objava3.EventSubscriber;
import physicon.objava3.HostContainer;
import physicon.objava3.HostPanel;
import physicon.objava3.SimCheckbox;
import physicon.objava3.SimCheckboxGroup;
import physicon.objava3.SimMetaTeXBlock;
import physicon.objava3.physics.FloatingBand;

class Host
extends HostPanel
implements EventSubscriber {
    private Apparatus apparat = new Apparatus(this, new Point(5, 5), new Dimension(382, 250));
    private FloatingBand fbQ1 = this.createFloatingBand(new Point(5, 260), new Dimension(145, 32), 3.0, -5.0, 5.0, 1.0, 10, "Q1 is channged", "prefQ1", "suffQ1", "fbQ1Hint", "fbQ1");
    private FloatingBand fbQ2 = this.createFloatingBand(new Point(5, 297), new Dimension(145, 32), -3.0, -5.0, 5.0, 1.0, 10, "Q2 is channged", "prefQ2", "suffQ2", "fbQ2Hint", "fbQ2");
    private FloatingBand fbD;
    private SimCheckbox cbE;
    private SimCheckbox rbQ1;
    private SimCheckbox rbQ2;

    Host(HostContainer parent) {
        super(parent, new Dimension(392, 371));
        this.fbQ2.setVisible(false);
        this.fbD = this.createFloatingBand(new Point(5, 334), new Dimension(145, 32), 3.5, 2.0, 5.0, 0.1, 10, "D is channged", "prefD", "suffD", "fbDHint", "fbD");
        this.fbD.setVisible(false);
        OutputBox out = new OutputBox(this, new Point(155, 260), new Dimension(130, 32), "Field point is changed", 2);
        out.setCompositeTextBlock(new CompositeTextBlock(out, new Point(10, 7), Data.res.getString("prefE"), CUtil.fString(0.0, 2), Data.res.getString("suffE")));
        out.setHint(Data.res.getString("outEHint"));
        out = new OutputBox(this, new Point(155, 297), new Dimension(130, 32), "GC Flow is changed", 2);
        out.setCompositeTextBlock(new CompositeTextBlock(out, new Point(10, 7), Data.res.getString("prefF"), CUtil.fString(0.0, 2), Data.res.getString("suffF")));
        out.setHint(Data.res.getString("outFHint"));
        out = new OutputBox(this, new Point(155, 334), new Dimension(130, 32), "GC Charge is changed", 0);
        out.setCompositeTextBlock(new CompositeTextBlock(out, new Point(10, 7), Data.res.getString("prefQ"), CUtil.fString(0.0, 0), Data.res.getString("suffQ")));
        out.setHint(Data.res.getString("outQHint"));
        this.cbE = new SimCheckbox(this, new Point(290, 260), new Dimension(97, 20), true, Data.res.getString("cbE"), "E cb state is changed", null);
        this.cbE.setName("cbE");
        this.cbE.setHint(Data.res.getString("cbEHint"));
        this.subscribe("E cb state is changed", this);
        new SimMetaTeXBlock(this, new Point(301, 307), Data.res.getString("rbTitle"), 2, 0);
        SimCheckboxGroup cbGrp = new SimCheckboxGroup("Rbt state is channged");
        this.rbQ1 = new SimCheckbox(this, new Point(300, 325), new Dimension(85, 17), true, Data.res.getString("rbQ1"), null, cbGrp);
        this.rbQ1.setName("rbQ1");
        this.rbQ1.setHint(Data.res.getString("rbHint"));
        this.rbQ2 = new SimCheckbox(this, new Point(300, 343), new Dimension(85, 17), true, Data.res.getString("rbQ2"), null, cbGrp);
        this.rbQ2.setName("rbQ2");
        this.rbQ2.setHint(Data.res.getString("rbHint"));
        cbGrp.setSelectedCheckbox(this.rbQ1);
        this.subscribe("Rbt state is channged", this);
    }

    public void receiveEvent(Object event) {
        if (event instanceof Boolean) {
            this.apparat.setFieldVisible(this.cbE.getState());
            return;
        }
        if (event == this.rbQ1) {
            this.fbQ2.setVisible(false);
            this.fbD.setVisible(false);
        } else if (event == this.rbQ2) {
            this.fbQ2.setVisible(true);
            this.fbD.setVisible(true);
        }
        this.apparat.needUpdate(this.fbQ1.getValue(), this.fbQ2.getValue(), this.fbD.getValue(), this.rbQ1.getState());
    }

    public void paint(Graphics gc) {
        super.paint(gc);
        gc.setColor(Data.boundShadowColor);
        gc.drawRect(290, 315, 95, 49);
        gc.setColor(Data.boundColor);
        gc.drawRect(291, 316, 95, 49);
        gc.setColor(Data.appColor);
        gc.fillRect(298, 315, 80, 2);
    }

    public void onCreate() {
        super.onCreate();
        this.publishEvent("Q1 is channged", new Double(3.0));
    }

    public void repaint() {
        this.paintAll();
        this.flushBuffer();
    }

    private FloatingBand createFloatingBand(Point refPoint, Dimension size, double initV, double minV, double maxVal, double step, int textX, String evtName, String prefStr, String suffStr, String fbHint, String fbName) {
        FloatingBand fb = new FloatingBand(this, refPoint, size, initV, minV, maxVal, step, null, evtName, 70);
        fb.getTextBlock().setPrefix(Data.res.getString(prefStr));
        fb.getTextBlock().setPostfix(Data.res.getString(suffStr));
        this.subscribe(evtName, this);
        if (textX != -1) {
            fb.getTextBlock().setRefPoint(textX, fb.getTextBlock().getRefPoint().y);
        }
        fb.setHint(Data.res.getString(fbHint));
        fb.setName(fbName);
        return fb;
    }
}

