/*
 * Decompiled with CFR 0.152.
 */
package physicon.ap.flux;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import physicon.ap.flux.Apparatus;
import physicon.ap.flux.Data;
import physicon.objava3.Region;
import physicon.objava3.more.DragAndDrop;

class GSurface
extends Region {
    private int koefW;
    private int koefH;
    private int gsHalfWidth = 155;
    private int gsHalfHeight = 60;
    private Color currentColor = Data.gsColor;
    private Apparatus apparat;
    private int oldX;
    private int oldY;

    public GSurface(Apparatus parent, Point refPoint) {
        super(parent, refPoint);
        this.apparat = parent;
        new DragAndDrop(this, null){

            public void mouseDown(MouseEvent evt) {
                super.mouseDown(evt);
                GSurface.this.currentColor = Data.gsLightColor;
                GSurface.this.repaint();
            }

            public void mouseUp(MouseEvent evt) {
                super.mouseUp(evt);
                GSurface.this.currentColor = Data.gsColor;
                GSurface.this.repaint();
            }

            public void mouseDrag(MouseEvent evt) {
                super.mouseDrag(evt);
                GSurface.this.changeRefPoint();
            }
        };
        new Region(this, new Point()){

            public Rectangle getRoughRect() {
                return ((Region)this.getParent()).getRoughRect();
            }

            public void paint(Graphics g) {
            }

            protected void mouseDown(MouseEvent evt) {
                GSurface.this.startChangeForm(evt.getPoint().x, evt.getPoint().y);
                this.setCapture();
            }

            protected void mouseUp(MouseEvent evt) {
                GSurface.this.endChangeForm(evt.getPoint().x, evt.getPoint().y);
                this.releaseCapture();
            }

            protected void mouseDrag(MouseEvent evt) {
                GSurface.this.changeForm(evt.getPoint().x, evt.getPoint().y);
            }

            protected Cursor getCursor() {
                return Cursor.getPredefinedCursor(12);
            }

            public boolean contains(int ix, int iy) {
                double h;
                double y;
                double s = 10.0;
                double x = ix;
                double w = GSurface.this.gsHalfWidth;
                return x * x / (w * w) + (y = (double)iy) * y / ((h = (double)GSurface.this.gsHalfHeight) * h) <= 1.0 && x * x / ((w - s) * (w - s)) + y * y / ((h - s) * (h - s)) >= 1.0;
            }
        };
    }

    public Rectangle getRoughRect() {
        return new Rectangle(-this.gsHalfWidth, -this.gsHalfHeight, 2 * this.gsHalfWidth, 2 * this.gsHalfHeight);
    }

    public void paint(Graphics gc) {
        Rectangle rect = this.getRoughRect();
        gc.setColor(this.currentColor);
        double a = this.gsHalfWidth;
        double b = this.gsHalfHeight;
        double x1_d = a;
        double y1_d = 0.0;
        double t = 0.0;
        while (t <= 6.335545184739416) {
            double x2_d = a * Math.cos(t);
            double y2_d = b * Math.sin(t);
            int x1 = (int)Math.round(x1_d);
            int y1 = (int)Math.round(y1_d);
            int x2 = (int)Math.round(x2_d);
            int y2 = (int)Math.round(y2_d);
            x1_d = x2_d;
            y1_d = y2_d;
            int j = 0;
            while (j < 3) {
                int shift = j % 2 == 0 ? j / 2 : -j / 2 - 1;
                gc.drawLine(x1 + shift, y1, x2 + shift, y2);
                gc.drawLine(x1, y1 + shift, x2, y2 + shift);
                ++j;
            }
            t += 0.05235987755982988;
        }
    }

    public boolean contains(int ix, int iy) {
        double s = 10.0;
        double x = ix;
        double w = this.gsHalfWidth;
        double y = iy;
        double h = this.gsHalfHeight;
        return x * x / (w * w) + y * y / (h * h) <= 1.0;
    }

    public void repaint() {
        this.getSimWindow().paintAll();
        this.getSimWindow().flushBuffer();
    }

    private void changeRefPoint() {
        Dimension pr = this.apparat.getSize();
        int x = this.getRefPoint().x;
        int y = this.getRefPoint().y;
        if (x < 5 + this.gsHalfWidth) {
            if (x > 15) {
                this.gsHalfWidth = x - 5;
            } else {
                this.gsHalfWidth = 10;
                x = 15;
            }
        } else if (x > pr.width - 5 - this.gsHalfWidth) {
            if (x < pr.width - 5 - 10) {
                this.gsHalfWidth = pr.width - x - 5;
            } else {
                this.gsHalfWidth = 10;
                x = pr.width - 5 - 10;
            }
        }
        if (y < 5 + this.gsHalfHeight) {
            if (y > 15) {
                this.gsHalfHeight = y - 5;
            } else {
                this.gsHalfHeight = 10;
                y = 15;
            }
        } else if (y > pr.height - 5 - this.gsHalfHeight) {
            if (y < pr.height - 5 - 10) {
                this.gsHalfHeight = pr.height - y - 5;
            } else {
                this.gsHalfHeight = 10;
                y = pr.height - 5 - 10;
            }
        }
        this.apparat.gsDataUpdated();
        this.setRefPoint(x, y);
        this.repaint();
    }

    private void startChangeForm(int x, int y) {
        this.currentColor = Data.gsLightColor;
        this.oldX = x;
        this.oldY = y;
        this.koefW = x < -this.gsHalfWidth / 2 ? -1 : (x > this.gsHalfWidth / 2 ? 1 : 0);
        this.koefH = y < -this.gsHalfHeight / 2 ? -1 : (y > this.gsHalfHeight / 2 ? 1 : 0);
        this.repaint();
    }

    private void endChangeForm(int x, int y) {
        this.currentColor = Data.gsColor;
        this.repaint();
    }

    private void changeForm(int x, int y) {
        Dimension pr = this.apparat.getSize();
        int dW = x - this.oldX;
        int dH = y - this.oldY;
        this.oldX = x;
        this.oldY = y;
        this.gsHalfWidth += this.koefW * dW;
        this.gsHalfHeight += this.koefH * dH;
        if (this.gsHalfWidth < 10) {
            this.gsHalfWidth = 10;
        } else if (this.gsHalfWidth > pr.width / 2 - 5) {
            this.gsHalfWidth = pr.width / 2 - 5;
        }
        if (this.gsHalfHeight < 10) {
            this.gsHalfHeight = 10;
        } else if (this.gsHalfHeight > pr.height / 2 - 5) {
            this.gsHalfHeight = pr.height / 2 - 5;
        }
        x = this.getRefPoint().x;
        y = this.getRefPoint().y;
        if (this.koefW * dW > 0) {
            if (this.koefW > 0) {
                if (x - this.gsHalfWidth < 5) {
                    x = 5 + this.gsHalfWidth;
                } else if (x + this.gsHalfWidth > pr.width - 5) {
                    this.gsHalfWidth = pr.width - 5 - x;
                }
            } else if (this.koefW < 0) {
                if (x + this.gsHalfWidth > pr.width - 5) {
                    x = pr.width - 5 - this.gsHalfWidth;
                } else if (x - this.gsHalfWidth < 5) {
                    this.gsHalfWidth = x - 5;
                }
            }
        }
        if (this.koefH * dH > 0) {
            if (this.koefH > 0) {
                if (y - this.gsHalfHeight < 5) {
                    y = 5 + this.gsHalfHeight;
                } else if (y + this.gsHalfHeight > pr.height - 5) {
                    this.gsHalfHeight = pr.height - 5 - y;
                }
            } else if (this.koefH < 0) {
                if (y + this.gsHalfHeight > pr.height - 5) {
                    y = pr.height - 5 - this.gsHalfHeight;
                } else if (y - this.gsHalfHeight < 5) {
                    this.gsHalfHeight = y - 5;
                }
            }
        }
        this.apparat.gsDataUpdated();
        this.setRefPoint(x, y);
        this.repaint();
    }
}

