/*
 * Decompiled with CFR 0.152.
 */
package physicon.ap.flux;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import physicon.ap.flux.Data;
import physicon.ap.flux.GSurface;
import physicon.ap.flux.Physics;
import physicon.controls.ImageMagic;
import physicon.objava3.SimMetaTeXBlock;
import physicon.objava3.SimWindow;
import physicon.objava3.more.DefPointConvertor;
import physicon.objava3.more.PointAndClick;
import physicon.objava3.more.ReliefDecoration;

class Apparatus
extends SimWindow {
    private double q1 = 3.0;
    private double q2 = -3.0;
    private double d = 3.5;
    private boolean isOneCharge = true;
    private boolean isEFVisible = true;
    private Physics physics;
    private GSurface gSurface;
    private SimMetaTeXBlock labelQ1;
    private SimMetaTeXBlock labelQ2;
    private Image doubleBuffer;
    private boolean needUpdateBufer;

    Apparatus(SimWindow parent, Point refPoint, Dimension size) {
        super(parent, refPoint, size);
        new ReliefDecoration(this);
        this.setBkgColor(Data.appBgColor);
        this.labelQ1 = new SimMetaTeXBlock(this, new Point(this.getSize().width / 2 + 15, this.getSize().height / 2 + 11), Data.res.getString("apparatQ1"));
        this.labelQ1.setAlignFlags(18);
        this.labelQ2 = new SimMetaTeXBlock(this, new Point(0, 0), Data.res.getString("apparatQ2"));
        this.labelQ2.setAlignFlags(18);
        this.labelQ2.setVisible(false);
        PointAndClick pac = new PointAndClick(this, null){
            private boolean wasClickToCharge;

            @Override
            public void mouseDown(MouseEvent evt) {
                super.mouseDown(evt);
                this.wasClickToCharge = false;
                double minRE = 5.0;
                Point p = evt.getPoint();
                int x = Apparatus.this.getSize().width / 2;
                int y = Apparatus.this.getSize().height / 2;
                if (Apparatus.this.isOneCharge) {
                    double radius = Apparatus.this.hypot(p.x, p.y, x, y);
                    if (radius < minRE) {
                        this.wasClickToCharge = true;
                    }
                } else {
                    int dx = (int)Math.round(Apparatus.this.d);
                    double radius = Apparatus.this.hypot(p.x, p.y, x - dx, y);
                    if (radius < minRE) {
                        this.wasClickToCharge = true;
                    }
                    if ((radius = Apparatus.this.hypot(p.x, p.y, x + dx, y)) < minRE) {
                        this.wasClickToCharge = true;
                    }
                }
                if (!this.wasClickToCharge) {
                    Apparatus.this.printElectricField(p);
                }
            }

            @Override
            public void mouseUp(MouseEvent evt) {
                super.mouseUp(evt);
                if (!this.wasClickToCharge) {
                    Apparatus.this.printElectricField(null);
                }
            }

            @Override
            public void mouseDrag(MouseEvent evt) {
                super.mouseDrag(evt);
                if (!this.wasClickToCharge) {
                    Apparatus.this.printElectricField(evt.getPoint());
                }
            }

            @Override
            public boolean contains(int x, int y) {
                return x >= 0 && x <= Apparatus.this.getSize().width && y >= 0 && y <= Apparatus.this.getSize().height;
            }
        };
        pac.setPointConvertor(new DefPointConvertor());
        this.gSurface = new GSurface(this, new Point(this.getSize().width / 2, this.getSize().height / 2));
    }

    public void repaint() {
        this.paintAll();
        this.flushBuffer();
    }

    @Override
    public void onCreate() {
        this.physics = new Physics(this);
        this.doubleBuffer = ImageMagic.createImage(this.getSize().width, this.getSize().height);
        this.needUpdateBufer = true;
        super.onCreate();
    }

    @Override
    public synchronized void paint(Graphics g) {
        super.paint(g);
        if (this.needUpdateBufer) {
            Graphics gc = this.doubleBuffer.getGraphics();
            gc.setColor(Data.appBgColor);
            gc.fillRect(0, 0, this.getSize().width, this.getSize().height);
            if (this.isEFVisible) {
                this.physics.show(gc);
            }
            int x = this.getSize().width / 2;
            int y = this.getSize().height / 2;
            if (this.isOneCharge) {
                this.drawCharge(gc, this.q1, x, y);
            } else {
                int dx = (int)Math.round(this.d);
                this.drawCharge(gc, this.q1, x - dx, y);
                this.drawCharge(gc, this.q2, x + dx, y);
            }
            this.needUpdateBufer = false;
        }
        g.drawImage(this.doubleBuffer, 0, 0, this);
    }

    synchronized void setFieldVisible(boolean isEFVisible) {
        this.isEFVisible = isEFVisible;
        this.needUpdateBufer = true;
        this.repaint();
    }

    synchronized void needUpdate(double q1, double q2, double d, boolean isOneCharge) {
        this.q1 = q1;
        this.q2 = q2;
        this.d = d * 28.0;
        this.isOneCharge = isOneCharge;
        if (isOneCharge) {
            this.labelQ2.setVisible(false);
            this.labelQ1.setRefPoint(this.getSize().width / 2 + 15, this.getSize().height / 2 + 11);
        } else {
            int dx = (int)Math.round(this.d);
            this.labelQ2.setVisible(true);
            this.labelQ1.setRefPoint(this.getSize().width / 2 - dx + 15, this.getSize().height / 2 + 11);
            this.labelQ2.setRefPoint(this.getSize().width / 2 + dx + 2 + 15, this.getSize().height / 2 + 11);
        }
        this.physics.needUpdate(this.q1, this.q2, this.d, this.isOneCharge);
        this.needUpdateBufer = true;
        this.gsDataUpdated();
        this.repaint();
    }

    void gsDataUpdated() {
        double charge = 0.0;
        int x = this.getSize().width / 2;
        int y = this.getSize().height / 2;
        Point gsrp = this.gSurface.getRefPoint();
        if (this.isOneCharge) {
            charge = this.gSurface.contains(x - gsrp.x, y - gsrp.y) ? this.q1 : 0.0;
        } else {
            int dx = (int)Math.round(this.d);
            if (this.gSurface.contains(x - dx - gsrp.x, y - gsrp.y)) {
                charge += this.q1;
            }
            if (this.gSurface.contains(x + dx - gsrp.x, y - gsrp.y)) {
                charge += this.q2;
            }
        }
        this.publishEvent("GC Flow is changed", new Double(charge * 1.13));
        this.publishEvent("GC Charge is changed", new Double(charge));
    }

    private void printElectricField(Point p) {
        double eField = 0.0;
        if (p == null) {
            this.publishEvent("Field point is changed", new Double(eField));
            return;
        }
        double pixel2dist = 0.017857142857142856;
        double coeff = 0.08991804694457363;
        int x = this.getSize().width / 2;
        int y = this.getSize().height / 2;
        double minRE = 5.0;
        double minRI = 4.0;
        if (this.isOneCharge) {
            double radius = this.hypot(p.x, p.y, x, y);
            if (radius < minRE) {
                radius = minRI + (minRE - minRI) * Math.random();
            }
            eField = 0.08991804694457363 * (this.q1 > 0.0 ? this.q1 : -this.q1) / ((radius *= 0.017857142857142856) * radius);
        } else {
            int dx = (int)Math.round(this.d);
            double r1 = this.hypot(p.x, p.y, x - dx, y);
            if (r1 < minRE) {
                r1 = minRI + (minRE - minRI) * Math.random();
            }
            r1 *= 0.017857142857142856;
            double r2 = this.hypot(p.x, p.y, x + dx, y);
            if (r2 < minRE) {
                r2 = minRI + (minRE - minRI) * Math.random();
            }
            double elecX = 0.08991804694457363 * this.q1 / (r1 * r1 * r1) * 0.017857142857142856 * (double)(p.x - (x - dx)) + 0.08991804694457363 * this.q2 / ((r2 *= 0.017857142857142856) * r2 * r2) * 0.017857142857142856 * (double)(p.x - (x + dx));
            double elecY = 0.08991804694457363 * this.q1 / (r1 * r1 * r1) * 0.017857142857142856 * (double)(p.y - y) + 0.08991804694457363 * this.q2 / (r2 * r2 * r2) * 0.017857142857142856 * (double)(p.y - y);
            eField = Math.sqrt(elecX * elecX + elecY * elecY);
        }
        this.publishEvent("Field point is changed", new Double(eField));
    }

    private double hypot(double x1, double y1, double x2, double y2) {
        return Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
    }

    private void drawCharge(Graphics gc, double q, int x, int y) {
        x -= 5;
        y -= 5;
        if (q < 0.0) {
            this.drawNegativeCharge(gc, x, y);
        } else if (q > 0.0) {
            this.drawPositiveCharge(gc, x, y);
        } else {
            this.drawCharge(gc, x, y);
        }
    }

    private void drawCharge(Graphics gc, int x, int y) {
        gc.translate(x, y);
        gc.setColor(Data.chargeBkColor);
        gc.fillRect(0, 3, 10, 4);
        gc.fillRect(3, 0, 4, 10);
        gc.fillRect(2, 1, 6, 8);
        gc.fillRect(1, 2, 8, 6);
        gc.setColor(Data.chargeColor);
        gc.fillRect(0, 3, 9, 3);
        gc.fillRect(3, 0, 3, 9);
        gc.fillRect(2, 1, 5, 7);
        gc.fillRect(1, 2, 7, 5);
        gc.setColor(Data.chargeBlickColor);
        gc.fillRect(1, 2, 4, 2);
        gc.fillRect(2, 1, 2, 4);
        gc.translate(-x, -y);
    }

    private void drawPositiveCharge(Graphics gc, int x, int y) {
        gc.translate(x, y);
        this.drawCharge(gc, 0, 0);
        gc.setColor(Data.chargePosBgColor);
        gc.fillRect(1, 4, 8, 2);
        gc.fillRect(4, 1, 2, 8);
        gc.setColor(Data.chargePosColor);
        gc.fillRect(0, 3, 8, 2);
        gc.fillRect(3, 0, 2, 8);
        gc.translate(-x, -y);
    }

    private void drawNegativeCharge(Graphics gc, int x, int y) {
        gc.translate(x, y);
        this.drawCharge(gc, 0, 0);
        gc.setColor(Data.chargeNegBgColor);
        gc.fillRect(1, 4, 8, 2);
        gc.setColor(Data.chargeNegColor);
        gc.fillRect(0, 3, 8, 2);
        gc.translate(-x, -y);
    }
}

