/*
 * Decompiled with CFR 0.152.
 */
package physicon.GraphEngine;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import physicon.GraphEngine.GEInterface;
import physicon.GraphEngine.GEObject;

class GERecord {
    protected GEObject object;
    protected GEInterface inter = null;
    protected Rectangle traceGlobal = new Rectangle();
    protected double lastLevel;
    protected Rectangle gRoughRect = new Rectangle();
    protected Point gRefPoint = new Point(0, 0);

    public boolean belongs(Rectangle rectangle) {
        Rectangle rectangle2 = this.getGlobalUpdateRect();
        rectangle2.x += -1;
        rectangle2.y += -1;
        rectangle2.width += 2;
        rectangle2.height += 2;
        return rectangle.intersects(rectangle2);
    }

    public void draw(Graphics graphics) {
        graphics.translate(this.gRefPoint.x, this.gRefPoint.y);
        this.object.drawLocal(graphics);
        graphics.translate(-this.gRefPoint.x, -this.gRefPoint.y);
        this.traceGlobal.x = this.gRoughRect.x;
        this.traceGlobal.y = this.gRoughRect.y;
        this.traceGlobal.width = this.gRoughRect.width;
        this.traceGlobal.height = this.gRoughRect.height;
        if (this.inter != null) {
            this.inter.setRedrawFlag(false);
        }
        this.lastLevel = this.object.getGlobalLevel();
    }

    public GERecord(GEObject gEObject) {
        this.object = gEObject;
        this.update();
    }

    public GERecord(GEInterface gEInterface) {
        this.inter = gEInterface;
        this.update();
    }

    public boolean getRedrawFlag() {
        if (this.inter == null) {
            return true;
        }
        return this.inter.getRedrawFlag();
    }

    public final void update() {
        if (this.inter != null) {
            this.object = this.inter.getGEObject();
        }
        Point point = this.object.getGlobalRefPoint();
        Rectangle rectangle = this.object.getLocalRoughRect();
        this.gRefPoint.x = point.x;
        this.gRefPoint.y = point.y;
        this.gRoughRect.x = rectangle.x + point.x;
        this.gRoughRect.y = rectangle.y + point.y;
        this.gRoughRect.width = rectangle.width;
        this.gRoughRect.height = rectangle.height;
    }

    public Rectangle getGlobalUpdateRect() {
        Rectangle rectangle = new Rectangle(this.gRoughRect.x, this.gRoughRect.y, this.gRoughRect.width, this.gRoughRect.height);
        if (this.traceGlobal.width != 0 || this.traceGlobal.height != 0) {
            rectangle.add(this.traceGlobal);
        }
        return rectangle;
    }
}

