/*
 * Decompiled with CFR 0.152.
 */
package physicon.objava3.physics;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import physicon.graphLib2.GraphLibData;
import physicon.objava3.SimMetaTeXBlock;
import physicon.objava3.SimWindow;
import physicon.objava3.more.RectBkgSaver;

public class QWUChart
extends SimWindow {
    private static final Color gridColor = GraphLibData.gridColor;
    private static final Color zeroColor = GraphLibData.scaleColor;
    private static final Color barBorderColor = GraphLibData.scaleColor;
    private Color heatColor = Color.red;
    private Color workColor = Color.blue;
    private Color energyColor = Color.gray;
    private int pzmField;
    private int QWUField;
    private double m_maxHeat;
    private double m_maxWork;
    private double m_maxEnergy;
    private double m_currentHeat;
    private double m_currentWork;
    private double m_currentEnergy;
    private SimMetaTeXBlock m_heatLabel;
    private SimMetaTeXBlock m_workLabel;
    private SimMetaTeXBlock m_energyLabel;
    private int m_width;
    private int m_height;
    private int m_horField;
    private int m_vertField;
    private int m_dashes;
    private boolean m_vertFlag = true;
    private RectBkgSaver m_saver;

    public void setMaxWork(double d) {
        this.m_maxWork = d;
    }

    public void setMaxHeat(double d) {
        this.m_maxHeat = d;
    }

    public void setWorkLabel(String string) {
        this.m_workLabel.setString(string);
    }

    public void setEnergyLabel(String string) {
        this.m_energyLabel.setString(string);
    }

    public QWUChart(SimWindow simWindow, Point point, Dimension dimension, int n, int n2, int n3, boolean bl) {
        super(simWindow, point, dimension);
        this.m_saver = new RectBkgSaver(this, new Point(0, 0), new Rectangle(0, 0, dimension.width - 1, dimension.height - 1));
        this.m_maxHeat = 1.0;
        this.m_maxWork = 1.0;
        this.m_maxEnergy = 1.0;
        this.m_currentHeat = 0.0;
        this.m_currentWork = 0.0;
        this.m_currentEnergy = 0.0;
        this.m_horField = n;
        this.m_vertField = n2;
        this.m_vertFlag = bl;
        this.m_dashes = n3;
        int n4 = 0;
        int n5 = 0;
        SimMetaTeXBlock simMetaTeXBlock = new SimMetaTeXBlock(this, new Point(), "W", n5, 0);
        int n6 = simMetaTeXBlock.getWidth();
        int n7 = simMetaTeXBlock.getHeight();
        this.removeRegion(simMetaTeXBlock);
        simMetaTeXBlock.destroy();
        if (this.m_vertFlag) {
            this.pzmField = n6;
            this.QWUField = n7;
            this.m_width = dimension.width - 2 * this.m_horField - this.pzmField;
            this.m_height = dimension.height - 2 * this.m_vertField - this.QWUField;
            this.m_heatLabel = new SimMetaTeXBlock(this, new Point(this.pzmField + this.m_horField + this.m_width / 6, 3), "", n4, 4);
            this.m_workLabel = new SimMetaTeXBlock(this, new Point(this.pzmField + this.m_horField + this.m_width / 2, 3), "", n4, 4);
            this.m_energyLabel = new SimMetaTeXBlock(this, new Point(this.pzmField + this.m_horField + 5 * this.m_width / 6, 3), "", n4, 4);
            new SimMetaTeXBlock(this, new Point(6, this.QWUField - 2), "\\bold{ + }", n5, 0);
            new SimMetaTeXBlock(this, new Point(7, dimension.height - 18), "\\bold{ - }", n5, 0);
            new SimMetaTeXBlock(this, new Point(7, this.QWUField + this.m_vertField + this.m_height / 2 - 9), "0", n5, 0);
            return;
        }
        this.pzmField = n7;
        this.QWUField = 2 * n6;
        this.m_width = dimension.width - 2 * this.m_horField - this.QWUField;
        this.m_height = dimension.height - 2 * this.m_vertField - this.pzmField;
        this.m_heatLabel = new SimMetaTeXBlock(this, new Point(this.getSize().width - this.QWUField, this.pzmField + this.m_vertField + this.m_height / 6), "", n4, 32);
        this.m_workLabel = new SimMetaTeXBlock(this, new Point(this.getSize().width - this.QWUField, this.pzmField + this.m_vertField + this.m_height / 2), "", n4, 32);
        this.m_energyLabel = new SimMetaTeXBlock(this, new Point(this.getSize().width - this.QWUField, this.pzmField + this.m_vertField + 5 * this.m_height / 6), "", n4, 32);
        new SimMetaTeXBlock(this, new Point(this.getSize().width - this.QWUField - 13, 2), "\\bold{ + }", n5, 0);
        new SimMetaTeXBlock(this, new Point(5, 1), "\\bold{ - }", n5, 0);
        new SimMetaTeXBlock(this, new Point(this.m_width / 2, 3), "0", n5, 0);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.m_vertFlag) {
            double d = (double)this.m_width / 3.0;
            int n = (int)Math.round((double)this.m_height / 2.0 + (double)this.QWUField + (double)this.m_vertField);
            double d2 = (double)this.m_height / (2.0 * (double)this.m_dashes);
            graphics.setColor(gridColor);
            int n2 = 0;
            do {
                graphics.drawLine(this.pzmField + this.m_horField + (int)Math.round((double)n2 * d) - 1, this.getSize().height - this.m_vertField - 1, this.pzmField + this.m_horField + (int)Math.round((double)n2 * d) - 1, this.QWUField + this.m_vertField - 1);
            } while (++n2 <= 3);
            n2 = 1;
            while (n2 <= this.m_dashes) {
                graphics.drawLine(this.pzmField + this.m_horField - 1, n + (int)Math.round((double)n2 * d2) - 1, this.getSize().width - this.m_horField - 1, n + (int)Math.round((double)n2 * d2) - 1);
                graphics.drawLine(this.pzmField + this.m_horField - 1, n - (int)Math.round((double)n2 * d2) - 1, this.getSize().width - this.m_horField - 1, n - (int)Math.round((double)n2 * d2) - 1);
                ++n2;
            }
            graphics.setColor(zeroColor);
            graphics.drawLine(this.m_horField + this.pzmField, n - 1, this.getSize().width - this.m_horField - 1, n - 1);
            return;
        }
        double d = (double)this.m_height / 3.0;
        int n = (int)Math.round((double)this.m_width / 2.0 + (double)this.m_horField);
        double d3 = (double)this.m_width / (2.0 * (double)this.m_dashes);
        graphics.setColor(gridColor);
        int n3 = 0;
        do {
            graphics.drawLine(this.m_horField - 1, (int)Math.round((double)(this.pzmField + this.m_vertField) + d * (double)n3 - 1.0), this.getSize().width - this.m_horField - this.QWUField - 1, (int)Math.round((double)(this.pzmField + this.m_vertField) + d * (double)n3 - 1.0));
        } while (++n3 <= 3);
        n3 = 1;
        while (n3 <= this.m_dashes) {
            graphics.drawLine((int)Math.round((double)n + (double)n3 * d3 - 1.0), this.pzmField + this.m_vertField - 1, (int)Math.round((double)n + (double)n3 * d3 - 1.0), this.getSize().height - this.m_vertField - 1);
            graphics.drawLine((int)Math.round((double)n - (double)n3 * d3 - 1.0), this.pzmField + this.m_vertField - 1, (int)Math.round((double)n - (double)n3 * d3 - 1.0), this.getSize().height - this.m_vertField - 1);
            ++n3;
        }
        graphics.setColor(zeroColor);
        graphics.drawLine(Math.round(n - 1), this.pzmField + this.m_vertField - 1, Math.round(n - 1), this.getSize().height - this.m_vertField - 1);
    }

    public void setCurrentEnergy(double d) {
        this.m_currentEnergy = d;
    }

    public void setCurrentHeat(double d) {
        this.m_currentHeat = d;
    }

    public void prepareBackground() {
        this.m_saver.save();
    }

    public Color getWorkColor() {
        return this.workColor;
    }

    public void setWorkColor(Color color) {
        this.workColor = color;
    }

    public Color getEnergyColor() {
        return this.energyColor;
    }

    public void setEnergyColor(Color color) {
        this.energyColor = color;
    }

    public void setCurrentWork(double d) {
        this.m_currentWork = d;
    }

    public void setHeatLabel(String string) {
        this.m_heatLabel.setString(string);
    }

    public Color getHeatColor() {
        return this.heatColor;
    }

    public void setHeatColor(Color color) {
        this.heatColor = color;
    }

    public void updatePicture() {
        this.m_saver.restore();
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        if (this.m_vertFlag) {
            double d = (double)this.m_width / 3.0;
            int n = (int)Math.round((double)this.m_height / 2.0 + (double)this.QWUField + (double)this.m_vertField);
            int[] nArray = new int[]{this.pzmField + this.m_horField + 2, (int)Math.round(d - 6.0) + this.pzmField + this.m_horField + 2, (int)Math.round(d - 6.0) + this.pzmField + this.m_horField + 2, this.pzmField + this.m_horField + 2};
            int[] nArray2 = new int[]{this.pzmField + this.m_horField + 2 + (int)Math.round(d), (int)Math.round(2.0 * d - 6.0) + this.pzmField + this.m_horField + 2, (int)Math.round(2.0 * d - 6.0) + this.pzmField + this.m_horField + 2, this.pzmField + this.m_horField + 2 + (int)Math.round(d)};
            int[] nArray3 = new int[]{this.pzmField + this.m_horField + 2 + (int)Math.round(2.0 * d), (int)Math.round(3.0 * d - 6.0) + this.pzmField + this.m_horField + 2, (int)Math.round(3.0 * d - 6.0) + this.pzmField + this.m_horField + 2, this.pzmField + this.m_horField + 2 + (int)Math.round(2.0 * d)};
            int[] nArray4 = new int[]{(int)Math.round((double)(n - 1) - this.m_currentHeat / this.m_maxHeat * (double)this.m_height / 2.0), (int)Math.round((double)(n - 1) - this.m_currentHeat / this.m_maxHeat * (double)this.m_height / 2.0), n - 1, n - 1};
            int[] nArray5 = new int[]{(int)Math.round((double)(n - 1) - this.m_currentWork / this.m_maxWork * (double)this.m_height / 2.0), (int)Math.round((double)(n - 1) - this.m_currentWork / this.m_maxWork * (double)this.m_height / 2.0), n - 1, n - 1};
            int[] nArray6 = new int[]{(int)Math.round((double)(n - 1) - this.m_currentEnergy / this.m_maxEnergy * (double)this.m_height / 2.0), (int)Math.round((double)(n - 1) - this.m_currentEnergy / this.m_maxEnergy * (double)this.m_height / 2.0), n - 1, n - 1};
            graphics.setColor(this.getHeatColor());
            graphics.fillPolygon(nArray, nArray4, 4);
            graphics.setColor(this.getWorkColor());
            graphics.fillPolygon(nArray2, nArray5, 4);
            graphics.setColor(this.getEnergyColor());
            graphics.fillPolygon(nArray3, nArray6, 4);
            graphics.setColor(barBorderColor);
            graphics.drawPolygon(nArray, nArray4, 4);
            graphics.drawPolygon(nArray2, nArray5, 4);
            graphics.drawPolygon(nArray3, nArray6, 4);
            return;
        }
        double d = (double)this.m_height / 3.0;
        int n = (int)Math.round((double)this.m_width / 2.0 + (double)this.m_horField);
        int[] nArray = new int[]{n - 1, (int)Math.round((double)(n - 1) + this.m_currentHeat / this.m_maxHeat * (double)this.m_width / 2.0), (int)Math.round((double)(n - 1) + this.m_currentHeat / this.m_maxHeat * (double)this.m_width / 2.0), n - 1};
        int[] nArray7 = new int[]{n - 1, (int)Math.round((double)(n - 1) + this.m_currentWork / this.m_maxWork * (double)this.m_width / 2.0), (int)Math.round((double)(n - 1) + this.m_currentWork / this.m_maxWork * (double)this.m_width / 2.0), n - 1};
        int[] nArray8 = new int[]{n - 1, (int)Math.round((double)(n - 1) + this.m_currentEnergy / this.m_maxEnergy * (double)this.m_width / 2.0), (int)Math.round((double)(n - 1) + this.m_currentEnergy / this.m_maxEnergy * (double)this.m_width / 2.0), n - 1};
        int[] nArray9 = new int[]{this.pzmField + 2 + this.m_vertField, this.pzmField + 2 + this.m_vertField, this.pzmField + 1 + (int)Math.round(d - 5.0) + this.m_vertField, this.pzmField + 1 + (int)Math.round(d - 5.0) + this.m_vertField};
        int[] nArray10 = new int[]{this.pzmField + 2 + (int)Math.round(d) + this.m_vertField, this.pzmField + 2 + (int)Math.round(d) + this.m_vertField, this.pzmField + 1 + (int)Math.round(2.0 * d - 5.0) + this.m_vertField, this.pzmField + 1 + (int)Math.round(2.0 * d - 5.0) + this.m_vertField};
        int[] nArray11 = new int[]{this.pzmField + 2 + (int)Math.round(2.0 * d) + this.m_vertField, this.pzmField + 2 + (int)Math.round(2.0 * d) + this.m_vertField, this.pzmField + 1 + (int)Math.round(3.0 * d - 5.0) + this.m_vertField, this.pzmField + 1 + (int)Math.round(3.0 * d - 5.0) + this.m_vertField};
        graphics.setColor(this.getHeatColor());
        graphics.fillPolygon(nArray, nArray9, 4);
        graphics.setColor(this.getWorkColor());
        graphics.fillPolygon(nArray7, nArray10, 4);
        graphics.setColor(this.getEnergyColor());
        graphics.fillPolygon(nArray8, nArray11, 4);
        graphics.setColor(barBorderColor);
        graphics.drawPolygon(nArray, nArray9, 4);
        graphics.drawPolygon(nArray7, nArray10, 4);
        graphics.drawPolygon(nArray8, nArray11, 4);
    }

    public void setMaxEnergy(double d) {
        this.m_maxEnergy = d;
    }
}

