/*
 * Decompiled with CFR 0.152.
 */
package physicon.objava3.more;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import physicon.objava3.EventSubscriber;
import physicon.objava3.Region;
import physicon.objava3.SequenceController;
import physicon.objava3.SimConfig;
import physicon.objava3.SimObject;
import physicon.objava3.more.DefPointConvertor;
import physicon.objava3.more.PointConvertor;

public class DragAndDrop
extends Region
implements EventSubscriber,
SequenceController {
    private int m_startX;
    private int m_startY;
    private Point m_lastPoint;
    private boolean m_isDragging = false;
    private PointConvertor m_pointConvertor = new DefPointConvertor();
    private String m_eventName;
    private String m_setEventName;

    public void receiveEvent(Object object) {
        Point point = (Point)object;
        this.getParent().setRefPoint(point.x, point.y);
    }

    public DragAndDrop(Region region, String string, String string2) {
        super(region, new Point(0, 0));
        this.m_eventName = string;
        this.m_setEventName = string2;
        if (string != null) {
            this.subscribe(string, this);
        }
        this.toBack();
        this.setHint(SimConfig.res.getString("hintDragDrop"));
    }

    public DragAndDrop(Region region, String string) {
        this(region, string, string == null ? null : string + "Set");
    }

    public void paint(Graphics graphics) {
    }

    public void mouseUp(MouseEvent mouseEvent) {
        if (this.m_isDragging) {
            this.notifyLast();
            this.releaseCapture();
            this.m_isDragging = false;
        }
    }

    public void setPointConvertor(PointConvertor pointConvertor) {
        this.m_pointConvertor = pointConvertor;
    }

    public PointConvertor getPointConvertor() {
        return this.m_pointConvertor;
    }

    public boolean contains(int n, int n2) {
        return this.getParent().contains(n, n2);
    }

    public void notifyLast() {
        if (this.m_setEventName != null) {
            this.publishEvent(this.m_setEventName, this.m_lastPoint);
        }
    }

    public void notifyChange() {
        if (this.m_eventName != null) {
            this.publishEvent(this.m_eventName, this.m_lastPoint, this);
        }
    }

    public Point getPoint() {
        return this.getParent().getRefPoint();
    }

    public Rectangle getRoughRect() {
        return ((Region)this.getParent()).getRoughRect();
    }

    public void mouseDown(MouseEvent mouseEvent) {
        this.setCapture();
        this.m_isDragging = true;
        this.m_startX = mouseEvent.getX();
        this.m_startY = mouseEvent.getY();
        this.m_lastPoint = this.getParent().getRefPoint();
        this.notifyChange();
    }

    public void mouseDrag(MouseEvent mouseEvent) {
        SimObject simObject = this.getParent();
        this.m_lastPoint = simObject.getRefPoint();
        this.m_lastPoint.translate(mouseEvent.getX() - this.m_startX, mouseEvent.getY() - this.m_startY);
        this.m_lastPoint = this.m_pointConvertor.convertPoint(this.m_lastPoint);
        simObject.setRefPoint(this.m_lastPoint.x, this.m_lastPoint.y);
        this.notifyChange();
    }

    protected Cursor getCursor() {
        return Cursor.getPredefinedCursor(12);
    }
}

