/*
 * Decompiled with CFR 0.152.
 */
package physicon.objava3.more;

import java.awt.Color;
import java.awt.Point;
import physicon.objava3.Region;
import physicon.objava3.SimObject;
import physicon.objava3.more.ColorDecorationBase;
import physicon.objava3.more.EmptyRegion;

public abstract class ArrowDecorationBase
extends ColorDecorationBase {
    private int m_vx;
    private int m_vy;
    private double m_length;
    private double sin_a;
    private double cos_a;
    private EmptyRegion m_endObject = null;
    private double m_endR = 12.0;
    private double m_endA = 1.5707963267948966;

    public Region getEndObject() {
        if (this.m_endObject == null) {
            this.m_endObject = new EmptyRegion(this, new Point(0, 0));
            this.updateEndObjectPosition();
        }
        return this.m_endObject;
    }

    public ArrowDecorationBase(SimObject simObject, Point point, Point point2, Color color) {
        super(simObject, point, color);
        this.setVector(point2.x, point2.y);
    }

    public void setVector(int n, int n2) {
        this.m_vx = n;
        this.m_vy = n2;
        this.m_length = Math.sqrt(n * n + n2 * n2);
        if (n2 != 0 || n != 0) {
            this.sin_a = (double)(-n2) / this.m_length;
            this.cos_a = (double)n / this.m_length;
        }
        this.updateSizes();
    }

    public void setVector(double d, double d2) {
        this.sin_a = Math.sin(d2);
        this.cos_a = Math.cos(d2);
        this.setLength(d);
    }

    public final Point getVector() {
        return new Point(this.m_vx, this.m_vy);
    }

    public void setEndObjectAngle(double d) {
        this.m_endA = d;
    }

    public void setEndObjectRadius(double d) {
        this.m_endR = d;
    }

    protected void updateSizes() {
        this.updateEndObjectPosition();
    }

    public final double getSin() {
        return this.sin_a;
    }

    public void setAngle(double d) {
        this.setVector(this.m_length, d);
    }

    public final double getAngle() {
        return Math.atan2(this.sin_a, this.cos_a);
    }

    public final double getAngle(double d) {
        return Math.IEEEremainder(Math.atan2(this.sin_a, this.cos_a) - d + Math.PI * 2, Math.PI * 2) + d;
    }

    public void setLength(double d) {
        this.m_length = d;
        this.m_vx = (int)Math.round(this.m_length * this.cos_a);
        this.m_vy = -((int)Math.round(this.m_length * this.sin_a));
        this.updateSizes();
    }

    public final double getLength() {
        return this.m_length;
    }

    public final double getCos() {
        return this.cos_a;
    }

    private void updateEndObjectPosition() {
        if (this.m_endObject != null) {
            double d = this.getAngle() + this.m_endA;
            int n = this.m_vx + (int)Math.round(this.m_endR * Math.cos(d));
            int n2 = this.m_vy + (int)Math.round(-this.m_endR * Math.sin(d));
            this.m_endObject.setRefPoint(n, n2);
        }
    }
}

