/*
 * Decompiled with CFR 0.152.
 */
package physicon.objava3.graph;

import java.awt.Component;
import physicon.graphLib2.DoublePoint;
import physicon.graphLib2.GraphContainerBase;
import physicon.graphLib2.GraphContextBase;
import physicon.graphLib2.GraphElementInterface;
import physicon.objava3.Region;
import physicon.objava3.SimWindow;
import physicon.objava3.graph.SimGraphElement;

public class SimGraphContainer
extends GraphContainerBase {
    private SimWindow window;

    public void showElement(GraphElementInterface graphElementInterface, boolean bl) {
        if (this.indexOfElement(graphElementInterface) == -1) {
            System.out.println("Warning!!! The element is not in the element array");
            return;
        }
        if (!(graphElementInterface instanceof Region)) {
            System.out.println("Warning!!! The element in the container is not Region");
            return;
        }
        ((Region)((Object)graphElementInterface)).setVisible(bl);
    }

    public SimGraphContainer(GraphContextBase graphContextBase, SimWindow simWindow) {
        super(graphContextBase);
        this.window = simWindow;
    }

    public void removeElement(SimGraphElement simGraphElement) {
        super.removeElement(simGraphElement);
        simGraphElement.destroy();
    }

    public void showScale(GraphElementInterface graphElementInterface, boolean bl) {
        if (this.indexOfScale(graphElementInterface) == -1) {
            System.out.println("Warning!!! The scale is not in the scale array");
            return;
        }
        if (!(graphElementInterface instanceof Region)) {
            System.out.println("Warning!!! The scale in the container is not Region");
            return;
        }
        Region region = (Region)((Object)graphElementInterface);
        region.setVisible(bl);
    }

    public void resort() {
        int n;
        int n2 = n = this.elementsNumber();
        while (n2 > 0) {
            GraphElementInterface graphElementInterface = this.realElementAt(n2 - 1);
            if (!(graphElementInterface instanceof SimGraphElement)) {
                System.out.println("Warning!!! The element in the container is not SimGraphElement");
            } else {
                ((SimGraphElement)graphElementInterface).updateRefPoint();
            }
            --n2;
        }
        int n3 = n2 = this.scalesNumber();
        while (n3 > 0) {
            GraphElementInterface graphElementInterface = this.realScaleAt(n3 - 1);
            if (!(graphElementInterface instanceof SimGraphElement)) {
                System.out.println("Warning!!! The scale in the container is not SimGraphElement");
            } else {
                this.window.toBack((Region)((Object)graphElementInterface));
                ((SimGraphElement)graphElementInterface).updateRefPoint();
            }
            --n3;
        }
    }

    public void updateAll() {
        int n;
        int n2 = n = this.elementsNumber();
        while (n2 > 0) {
            GraphElementInterface graphElementInterface = this.realElementAt(n2 - 1);
            if (!(graphElementInterface instanceof SimGraphElement)) {
                System.out.println("Warning!!! The element in the container is not SimGraphElement");
            } else {
                ((SimGraphElement)graphElementInterface).updateRefPoint();
            }
            --n2;
        }
        int n3 = n2 = this.scalesNumber();
        while (n3 > 0) {
            GraphElementInterface graphElementInterface = this.realScaleAt(n3 - 1);
            if (!(graphElementInterface instanceof SimGraphElement)) {
                System.out.println("Warning!!! The scale in the container is not SimGraphElement");
            } else {
                ((SimGraphElement)graphElementInterface).updateRefPoint();
            }
            --n3;
        }
    }

    public synchronized boolean contains(DoublePoint doublePoint) {
        GraphContextBase graphContextBase = this.getContext();
        int n = graphContextBase.lp2gpX(doublePoint.x, doublePoint.y) + graphContextBase.getOffset().x;
        int n2 = graphContextBase.lp2gpY(doublePoint.x, doublePoint.y) + graphContextBase.getOffset().y;
        boolean bl = this.window.contains(n, n2);
        return bl;
    }

    public Component getComponent() {
        return this.window.getComponent();
    }

    public void removeScaleAt(int n) {
        GraphElementInterface graphElementInterface = this.realScaleAt(n);
        if (!(graphElementInterface instanceof Region)) {
            System.out.println("Warning!!! The element in the container is not Region");
            return;
        }
        ((Region)((Object)graphElementInterface)).destroy();
        super.removeScaleAt(n);
    }

    public void removeElementAt(int n) {
        GraphElementInterface graphElementInterface = this.realElementAt(n);
        if (!(graphElementInterface instanceof Region)) {
            System.out.println("Warning!!! The element in the container is not Region");
            return;
        }
        ((Region)((Object)graphElementInterface)).destroy();
        super.removeElementAt(n);
    }
}

