/*
 * Decompiled with CFR 0.152.
 */
package physicon.objava3;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import physicon.objava3.Region;
import physicon.objava3.SimConfig;
import physicon.objava3.SimObject;
import physicon.objava3.SimWindowImp;

public class SimWindow
extends SimObject
implements MouseListener,
MouseMotionListener {
    public static boolean isMicrosoft = System.getProperty("java.vendor").indexOf("Microsoft") >= 0;
    private Vector m_wndVector;
    private Region m_rgnCaptureOwner;
    private Panel m_comp;
    private Image m_image;
    private int m_width;
    private int m_height;
    private boolean m_isEnabled = true;
    private Color m_bkgColor;

    public void removePopupMenu() {
        SimObject simObject;
        int n = 0;
        while (n < this.m_wndVector.size()) {
            simObject = (SimWindow)this.m_wndVector.elementAt(n);
            ((SimWindow)simObject).removePopupMenu();
            ++n;
        }
        n = 0;
        while (n < this.m_rgnVector.size()) {
            simObject = (Region)this.m_rgnVector.elementAt(n);
            simObject.removePopupMenu();
            ++n;
        }
        super.removePopupMenu();
    }

    public void onCreate() {
        this.m_image = this.m_comp.createImage(this.m_width, this.m_height);
        super.onCreate();
        this.paintAll(this.getGraphics());
        this.flushBuffer();
    }

    public final void addComponent(Component component) {
        this.m_comp.add(component);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Region region = this.m_rgnCaptureOwner;
        if (region == null) {
            region = this.locateRegion(mouseEvent.getX(), mouseEvent.getY());
        }
        if (region != null) {
            Point point = region.getAbsRefPoint();
            mouseEvent.translatePoint(-point.x, -point.y);
            region.mouseUp(mouseEvent);
            return;
        }
        this.mouseUp(mouseEvent);
    }

    public final Image getMemoryImage() {
        return this.m_image;
    }

    public final void removeSimWindow(SimWindow simWindow) {
        this.m_wndVector.removeElement(simWindow);
    }

    public final Panel getComponent() {
        return this.m_comp;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public final void setCapture(Region region) {
        if (this.m_rgnCaptureOwner != null) {
            this.m_rgnCaptureOwner.onKillCapture();
        }
        this.m_rgnCaptureOwner = region;
    }

    public final Dimension getSize() {
        return new Dimension(this.m_width, this.m_height);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Region region = this.m_rgnCaptureOwner;
        if (region == null) {
            region = this.locateRegion(mouseEvent.getX(), mouseEvent.getY());
        }
        if (region != null) {
            Point point = region.getAbsRefPoint();
            mouseEvent.translatePoint(-point.x, -point.y);
            region.mouseDown(mouseEvent);
            return;
        }
        this.mouseDown(mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Region region = this.m_rgnCaptureOwner;
        if (region != null) {
            Point point = region.getAbsRefPoint();
            mouseEvent.translatePoint(-point.x, -point.y);
            region.mouseDrag(mouseEvent);
            return;
        }
        this.mouseDrag(mouseEvent);
    }

    public final boolean isEnabled() {
        return this.m_isEnabled;
    }

    public SimWindow(SimWindow simWindow, Point point, Dimension dimension) {
        super(simWindow, point);
        this.m_width = dimension.width;
        this.m_height = dimension.height;
        this.m_bkgColor = SimConfig.bkgColor;
        this.m_wndVector = new Vector();
        if (simWindow != null) {
            simWindow.addSimWindow(this);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Region region = this.m_rgnCaptureOwner;
        if (region == null) {
            region = this.locateRegion(mouseEvent.getX(), mouseEvent.getY());
        }
        String string = null;
        Cursor cursor = null;
        if (region != null) {
            Point point = region.getAbsRefPoint();
            mouseEvent.translatePoint(-point.x, -point.y);
            region.mouseMove(mouseEvent);
            string = region.getHint();
            cursor = region.getCursor();
        } else {
            this.mouseMove(mouseEvent);
            string = this.getHint();
            cursor = this.getCursor();
        }
        this.getHost().getHostContainer().showStatus(string);
        if (this.m_comp != null) {
            this.m_comp.setCursor(cursor);
        }
    }

    public void create() {
        this.m_comp = this.createComponent();
        SimWindow simWindow = (SimWindow)this.getParent();
        if (simWindow != null) {
            simWindow.addComponent(this.m_comp);
        }
        int n = 0;
        while (n < this.m_wndVector.size()) {
            ((SimWindow)this.m_wndVector.elementAt(n)).create();
            ++n;
        }
    }

    public void paint(Graphics graphics) {
        graphics.setColor(this.getBkgColor());
        graphics.fillRect(0, 0, this.m_width, this.m_height);
    }

    public final Color getBkgColor() {
        return this.m_bkgColor;
    }

    public final void setBkgColor(Color color) {
        this.m_bkgColor = color;
    }

    public void destroy() {
        int n = 0;
        while (n < this.m_wndVector.size()) {
            ((SimWindow)this.m_wndVector.elementAt(n)).destroy();
            ++n;
        }
        SimWindow simWindow = (SimWindow)this.getParent();
        if (simWindow != null) {
            simWindow.removeComponent(this.m_comp);
        }
    }

    public void setVisible(boolean bl) {
        if (this.isVisible() == bl) {
            return;
        }
        super.setVisible(bl);
        if (!this.isCreated()) {
            return;
        }
        this.m_comp.setVisible(bl);
        this.paintAll();
        this.flushBuffer();
    }

    public final void releaseCapture() {
        this.m_rgnCaptureOwner = null;
    }

    public void addPopupMenu(PopupMenu popupMenu) {
        SimObject simObject;
        super.addPopupMenu(popupMenu);
        int n = 0;
        while (n < this.m_wndVector.size()) {
            simObject = (SimWindow)this.m_wndVector.elementAt(n);
            ((SimWindow)simObject).addPopupMenu(popupMenu);
            ++n;
        }
        n = 0;
        while (n < this.m_rgnVector.size()) {
            simObject = (Region)this.m_rgnVector.elementAt(n);
            simObject.addPopupMenu(popupMenu);
            ++n;
        }
    }

    public boolean contains(int n, int n2) {
        return n >= 0 && n < this.m_width && n2 >= 0 && n2 < this.m_height;
    }

    public Graphics getGraphics() {
        if (this.isCreated()) {
            return this.m_image.getGraphics();
        }
        return null;
    }

    public void preDestroy() {
        super.preDestroy();
        this.m_image.flush();
        if (isMicrosoft) {
            this.m_image = null;
        }
    }

    public void flushBuffer() {
        if (isMicrosoft) {
            this.flushBuffer(this.m_comp.getGraphics());
            return;
        }
        this.m_comp.repaint();
    }

    public void flushBuffer(int n, int n2, int n3, int n4) {
        if (isMicrosoft) {
            this.m_comp.getGraphics().drawImage(this.getMemoryImage(), n, n2, n3, n4, n, n2, n3, n4, this);
            return;
        }
        this.m_comp.repaint(n, n2, n3, n4);
    }

    public void flushBuffer(Graphics graphics) {
        graphics.drawImage(this.getMemoryImage(), 0, 0, this);
    }

    public final void addSimWindow(SimWindow simWindow) {
        if (!this.m_wndVector.contains(simWindow)) {
            this.m_wndVector.addElement(simWindow);
        }
    }

    public void setRefPoint(int n, int n2) {
        super.setRefPoint(n, n2);
        if (this.isCreated()) {
            this.m_comp.setLocation(n, n2);
        }
    }

    public void setEnabled(boolean bl) {
        if (this.m_isEnabled == bl) {
            return;
        }
        this.m_isEnabled = bl;
        if (!this.isCreated()) {
            return;
        }
        this.m_comp.setEnabled(bl);
        this.paintAll();
        this.flushBuffer();
    }

    public Panel createComponent() {
        Point point = this.getRefPoint();
        SimWindowImp simWindowImp = new SimWindowImp(this);
        simWindowImp.setBounds(point.x, point.y, this.m_width, this.m_height);
        simWindowImp.setVisible(this.isVisible());
        simWindowImp.setEnabled(this.isEnabled());
        simWindowImp.addMouseListener(this);
        simWindowImp.addMouseMotionListener(this);
        return simWindowImp;
    }

    final void removeComponent(Component component) {
        this.m_comp.remove(component);
    }

    public final Region locateRegion(int n, int n2) {
        int n3 = this.m_rgnVector.size() - 1;
        while (n3 >= 0) {
            Region region = (Region)this.m_rgnVector.elementAt(n3--);
            Point point = region.getRefPoint();
            Region region2 = region.locateRegion(n - point.x, n2 - point.y);
            if (region2 == null || !region.isVisible()) continue;
            return region2;
        }
        return null;
    }
}

