/*
 * Decompiled with CFR 0.152.
 */
package physicon.objava3;

import physicon.objava3.EventPublisher;
import physicon.objava3.SimConstants;

public class SimTimer
extends Thread
implements SimConstants {
    public static final String evtTimer = "evtTimer";
    private EventPublisher ep;
    private int m_delay;
    private boolean m_isRunning;

    public void exitTimer() {
        this.m_isRunning = false;
        try {
            this.join(1000L);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public SimTimer(EventPublisher eventPublisher, int n) {
        this.ep = eventPublisher;
        this.m_isRunning = true;
        this.setDelay(n);
    }

    public SimTimer(EventPublisher eventPublisher) {
        this(eventPublisher, 40);
    }

    public void run() {
        while (this.m_isRunning) {
            long l = System.currentTimeMillis();
            if (Thread.currentThread() != this) break;
            this.ep.publishEvent(evtTimer, null);
            long l2 = (long)this.m_delay + l - System.currentTimeMillis();
            if (l2 < 10L) {
                l2 = 10L;
            }
            try {
                Thread.sleep(l2);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    public synchronized void setDelay(int n) {
        this.m_delay = n;
    }
}

