/*
 * Decompiled with CFR 0.152.
 */
package physicon.objava3;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;
import java.io.BufferedInputStream;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import physicon.controls.IFactory;
import physicon.objava3.Controllable;
import physicon.objava3.EventPublisher;
import physicon.objava3.EventSubscriber;
import physicon.objava3.HostPanel;
import physicon.objava3.Region;
import physicon.objava3.SimConfig;
import physicon.objava3.SimConstants;
import physicon.objava3.SimWindow;
import physicon.objava3.more.ReliefDecoration;

public abstract class SimObject
implements ImageObserver,
SimConstants,
Controllable {
    private PopupMenu popupMenu = null;
    private String m_strHint = "";
    private String m_name;
    private int m_x;
    private int m_y;
    protected boolean m_isCreated = false;
    private boolean m_isVisible = true;
    private SimObject m_parent;
    Vector m_rgnVector;
    private SimWindow m_simWindow;
    HostPanel m_host;

    public final void addRegion(Region region) {
        if (!this.m_rgnVector.contains(region)) {
            this.m_rgnVector.addElement(region);
        }
    }

    public void removePopupMenu() {
        this.popupMenu = null;
    }

    public void onCreate() {
        if (this.m_name != null && !this.m_name.equals("") && this.m_host.getControllable(this.m_name) == null) {
            this.m_host.addControllable(this.m_name, this);
        }
        int n = 0;
        while (n < this.m_rgnVector.size()) {
            Region region = (Region)this.m_rgnVector.elementAt(n);
            if (region instanceof ReliefDecoration) {
                region.toFront();
            }
            ++n;
        }
        n = 0;
        while (n < this.m_rgnVector.size()) {
            ((Region)this.m_rgnVector.elementAt(n)).onCreate();
            ++n;
        }
        this.m_isCreated = true;
    }

    public final void unsubscribe(String string, EventSubscriber eventSubscriber) {
        this.getEventPublisher().removeSubscriber(string, eventSubscriber);
    }

    public void setStringValue(String string) {
        this.setHint(string);
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 0xC0) != 0) {
            return false;
        }
        if ((n & 0x20) != 0) {
            SimWindow simWindow = this.getSimWindow();
            simWindow.paintAll();
            simWindow.flushBuffer();
            return false;
        }
        return true;
    }

    public String getStringValue() {
        return this.getHint();
    }

    public final Point getAbsRefPoint() {
        Point point = new Point();
        SimObject simObject = this;
        while (!simObject.equals(this.getSimWindow())) {
            Point point2 = simObject.getRefPoint();
            point.translate(point2.x, point2.y);
            simObject = simObject.getParent();
        }
        return point;
    }

    public final boolean isVisible() {
        return this.m_isVisible;
    }

    public final void setName(String string) {
        if (this.m_name != null && !this.m_name.equals("")) {
            this.m_host.removeControllable(this.m_name);
        }
        if (string != null && !string.equals("")) {
            this.m_host.addControllable(string, this);
        }
        this.m_name = string;
    }

    public final String getName() {
        return this.m_name;
    }

    /*
     * Unable to fully structure code
     */
    public final Image getImage(String var1_1, Object var2_2) {
        block9: {
            var1_1 = var1_1.replace('\\', '/');
            var3_3 = null;
            var4_4 = null;
            var5_5 = Toolkit.getDefaultToolkit();
            var6_6 = new BufferedInputStream(var2_2.getClass().getResourceAsStream(var1_1), 8);
            try {
                var7_7 = var6_6.available();
                var4_4 = new byte[var7_7];
                var6_6.read(var4_4);
                var3_3 = var5_5.createImage(var4_4);
                var8_9 = new MediaTracker((Component)this.getHost().getHostContainer());
                var8_9.addImage(var3_3, 0);
                try {
                    var8_9.waitForAll();
                }
                catch (InterruptedException v0) {}
                break block9;
            }
            catch (Exception v1) {
                var7_8 = new StringTokenizer(var2_2.getClass().getName(), ".");
                var8_10 = var7_8.countTokens();
                var9_11 = "";
                var10_12 = 0;
                ** while (var10_12 < var8_10 - 1)
            }
lbl-1000:
            // 1 sources

            {
                var9_11 = var9_11 + var7_8.nextElement() + "/";
                ++var10_12;
                continue;
            }
lbl28:
            // 1 sources

            var9_11 = var9_11 + var1_1;
            try {
                var10_13 = (Applet)this.getHost().getHostContainer();
                var11_15 = new URL(var10_13.getCodeBase(), var9_11);
                var3_3 = var10_13.getImage(var11_15);
                var12_16 = new MediaTracker(var10_13);
                var12_16.addImage(var3_3, 0);
                try {
                    var12_16.waitForAll();
                }
                catch (InterruptedException v2) {}
            }
            catch (Exception var10_14) {
                var10_14.printStackTrace();
                var3_3 = null;
            }
        }
        return var3_3;
    }

    public final IFactory getFactory() {
        return SimConfig.factory;
    }

    protected Cursor getCursor() {
        return Cursor.getPredefinedCursor(0);
    }

    public final void paintAll(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        this.paint(graphics);
        int n = 0;
        while (n < this.m_rgnVector.size()) {
            Region region = (Region)this.m_rgnVector.elementAt(n);
            if (region.isVisible()) {
                Point point = region.getRefPoint();
                graphics.translate(point.x, point.y);
                region.paintAll(graphics);
                graphics.translate(-point.x, -point.y);
            }
            ++n;
        }
    }

    public void paintAll() {
        this.paintAll(this.getGraphics());
    }

    public final SimWindow getSimWindow() {
        return this.m_simWindow;
    }

    public boolean isEnabled() {
        return true;
    }

    public SimObject(SimObject simObject, Point point) {
        this.m_parent = simObject;
        this.m_x = point.x;
        this.m_y = point.y;
        this.m_rgnVector = new Vector();
        SimWindow simWindow = this.m_simWindow = this instanceof SimWindow ? (SimWindow)this : this.m_parent.getSimWindow();
        if (simObject != null) {
            this.m_host = simObject.getHost();
        }
    }

    public abstract void create();

    public boolean isCreated() {
        return this.m_isCreated;
    }

    public final SimObject getParent() {
        return this.m_parent;
    }

    public abstract void paint(Graphics var1);

    protected void mouseUp(MouseEvent mouseEvent) {
        if (this.popupMenu == null || !mouseEvent.isPopupTrigger()) {
            return;
        }
        Point point = this.getAbsRefPoint();
        point.translate(mouseEvent.getX(), mouseEvent.getY());
        this.popupMenu.show((Component)mouseEvent.getSource(), point.x, point.y);
    }

    public void setVisible(boolean bl) {
        this.m_isVisible = bl;
    }

    public abstract void destroy();

    public final void subscribe(String string, EventSubscriber eventSubscriber) {
        this.getEventPublisher().addSubscriber(string, eventSubscriber);
    }

    public void addPopupMenu(PopupMenu popupMenu) {
        this.popupMenu = popupMenu;
    }

    public abstract boolean contains(int var1, int var2);

    public void toBack(Region region) {
        if (this.m_rgnVector.removeElement(region)) {
            this.m_rgnVector.insertElementAt(region, 0);
        }
    }

    public final HostPanel getHost() {
        return this.m_host;
    }

    public void toFront(Region region) {
        if (this.m_rgnVector.removeElement(region)) {
            this.m_rgnVector.addElement(region);
        }
    }

    public Graphics getGraphics() {
        Graphics graphics = this.m_simWindow.getGraphics();
        Point point = this.getAbsRefPoint();
        if (graphics != null) {
            graphics.translate(point.x, point.y);
        }
        return graphics;
    }

    public void preDestroy() {
        this.m_isCreated = false;
        int n = 0;
        while (n < this.m_rgnVector.size()) {
            ((Region)this.m_rgnVector.elementAt(n)).preDestroy();
            ++n;
        }
        if (this.m_name != null && !this.m_name.equals("")) {
            this.m_host.removeControllable(this.m_name);
        }
    }

    public EventPublisher getEventPublisher() {
        return this.m_host.getEventPublisher();
    }

    public final void removeRegion(Region region) {
        this.m_rgnVector.removeElement(region);
    }

    protected void mouseDown(MouseEvent mouseEvent) {
    }

    public final Point getRefPoint() {
        return new Point(this.m_x, this.m_y);
    }

    public void setEnabled(boolean bl) {
    }

    public void setRefPoint(int n, int n2) {
        this.m_x = n;
        this.m_y = n2;
    }

    public void publishEvent(String string, Object object, EventSubscriber eventSubscriber) {
        if (this.isCreated()) {
            this.getEventPublisher().publishEvent(string, object, eventSubscriber);
        }
    }

    protected void mouseDrag(MouseEvent mouseEvent) {
    }

    public final void publishEvent(String string, Object object) {
        this.publishEvent(string, object, null);
    }

    public final String getHint() {
        return this.m_strHint;
    }

    public void setHint(String string) {
        this.m_strHint = string;
    }

    protected void mouseMove(MouseEvent mouseEvent) {
    }
}

