/*
 * Decompiled with CFR 0.152.
 */
package physicon.metatex3;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Hashtable;
import physicon.metatex3.ImageCreator;

public class PixelGrabber
implements ImageConsumer {
    private static final ColorModel rgbModel = ColorModel.getRGBdefault();
    static boolean win98_32bit = false;
    private ImageProducer producer;
    private int width = -1;
    private int height = -1;
    private boolean started;
    private boolean encoding;
    private int[] pix;
    private int status;

    private void encodePixelsWrapper(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) {
        if (!this.started) {
            this.pix = new int[this.width * this.height];
            this.started = true;
        }
        int n7 = 0;
        while (n7 < n4) {
            System.arraycopy(nArray, n7 * n6 + n5, this.pix, this.width * (n2 + n7) + n, n3);
            ++n7;
        }
    }

    public void setHints(int n) {
    }

    public PixelGrabber(ImageProducer imageProducer) {
        this.producer = imageProducer;
        this.encode();
    }

    public PixelGrabber(Image image) {
        this(image.getSource());
    }

    private synchronized void encode() {
        try {
            this.encoding = true;
            this.producer.startProduction(this);
            while (this.encoding) {
                this.wait();
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            return;
        }
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        int[] nArray = new int[n3];
        int n7 = 0;
        while (n7 < n4) {
            int n8 = n5 + n7 * n6;
            int n9 = 0;
            while (n9 < n3) {
                nArray[n9] = colorModel.getRGB(byArray[n8 + n9] & 0xFF);
                ++n9;
            }
            this.encodePixelsWrapper(n, n2 + n7, n3, 1, nArray, 0, n3);
            ++n7;
        }
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        if (colorModel == rgbModel) {
            this.encodePixelsWrapper(n, n2, n3, n4, nArray, n5, n6);
            return;
        }
        int[] nArray2 = new int[n3];
        int n7 = 0;
        while (n7 < n4) {
            int n8 = n5 + n7 * n6;
            int n9 = 0;
            while (n9 < n3) {
                if (win98_32bit) {
                    nArray[n8 + n9] = nArray[n8 + n9] >> 8;
                }
                nArray2[n9] = colorModel.getRGB(nArray[n8 + n9]);
                ++n9;
            }
            this.encodePixelsWrapper(n, n2 + n7, n3, 1, nArray2, 0, n3);
            ++n7;
        }
    }

    public int[] getPixels() {
        return this.pix;
    }

    static {
        if (System.getProperty("os.name").toLowerCase().indexOf("windows 98") >= 0 && System.getProperty("java.vendor").toLowerCase().indexOf("microsoft") >= 0) {
            Image image = ImageCreator.createImage(1, 1);
            Graphics graphics = image.getGraphics();
            graphics.setColor(new Color(1, 2, 234));
            graphics.fillRect(0, 0, 2, 2);
            graphics.dispose();
            image.flush();
            image.getSource().startProduction(new ImageConsumer(){

                public void setHints(int n) {
                }

                public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
                }

                public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
                    if ((nArray[0] >> 24 & 0xFF) == 234) {
                        win98_32bit = true;
                    }
                }

                public void setDimensions(int n, int n2) {
                }

                public void setProperties(Hashtable hashtable) {
                }

                public void imageComplete(int n) {
                }

                public void setColorModel(ColorModel colorModel) {
                }
            });
        }
    }

    public void setDimensions(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public void setProperties(Hashtable hashtable) {
    }

    public int getStatus() {
        return this.status;
    }

    public void imageComplete(int n) {
        this.producer.removeConsumer(this);
        this.status = n;
        PixelGrabber pixelGrabber = this;
        synchronized (pixelGrabber) {
            this.encoding = false;
            this.notifyAll();
            Object var3_3 = null;
            return;
        }
    }

    public void setColorModel(ColorModel colorModel) {
    }
}

