/*
 * Decompiled with CFR 0.152.
 */
package physicon.metatex3;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Vector;
import physicon.metatex3.Block;
import physicon.metatex3.TagParser;
import physicon.metatex3.TextBlock;
import physicon.objava3.SimConfig;

public class FontBlock
extends Block
implements TagParser {
    private static String[] HANDLED_TAGS = new String[]{";", ":", ",", "!", "italic", "bold", "plain", "underline", "overline", "color"};
    public static final int UNDERLINE = 4;
    public static final int OVERLINE = 8;
    private Color color;

    public boolean testArgs(Vector vector) {
        return vector.size() == (this.color == null ? 1 : 2);
    }

    public Block parseTag(String string) {
        FontBlock fontBlock = null;
        if (string.equals("!")) {
            return new TextBlock(-0.3);
        }
        if (string.equals(",")) {
            return new TextBlock(0.2);
        }
        if (string.equals(":")) {
            return new TextBlock(0.5);
        }
        if (string.equals(";")) {
            return new TextBlock(1.0);
        }
        if (string.equals("plain")) {
            fontBlock = new FontBlock(0);
        } else if (string.equals("bold")) {
            fontBlock = new FontBlock(1);
        } else if (string.equals("italic")) {
            fontBlock = new FontBlock(2);
        } else if (string.equals("underline")) {
            fontBlock = new FontBlock(4);
        } else if (string.equals("overline")) {
            fontBlock = new FontBlock(8);
        } else if (string.equals("color")) {
            fontBlock = new FontBlock();
        } else {
            return null;
        }
        fontBlock.setName(string);
        return fontBlock;
    }

    public FontBlock() {
        this(SimConfig.OUTPUT_FONT_COLOR);
    }

    public FontBlock(int n) {
        this(null);
        this.style = n;
    }

    public Color getColor() {
        return this.color;
    }

    public FontBlock(Color color) {
        super(1);
        this.color = color;
    }

    public void paint(Graphics graphics) {
        Color color = graphics.getColor();
        if (this.color != null) {
            graphics.setColor(this.color);
        }
        super.paint(graphics);
        graphics.setColor(color);
    }

    public void setArgs(Vector vector) {
        this.blocks[0] = (Block)vector.elementAt(this.color == null ? 0 : 1);
        if (this.color == null) {
            this.blocks[0].setFontStyle(this.style);
            return;
        }
        try {
            String string = (String)vector.elementAt(0);
            if ("white".equalsIgnoreCase(string)) {
                this.color = Color.white;
                return;
            }
            if ("lightgray".equalsIgnoreCase(string)) {
                this.color = Color.lightGray;
                return;
            }
            if ("gray".equalsIgnoreCase(string)) {
                this.color = Color.gray;
                return;
            }
            if ("darkgray".equalsIgnoreCase(string)) {
                this.color = Color.darkGray;
                return;
            }
            if ("black".equalsIgnoreCase(string)) {
                this.color = Color.black;
                return;
            }
            if ("red".equalsIgnoreCase(string)) {
                this.color = Color.red;
                return;
            }
            if ("pink".equalsIgnoreCase(string)) {
                this.color = Color.pink;
                return;
            }
            if ("orange".equalsIgnoreCase(string)) {
                this.color = Color.orange;
                return;
            }
            if ("yellow".equalsIgnoreCase(string)) {
                this.color = Color.yellow;
                return;
            }
            if ("green".equalsIgnoreCase(string)) {
                this.color = Color.green;
                return;
            }
            if ("magenta".equalsIgnoreCase(string)) {
                this.color = Color.magenta;
                return;
            }
            if ("cyan".equalsIgnoreCase(string)) {
                this.color = Color.cyan;
                return;
            }
            if ("blue".equalsIgnoreCase(string)) {
                this.color = Color.blue;
                return;
            }
            this.color = Color.decode("#" + string);
            return;
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
    }

    public void sizeSelf() {
        this.width = this.blocks[0].width;
        this.ascent = this.blocks[0].ascent;
        this.descent = this.blocks[0].descent;
        if ("underline".equals(this.getName())) {
            this.descent += 2;
            return;
        }
        if ("overline".equals(this.getName())) {
            this.ascent += 2;
            this.coords[0].y = 2;
        }
    }

    public int getArgType(int n) {
        if (this.color == null) {
            if (n < 1) {
                return 1;
            }
            return -1;
        }
        if (n == 0) {
            return 0;
        }
        if (n == 1) {
            return 1;
        }
        return -1;
    }

    public String[] getHandledTags() {
        return HANDLED_TAGS;
    }

    public void paintSelf(Graphics graphics) {
        if ("underline".equals(this.getName())) {
            graphics.drawLine(0, this.getHeight() - 1, this.width - 1, this.getHeight() - 1);
            return;
        }
        if ("overline".equals(this.getName())) {
            graphics.drawLine(0, 1, this.width - 1, 1);
        }
    }

    protected void setSpaces() {
        this.lspace = this.blocks[0].lspace;
        this.rspace = this.blocks[0].rspace;
        this.ltext = this.blocks[0].ltext;
        this.rtext = this.blocks[0].rtext;
    }

    public void setFontStyle(int n) {
        if (!this.getName().equals("plain")) {
            super.setFontStyle(n);
        }
    }

    public boolean isText() {
        return this.blocks[0].isText();
    }
}

