/*
 * Decompiled with CFR 0.152.
 */
package physicon.graphLib2;

import java.awt.Point;
import physicon.funcs2.Func;
import physicon.graphLib2.CurveDrawerBase;
import physicon.graphLib2.DoublePoint;
import physicon.graphLib2.GraphCurveBase;

public class ParamCurve
extends GraphCurveBase {
    private Func xFunc;
    private Func yFunc;
    private double minParamValue;
    private double maxParamValue;
    private boolean rangeChanged;
    private double oldMaxParamValue;
    private double fixedParamStep = 0.0;
    private double k = 2.0;
    private double fastUndefParamStep = 0.1;
    private double slowUndefParamStep = 0.005;
    private Point oldPoint = null;

    public void setFixedParamStep(double d) {
        this.fixedParamStep = d;
        this.setRedrawFlag(true);
    }

    public void setXFunc(Func func) {
        this.xFunc = func;
        this.setRedrawFlag(true);
    }

    public Func getXFunc() {
        return this.xFunc;
    }

    public ParamCurve(CurveDrawerBase curveDrawerBase, Func func, Func func2, double d, double d2) {
        super(curveDrawerBase);
        this.xFunc = func;
        this.yFunc = func2;
        this.minParamValue = d;
        this.maxParamValue = d2;
        this.oldMaxParamValue = d2;
        this.rangeChanged = false;
        this.setRedrawFlag(false);
    }

    public void setRedrawFlag(boolean bl) {
        if (bl) {
            this.rangeChanged = false;
        }
        super.setRedrawFlag(bl);
    }

    public void setYFunc(Func func) {
        this.yFunc = func;
        this.setRedrawFlag(true);
    }

    public final double getMinParamValue() {
        return this.minParamValue;
    }

    public double getMaxParamValue() {
        return this.maxParamValue;
    }

    public Func getYFunc() {
        return this.yFunc;
    }

    public void setMinParamValue(double d) {
        this.minParamValue = d;
        this.setRedrawFlag(true);
    }

    public void setMaxParamValue(double d) {
        boolean bl = this.getRedrawFlag();
        this.setRedrawFlag(true);
        if (this.maxParamValue <= d && !bl) {
            this.oldMaxParamValue = this.getMaxParamValue();
            this.rangeChanged = true;
        }
        this.maxParamValue = d;
    }

    public DoublePoint getLocalPoint(double d) {
        double d2 = d;
        if (d2 > this.maxParamValue) {
            d2 = this.maxParamValue;
        } else if (d2 < this.minParamValue) {
            d2 = this.minParamValue;
        }
        if (!this.xFunc.isDefinedAt(d) || !this.yFunc.isDefinedAt(d)) {
            return new DoublePoint(0.0, 0.0);
        }
        return new DoublePoint(this.xFunc.getValue(d2), this.yFunc.getValue(d2));
    }

    /*
     * Unable to fully structure code
     */
    public void updateDrawer() {
        var1_1 = true;
        this.oldPoint = null;
        if (!this.rangeChanged) {
            super.updateDrawer();
        }
        var2_2 = this.getContainer();
        var3_3 = this.getContext();
        var3_3.setOffset(var3_3.getZeroPoint());
        var4_4 = (CurveDrawerBase)this.getDrawer();
        var5_5 = 0.0;
        var7_6 = 0.0;
        var9_7 = 0.0;
        var11_8 = 0.0;
        var13_9 = 1.0E-10;
        var15_10 = null;
        var16_11 = 0.0;
        var18_12 = 0;
        var19_13 = 0;
        var20_14 = 0;
        var21_15 = 0;
        var22_16 = var3_3.lpINgpX(new DoublePoint());
        var24_17 = var3_3.lpINgpY(new DoublePoint());
        var26_18 = this.rangeChanged != false ? this.oldMaxParamValue : this.getMinParamValue();
        var28_19 = 0;
        while (var26_18 < this.getMaxParamValue() - var13_9) {
            block18: {
                block16: {
                    block17: {
                        block15: {
                            ++var28_19;
                            if (this.xFunc.isDefinedAt(var26_18) && this.yFunc.isDefinedAt(var26_18) && this.xFunc.isDefinedAt(var26_18 + var13_9) && this.yFunc.isDefinedAt(var26_18 + var13_9)) break block15;
                            var1_1 = false;
                            var3_3.setOffset(var3_3.getZeroPoint());
                            while (!(this.xFunc.isDefinedAt(var26_18) && this.yFunc.isDefinedAt(var26_18) && var2_2.contains(this.getLocalPoint(var26_18)) || !(var26_18 <= this.getMaxParamValue()))) {
                                var26_18 += this.fastUndefParamStep;
                            }
                            if (!(var26_18 > this.getMaxParamValue())) ** GOTO lbl35
                            break;
lbl-1000:
                            // 1 sources

                            {
                                var26_18 -= this.slowUndefParamStep;
lbl35:
                                // 2 sources

                                ** while (this.xFunc.isDefinedAt((double)var26_18) && this.yFunc.isDefinedAt((double)var26_18) && var2_2.contains((DoublePoint)this.getLocalPoint((double)var26_18)) && var26_18 <= this.getMaxParamValue())
                            }
lbl36:
                            // 1 sources

                            var26_18 += this.slowUndefParamStep;
                            continue;
                        }
                        var29_20 = this.getLocalPoint(var26_18);
                        var30_21 = this.getLocalPoint(var26_18 + var13_9);
                        if (0.0 != this.fixedParamStep) break block16;
                        var9_7 = (var30_21.x - var29_20.x) / var13_9;
                        var11_8 = (var30_21.y - var29_20.y) / var13_9;
                        var33_23 = this.k * var22_16 / Math.abs(var9_7);
                        var35_25 = this.k * var24_17 / Math.abs(var11_8);
                        var31_22 = Math.min(var33_23, var35_25);
                        if (var2_2.contains(var29_20)) break block17;
                        if (var1_1) {
                            var3_3.setOffset(var3_3.getZeroPoint());
                            var4_4.addPoint(var3_3.lp2gp(var29_20));
                        }
                        while (!(this.xFunc.isDefinedAt(var26_18) && this.yFunc.isDefinedAt(var26_18) && var2_2.contains(this.getLocalPoint(var26_18)) || !(var26_18 <= this.getMaxParamValue()))) {
                            var26_18 += this.fastUndefParamStep;
                        }
                        if (!(var26_18 > this.getMaxParamValue())) ** GOTO lbl57
                        break;
lbl-1000:
                        // 1 sources

                        {
                            var26_18 -= this.slowUndefParamStep;
lbl57:
                            // 2 sources

                            ** while (this.xFunc.isDefinedAt((double)var26_18) && this.yFunc.isDefinedAt((double)var26_18) && var2_2.contains((DoublePoint)this.getLocalPoint((double)var26_18)) && var26_18 >= this.getMinParamValue())
                        }
lbl58:
                        // 1 sources

                        var37_26 = (var26_18 += this.slowUndefParamStep) - this.slowUndefParamStep;
                        while (var2_2.contains(this.getLocalPoint(var37_26)) && var37_26 >= this.getMinParamValue()) {
                            var37_26 -= this.slowUndefParamStep;
                        }
                        var3_3.setOffset(var3_3.getZeroPoint());
                        if (this.xFunc.isDefinedAt(var37_26) && this.yFunc.isDefinedAt(var37_26)) {
                            this.oldPoint = var3_3.lp2gp(this.getLocalPoint(var37_26));
                        }
                        var1_1 = false;
                        continue;
                    }
                    var3_3.setOffset(var3_3.getZeroPoint());
                    var19_13 = var3_3.lp2gpX(var30_21.x, var30_21.y);
                    var21_15 = var3_3.lp2gpY(var30_21.x, var30_21.y);
                    var18_12 = var15_10 == null ? 0 : var3_3.lp2gpX(var15_10.x + var5_5 * (var26_18 - var16_11), var15_10.y);
                    v0 = var20_14 = var15_10 == null ? 0 : var3_3.lp2gpY(var15_10.x, var15_10.y + var7_6 * (var26_18 - var16_11));
                    if (var19_13 != var18_12 || var21_15 != var20_14 || var2_2.contains(this.getLocalPoint(var26_18 + var13_9))) {
                        var3_3.setOffset(var3_3.getZeroPoint());
                        var37_27 = var3_3.lp2gp(var30_21);
                        var18_12 = var37_27.x;
                        var20_14 = var37_27.y;
                        if (var1_1) {
                            if (this.oldPoint != null && Math.abs(var16_11 - var26_18) > 0.3) {
                                var4_4.addPoint(this.oldPoint);
                            }
                            var4_4.addPoint(var37_27);
                        } else {
                            if (this.oldPoint != null && Math.abs(var16_11 - var26_18) > 0.3) {
                                var4_4.addBreakPoint(this.oldPoint);
                            }
                            var4_4.addBreakPoint(var37_27);
                        }
                        var15_10 = var30_21;
                        var16_11 = var26_18;
                        var5_5 = var9_7;
                        var7_6 = var11_8;
                        var1_1 = true;
                    }
                    break block18;
                }
                var33_24 = var3_3.lp2gp(var30_21);
                var31_22 = this.fixedParamStep;
                var4_4.addPoint(var33_24);
            }
            var26_18 += var31_22;
            this.oldPoint = new Point(var19_13, var21_15);
        }
        if (var2_2.contains(this.getLocalPoint(this.getMaxParamValue()))) {
            var3_3.setOffset(var3_3.getZeroPoint());
            var4_4.addPoint(var3_3.lp2gp(this.getLocalPoint(this.getMaxParamValue())));
        }
        this.rangeChanged = false;
    }
}

