/*
 * Decompiled with CFR 0.152.
 */
package physicon.graphLib2;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import physicon.graphLib2.GraphLibData;
import physicon.metatex3.Block;
import physicon.metatex3.Parser;

public class MetaTeXBlock {
    private int locx = 0;
    private int locy = 0;
    private String m_text;
    private Block m_block = new Block();
    private Image m_image = null;
    private Parser m_parser = new Parser();
    private boolean isVisible = true;

    public void setLocation(int n, int n2) {
        this.locx = n;
        this.locy = n2;
    }

    public int getAscent() {
        return this.m_block.getShiftedAscent();
    }

    public int getDescent() {
        return this.getHeight() - this.getAscent();
    }

    public MetaTeXBlock() {
        this("");
    }

    public MetaTeXBlock(String string) {
        this(string, null);
    }

    public MetaTeXBlock(String string, String string2) {
        this(string, string2, null);
    }

    public MetaTeXBlock(String string, String string2, Class clazz) {
        this.setText(string);
    }

    public void paint(Graphics graphics) {
        if (this.isVisible) {
            this.paint(graphics, this.locx, this.locy);
        }
    }

    public void paint(Graphics graphics, int n, int n2) {
        if (this.m_image == null) {
            return;
        }
        graphics.drawImage(this.m_image, n, n2, null);
    }

    public void setVisible(boolean bl) {
        this.isVisible = bl;
    }

    public Dimension getSize() {
        return this.m_block.getSize();
    }

    public int getHeight() {
        return this.m_block.getHeight();
    }

    public int getWidth() {
        return this.m_block.getWidth();
    }

    public void setText(String string) {
        if (this.m_text == string) {
            return;
        }
        this.m_text = string;
        try {
            this.m_block = this.m_parser.parse(this.m_text);
            this.m_block.setBackground(GraphLibData.bgColor);
            Dimension dimension = this.m_block.getSize();
            this.m_image = dimension.width > 0 && dimension.height > 0 ? this.m_parser.createBlockImage(this.m_block) : null;
            return;
        }
        catch (Exception exception) {
            try {
                this.m_block = this.m_parser.parse("\\color{808080} {parse \\: error}");
                this.m_image = this.m_parser.createBlockImage(this.m_block);
                return;
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
                return;
            }
        }
    }

    public String getText() {
        return this.m_text;
    }
}

