/*
 * Decompiled with CFR 0.152.
 */
package physicon.controls.mart;

import java.awt.Canvas;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import physicon.controls.CUtil;
import physicon.controls.IButton;
import physicon.controls.IComponent;
import physicon.controls.IItem;
import physicon.controls.Image3x3;
import physicon.controls.ImageMagic;

public class SButton
extends Canvas
implements IButton,
Runnable {
    Component m_comp;
    boolean focused = false;
    private static long FIRST_DELAY = 250L;
    private static long AUTOREPEAT_DELAY = 50L;
    public static final int RELEASED = 0;
    public static final int FIRST_TIME_PRESSED = 1;
    public static final int AUTOREPEAT = 2;
    private Thread m_ticksThread;
    private int m_state = 0;
    private IItem m_e = null;
    private IItem m_d = null;
    private IItem m_p = null;
    private String m_label;
    private Image m_pressed = new Image3x3("pbutton.gif", true);
    private Image m_enabled = new Image3x3("ebutton.gif", true);
    private Image m_disabled = new Image3x3("dbutton.gif", true);
    boolean m_mousePressed = false;
    boolean m_keyPressed = false;
    protected Image m_buffer;
    private Vector m_actionListeners = new Vector();

    public void setSkin(Image image, Image image2, Image image3) {
        this.m_pressed = image3;
        this.m_enabled = image;
        this.m_disabled = image2;
        this.repaint();
    }

    private void drawRelief(Graphics graphics) {
        Dimension dimension = this.getSize();
        CUtil.drawImage(graphics, this.isEnabled() ? (this.isPressed() ? this.m_pressed : this.m_enabled) : this.m_disabled, 0, 0, dimension.width, dimension.height, CUtil.hostColor, this);
        if (this.isFocused()) {
            // empty if block
        }
    }

    private void drawItem(Graphics graphics) {
        IItem iItem;
        IItem iItem2 = this.isEnabled() ? (this.isPressed() ? this.m_p : this.m_e) : (iItem = this.m_d);
        if (iItem == null) {
            return;
        }
        Dimension dimension = this.getSize();
        Rectangle rectangle = iItem.getRoughRect();
        int n = -rectangle.x + (dimension.width - rectangle.width) / 2;
        int n2 = -rectangle.y + (dimension.height - rectangle.height) / 2;
        graphics.translate(n, n2);
        iItem.paint(graphics);
        graphics.translate(-n, -n2);
    }

    public void paint(Graphics graphics) {
        if (this.m_buffer == null) {
            this.dispatchEvent(new ComponentEvent(this, 101));
        }
        Graphics graphics2 = this.m_buffer.getGraphics();
        this.drawRelief(graphics2);
        graphics2.setColor(this.getForeground());
        graphics2.setFont(this.getFont());
        graphics2.setClip(2, 2, this.getSize().width - 4, this.getSize().height - 4);
        this.drawItem(graphics2);
        this.drawLabel(graphics2);
        graphics2.setClip(null);
        graphics.drawImage(this.m_buffer, 0, 0, this);
    }

    public boolean isPressed() {
        return this.m_state != 0;
    }

    public Component getAWTComponent() {
        return this;
    }

    public SButton(String string) {
        this.m_comp = this;
        this.setCursor(new Cursor(12));
        this.m_label = string;
        this.addFocusListener(new FocusListener(){
            {
                SButton.this.getClass();
            }

            public void focusLost(FocusEvent focusEvent) {
                SButton.this.focused = false;
                if (SButton.this.m_mousePressed || SButton.this.m_keyPressed) {
                    SButton.this.m_mousePressed = false;
                    SButton.this.m_keyPressed = false;
                    SButton.this.stopEventPublishing();
                    return;
                }
                SButton.this.repaint();
            }

            public void focusGained(FocusEvent focusEvent) {
                SButton.this.focused = true;
                SButton.this.repaint();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (SButton.this.m_keyPressed || mouseEvent.getModifiers() != 16) {
                    return;
                }
                SButton.this.requestFocus();
                SButton.this.m_mousePressed = true;
                SButton.this.startEventPublishing();
            }
            {
                SButton.this.getClass();
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (SButton.this.m_keyPressed || mouseEvent.isPopupTrigger()) {
                    return;
                }
                SButton.this.m_mousePressed = false;
                SButton.this.stopEventPublishing();
                SButton.this.notifyLast();
            }
        });
        this.addKeyListener(new KeyAdapter(){
            {
                SButton.this.getClass();
            }

            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                switch (n) {
                    case 32: {
                        if (SButton.this.m_mousePressed) {
                            return;
                        }
                        SButton.this.m_keyPressed = true;
                        SButton.this.startEventPublishing();
                    }
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
                if (SButton.this.m_mousePressed || !SButton.this.m_keyPressed) {
                    return;
                }
                SButton.this.m_keyPressed = false;
                SButton.this.stopEventPublishing();
                SButton.this.notifyLast();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                SButton.this.m_buffer = SButton.this.m_comp.createImage(SButton.this.getSize().width, SButton.this.getSize().height);
            }
            {
                SButton.this.getClass();
            }
        });
    }

    public SButton() {
        this("");
    }

    public void removeActionListener(ActionListener actionListener) {
        this.m_actionListeners.removeElement(actionListener);
    }

    protected void notifyChange() {
        this.processActionEvent(new ActionEvent(this, -1, null));
    }

    public void setComponent(Component component) {
        this.m_comp = component;
    }

    protected void notifyLast() {
        this.processActionEvent(new ActionEvent(this, 0, null));
    }

    private void processActionEvent(ActionEvent actionEvent) {
        int n = 0;
        while (n < this.m_actionListeners.size()) {
            ((ActionListener)this.m_actionListeners.elementAt(n)).actionPerformed(actionEvent);
            ++n;
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void addActionListener(ActionListener actionListener) {
        this.m_actionListeners.addElement(actionListener);
    }

    public Dimension getPreferredSize() {
        if (this.m_enabled != null) {
            return new Dimension(this.m_enabled.getWidth(this), this.m_enabled.getHeight(this));
        }
        return new Dimension(this.getFontMetrics(this.getFont()).stringWidth(this.m_label) + 10, 22);
    }

    public void run() {
        try {
            Thread.sleep(FIRST_DELAY);
        }
        catch (InterruptedException interruptedException) {}
        while (this.m_mousePressed || this.m_keyPressed) {
            SButton sButton = this;
            synchronized (sButton) {
                block8: {
                    if (this.m_state != 1) break block8;
                    this.m_state = 2;
                }
                Object var2_2 = null;
            }
            this.notifyChange();
            try {
                Thread.sleep(AUTOREPEAT_DELAY);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.repaint();
    }

    public void setItemLabel(IItem iItem) {
        if (iItem == null) {
            this.setItemLabel(null, null, null);
            return;
        }
        Image image = CUtil.itemToImage(iItem, this.getBackground(), this.getForeground());
        image = ImageMagic.createDisabledImage(image, null);
        this.setItemLabel(iItem, CUtil.imageToItem(image, this), iItem);
    }

    public void setItemLabel(IItem iItem, IItem iItem2, IItem iItem3) {
        this.m_e = iItem;
        this.m_d = iItem2;
        this.m_p = iItem3;
        this.repaint();
    }

    public boolean isFocused() {
        return this.focused;
    }

    void startEventPublishing() {
        SButton sButton = this;
        synchronized (sButton) {
            this.m_state = 1;
            Object var2_2 = null;
        }
        this.repaint();
        if (this.m_ticksThread == null) {
            this.m_ticksThread = new Thread(this);
            this.m_ticksThread.start();
        }
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.m_buffer == null) {
            return;
        }
        this.m_buffer.flush();
        if (!IComponent.isMicrosoft) {
            return;
        }
        this.m_buffer = null;
        System.gc();
    }

    public void setLabel(String string) {
        this.m_label = string;
        this.repaint();
    }

    public String getLabel() {
        return this.m_label;
    }

    void stopEventPublishing() {
        if (this.m_ticksThread != null) {
            this.m_ticksThread = null;
        }
        SButton sButton = this;
        synchronized (sButton) {
            this.m_state = 0;
            Object var2_2 = null;
        }
        this.repaint();
    }

    private void drawLabel(Graphics graphics) {
        int n = this.getSize().width / 2;
        int n2 = this.getSize().height / 2;
        if (this.isEnabled()) {
            CUtil.drawText(graphics, this.m_label, n, n2, 36);
            return;
        }
        CUtil.drawDisabledText(graphics, this.m_label, n, n2, 36);
    }

    public boolean isFocusTraversable() {
        return true;
    }
}

