/*
 * Decompiled with CFR 0.152.
 */
package physicon.controls;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageProducer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import physicon.controls.PropertiesBlock;
import physicon.controls.ResConstants;

public final class SkinLoader {
    private static String skin = null;
    private static String config = "common.res";
    private static final String[] headerField = new String[]{System.getProperty("java.vendor").trim().toLowerCase(), System.getProperty("os.name").trim().toLowerCase(), System.getProperty("os.version").trim().toLowerCase()};
    private static final String keyValueSeparators = "=: \t\r\n\f";
    private static final String strictKeyValueSeparators = "=:";
    private static final String specialSaveChars = "=: \t\r\n\f#!";
    private static final String whiteSpaceChars = " \t\r\n\f";
    private static final String headerAny = "*";
    private static final String headerDefault = "default";
    private static final char headerMark = '$';
    private static final char[] headerSeparator = new char[]{'{', '}'};
    private static final char[] commentMark = new char[]{'#', '!'};
    private static Hashtable commonRes = null;
    private static Hashtable fontCache = new Hashtable();
    private static Hashtable resCache = new Hashtable();
    private static Hashtable imageCache = new Hashtable();
    private static Hashtable metricCache = new Hashtable();
    private static Hashtable locationCache = new Hashtable();

    public static ImageProducer getSymbolProducer(String string) {
        if (skin == null) {
            System.out.println("Skin is not set yet !");
            return null;
        }
        Image image = (Image)imageCache.get(skin);
        int[] nArray = (int[])((Hashtable)metricCache.get(skin)).get(string);
        int[] nArray2 = (int[])((Hashtable)locationCache.get(skin)).get(string);
        return new FilteredImageSource(image.getSource(), new CropImageFilter(nArray2[0], nArray2[1], nArray[0], nArray[1]));
    }

    private static void drawSymbolImage(Graphics graphics, Image image, int n, int n2, int n3, int n4, int n5, int n6, Color color, java.awt.image.ImageObserver imageObserver) {
        try {
            graphics.drawImage(image, n, n2, n + n5, n2 + n6, n3, n4, n3 + n5, n4 + n6, color, imageObserver);
            return;
        }
        catch (Throwable throwable) {
            Graphics graphics2 = graphics.create(n, n2, n5, n6);
            graphics2.drawImage(image, -n3, -n4, color, imageObserver);
            graphics2.dispose();
            return;
        }
    }

    private static void drawSymbolImage(Graphics graphics, Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, java.awt.image.ImageObserver imageObserver) {
        try {
            graphics.drawImage(image, n, n2, n + n7, n2 + n8, n3, n4, n3 + n5, n4 + n6, color, imageObserver);
            return;
        }
        catch (Throwable throwable) {
            Graphics graphics2 = graphics.create(n, n2, n5, n6);
            graphics2.drawImage(image, -n3, -n4, color, imageObserver);
            graphics2.dispose();
            return;
        }
    }

    public static void drawSymbol(String string, Graphics graphics, int n, int n2, Color color, java.awt.image.ImageObserver imageObserver) {
        if (skin == null) {
            System.out.println("Skin is not set yet !");
            return;
        }
        Image image = (Image)imageCache.get(skin);
        int[] nArray = (int[])((Hashtable)metricCache.get(skin)).get(string);
        int[] nArray2 = (int[])((Hashtable)locationCache.get(skin)).get(string);
        SkinLoader.drawSymbolImage(graphics, image, n, n2, nArray2[0], nArray2[1], nArray[0], nArray[1], color, imageObserver);
    }

    public static void drawSymbol(String string, Graphics graphics, int n, int n2, int n3, int n4, Color color, java.awt.image.ImageObserver imageObserver) {
        if (skin == null) {
            System.out.println("Skin is not set yet !");
            return;
        }
        Image image = (Image)imageCache.get(skin);
        int[] nArray = (int[])((Hashtable)metricCache.get(skin)).get(string);
        int[] nArray2 = (int[])((Hashtable)locationCache.get(skin)).get(string);
        SkinLoader.drawSymbolImage(graphics, image, n, n2, nArray2[0], nArray2[1], nArray[0], nArray[1], n3, n4, color, imageObserver);
    }

    public static String get(String string) {
        int n = config.lastIndexOf(46);
        return SkinLoader.get(n < 0 ? config : config.substring(0, n), string);
    }

    public static String get(String string, String string2) {
        if (skin == null) {
            if (commonRes == null) {
                SkinLoader.init();
            }
            String string3 = new String(string + ".res/" + string2).toLowerCase();
            return (String)commonRes.get(string3);
        }
        return SkinLoader.get(skin, string, string2);
    }

    protected static String get(String string, String string2, String string3) {
        String string4;
        Hashtable hashtable;
        String string5;
        if (!resCache.containsKey(string)) {
            SkinLoader.loadSkin(string);
        }
        if ((string5 = (String)(hashtable = (Hashtable)resCache.get(string)).get(string4 = new String(string2 + ".res/" + string3).toLowerCase())) == null) {
            string5 = (String)hashtable.get(string4.substring(1));
        }
        if (string5 == null) {
            string4 = new String(config + "/" + string3).toLowerCase();
            string5 = (String)hashtable.get(string4);
        }
        if (string5 == null) {
            throw new RuntimeException("Can't get " + string4 + " from " + string + ".zip");
        }
        return string5;
    }

    private static byte[] getStreamContent(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[32768];
        while ((n = inputStream.read(byArray)) > -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static boolean continueLine(String string) {
        int n = 0;
        int n2 = string.length() - 1;
        while (n2 >= 0 && string.charAt(n2--) == '\\') {
            ++n;
        }
        return n % 2 == 1;
    }

    private static boolean analiseHeader(String[] stringArray) {
        boolean bl = true;
        int n = 0;
        while (n < headerField.length) {
            if (headerField[n].indexOf(stringArray[n].toLowerCase()) == -1 && !stringArray[n].equalsIgnoreCase(headerAny)) {
                bl = false;
            }
            ++n;
        }
        return bl;
    }

    public static Hashtable getMetaProperties(String string) {
        Hashtable hashtable = (Hashtable)fontCache.get(skin);
        return (Hashtable)((Hashtable)hashtable.get(string)).clone();
    }

    public static int[] getImageSize(String string) {
        return (int[])((Hashtable)metricCache.get(skin)).get(string);
    }

    private static void putToHash(String string, Hashtable hashtable, String string2) {
        int n;
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            n = string.charAt(n3);
            if (n == 92) {
                ++n3;
            } else if (keyValueSeparators.indexOf(n) != -1) break;
            ++n3;
        }
        n = n3;
        while (n < n2) {
            if (whiteSpaceChars.indexOf(string.charAt(n)) == -1) break;
            ++n;
        }
        if (n < n2 && strictKeyValueSeparators.indexOf(string.charAt(n)) != -1) {
            ++n;
        }
        while (n < n2) {
            if (whiteSpaceChars.indexOf(string.charAt(n)) == -1) break;
            ++n;
        }
        String string3 = string2 + string.substring(0, n3);
        String string4 = n3 < n2 ? string.substring(n, n2) : "";
        hashtable.put(string3, string4);
    }

    private static InputStream openFileStream(String string, Object object) {
        try {
            URL uRL = object.getClass().getResource(string);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.connect();
            return uRLConnection.getInputStream();
        }
        catch (Throwable throwable) {
            try {
                ClassLoader classLoader = object.getClass().getClassLoader();
                Method method = classLoader.getClass().getMethod("getCodeBase", new Class[0]);
                String string2 = object.getClass().getName().replace('.', '/');
                URL uRL = new URL((URL)method.invoke((Object)classLoader, new Object[0]), string2.substring(0, string2.lastIndexOf(47)) + "/" + string);
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.connect();
                return uRLConnection.getInputStream();
            }
            catch (Throwable throwable2) {
                throw new RuntimeException("Can't find " + string);
            }
        }
    }

    private static String[] parseHeader(String string) {
        String[] stringArray = new String[headerField.length];
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            int n3 = string.indexOf(headerSeparator[0], n);
            if (n3 != -1) {
                n = n3 + 1;
                if ((n3 = string.indexOf(headerSeparator[1], n)) != -1) {
                    stringArray[n2] = string.substring(n, n3).trim();
                    n = n3 + 1;
                } else {
                    stringArray[n2] = headerAny;
                }
            } else {
                stringArray[n2] = headerAny;
            }
            ++n2;
        }
        if (stringArray[1].equalsIgnoreCase(headerAny)) {
            stringArray[2] = headerAny;
        }
        return stringArray;
    }

    public static void init() {
        SkinLoader.init(null, null);
    }

    public static void init(String string, Object object) {
        if (string != null && !string.equalsIgnoreCase("")) {
            config = string;
        }
        if (object == null) {
            object = new ResConstants();
        }
        try {
            commonRes = new Hashtable();
            commonRes.put("loader", object);
            byte[] byArray = null;
            InputStream inputStream = null;
            inputStream = SkinLoader.openFileStream(config, object);
            byArray = SkinLoader.getStreamContent(inputStream);
            inputStream.close();
            SkinLoader.loadResource(byArray, commonRes, config + "/");
            return;
        }
        catch (Exception exception) {
            System.err.println("File " + config + " is missing or corrupted !");
            return;
        }
    }

    public static String currentSkin() {
        return skin;
    }

    public static void loadSkin(String string) {
        if (resCache.containsKey(string)) {
            skin = string;
            return;
        }
        if (commonRes == null) {
            SkinLoader.init();
        }
        Hashtable hashtable = (Hashtable)commonRes.clone();
        Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
        String string2 = "skins/" + string + ".zip";
        String string3 = string + ".gif";
        String string4 = string + ".txt";
        Hashtable hashtable3 = imageCache;
        synchronized (hashtable3) {
            block19: {
                try {
                    ZipEntry zipEntry;
                    ZipInputStream zipInputStream = new ZipInputStream(SkinLoader.openFileStream(string2, commonRes.get("loader")));
                    while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                        Object object;
                        String string5 = zipEntry.getName();
                        if (string5.equalsIgnoreCase(string3)) {
                            object = Toolkit.getDefaultToolkit().createImage(SkinLoader.getStreamContent(zipInputStream));
                            object = new ImageObserver((boolean)true, (Image)object).prepare().img;
                            imageCache.put(string, object);
                            continue;
                        }
                        if (string5.equalsIgnoreCase(string4)) {
                            object = new Hashtable();
                            Hashtable<String, int[]> hashtable4 = new Hashtable<String, int[]>();
                            InputStreamReader inputStreamReader = new InputStreamReader(zipInputStream);
                            StreamTokenizer streamTokenizer = new StreamTokenizer(inputStreamReader);
                            streamTokenizer.parseNumbers();
                            streamTokenizer.wordChars(33, 126);
                            while (streamTokenizer.nextToken() != -1) {
                                IOException iOException = new IOException("Syntax error in metrics file at line " + streamTokenizer.lineno());
                                if (streamTokenizer.ttype != -3) {
                                    throw iOException;
                                }
                                int[] nArray = new int[2];
                                int[] nArray2 = new int[2];
                                String string6 = streamTokenizer.sval;
                                int n = 0;
                                do {
                                    if (streamTokenizer.nextToken() != -2) {
                                        throw iOException;
                                    }
                                    if (n < 2) {
                                        nArray2[n] = (int)streamTokenizer.nval;
                                        continue;
                                    }
                                    nArray[n - 2] = (int)streamTokenizer.nval;
                                } while (++n < 4);
                                ((Hashtable)object).put(string6, nArray);
                                hashtable4.put(string6, nArray2);
                            }
                            metricCache.put(string, object);
                            locationCache.put(string, hashtable4);
                            continue;
                        }
                        if (string5.startsWith(ResConstants.texfont)) {
                            object = new Hashtable();
                            SkinLoader.loadResource(SkinLoader.getStreamContent(zipInputStream), (Hashtable)object, "");
                            hashtable2.put(string5, object);
                            continue;
                        }
                        SkinLoader.loadResource(SkinLoader.getStreamContent(zipInputStream), hashtable, string5 + "/");
                    }
                    zipInputStream.close();
                    fontCache.put(string, hashtable2);
                    resCache.put(string, hashtable);
                    skin = string;
                }
                catch (Exception exception) {
                    System.err.println("Skin was not loaded: " + exception.getMessage());
                    if (fontCache.containsKey(string)) {
                        fontCache.remove(string);
                    }
                    if (imageCache.containsKey(string)) {
                        imageCache.remove(string);
                    }
                    if (metricCache.containsKey(string)) {
                        metricCache.remove(string);
                    }
                    if (!locationCache.containsKey(string)) break block19;
                    locationCache.remove(string);
                }
            }
            Object var19_20 = null;
            return;
        }
    }

    private static void loadResource(byte[] byArray, Hashtable hashtable, String string) {
        Hashtable hashtable2 = hashtable;
        synchronized (hashtable2) {
            int n;
            int n2;
            Object object;
            String string2 = new String(byArray).trim();
            string2 = string2 + '\n';
            String string3 = "";
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            while (string2.indexOf(10, n3) != -1) {
                object = string2.substring(n3, string2.indexOf(10, n3));
                n3 += ((String)object).length() + 1;
                if (((String)(object = ((String)object).trim())).length() <= 0) continue;
                n2 = ((String)object).charAt(0);
                n = 0;
                int n6 = 0;
                while (n6 < commentMark.length) {
                    if (n2 == commentMark[n6]) {
                        n = 1;
                    }
                    ++n6;
                }
                if (n != 0) continue;
                if (SkinLoader.continueLine((String)object)) {
                    string3 = string3 + ((String)object).substring(0, ((String)object).lastIndexOf(92));
                } else {
                    string3 = string3 + (String)object + '\n';
                    ++n4;
                }
                if (n2 != 36) continue;
                ++n5;
            }
            object = new PropertiesBlock[n5];
            n3 = 0;
            n2 = 0;
            n = 0;
            while (n < n4) {
                String string4 = string3.substring(n3, string3.indexOf(10, n3));
                n3 += string4.length() + 1;
                if (string4.charAt(0) == '$') {
                    object[n2++] = new PropertiesBlock(SkinLoader.parseHeader(string4));
                } else if (n2 > 0) {
                    ((PropertiesBlock)object[n2 - 1]).addProperty(string4);
                }
                ++n;
            }
            n = 0;
            int n7 = 0;
            while (n7 < n5) {
                if (((PropertiesBlock)object[n7]).header[0].indexOf(headerDefault) != -1) {
                    n3 = 0;
                    while (n3 < ((PropertiesBlock)object[n7]).property.length) {
                        SkinLoader.putToHash(((PropertiesBlock)object[n7]).property[n3], hashtable, string);
                        ++n3;
                    }
                    n = 1;
                    ((PropertiesBlock)object[n7]).isAnalised = true;
                }
                ++n7;
            }
            if (n == 0) {
                throw new RuntimeException("${default} header is missing!");
            }
            n7 = 2;
            do {
                int n8 = 0;
                while (n8 < n5) {
                    if (!((PropertiesBlock)object[n8]).isAnalised) {
                        int n9 = 0;
                        n3 = 0;
                        while (n3 < headerField.length) {
                            if (((PropertiesBlock)object[n8]).header[n3].equalsIgnoreCase(headerAny)) {
                                ++n9;
                            }
                            ++n3;
                        }
                        if (n9 == n7) {
                            if (SkinLoader.analiseHeader(((PropertiesBlock)object[n8]).header)) {
                                n3 = 0;
                                while (n3 < ((PropertiesBlock)object[n8]).property.length) {
                                    SkinLoader.putToHash(((PropertiesBlock)object[n8]).property[n3], hashtable, string);
                                    ++n3;
                                }
                            }
                            ((PropertiesBlock)object[n8]).isAnalised = true;
                        }
                    }
                    ++n8;
                }
            } while (--n7 >= 0);
            Object var15_18 = null;
            return;
        }
    }

    public static class ImageObserver
    implements java.awt.image.ImageObserver {
        public Image img;
        private boolean loadAllData;
        private boolean completed;

        public ImageObserver(boolean bl, Image image) {
            this.img = image;
            this.loadAllData = bl;
        }

        public ImageObserver prepare() {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            this.completed = false;
            toolkit.prepareImage(this.img, -1, -1, this);
            try {
                while (!this.completed) {
                    ImageObserver imageObserver = this;
                    synchronized (imageObserver) {
                        Object var3_3;
                        if (this.img == null) {
                            var3_3 = null;
                            break;
                        }
                        this.checkImage(toolkit.checkImage(this.img, -1, -1, this));
                        var3_3 = null;
                    }
                    Thread.sleep(10L);
                }
            }
            catch (InterruptedException interruptedException) {
                this.img = null;
                this.completed = true;
            }
            return this;
        }

        private synchronized boolean checkImage(int n) {
            boolean bl;
            boolean bl2 = bl = (n & 0x40) != 0 || (n & 0x80) != 0 || (n & 3) != 0 && !this.loadAllData || (n & 0x20) != 0 || (n & 0x10) != 0;
            if (bl) {
                if ((n & 0x40) != 0 || (n & 0x80) != 0) {
                    this.img = null;
                }
                this.completed = true;
            }
            return !this.completed;
        }

        public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
            return this.checkImage(n);
        }
    }
}

