/*
 * Decompiled with CFR 0.152.
 */
package physicon.controls;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import physicon.controls.IComponent;
import physicon.controls.IItem;
import physicon.controls.Image1x1;
import physicon.controls.Image3x3;
import physicon.controls.ImageMagic;
import physicon.controls.ResConstants;
import physicon.controls.SkinLoader;

public class CUtil {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int TA_LEFT = 1;
    public static final int TA_RIGHT = 2;
    public static final int TA_CENTER = 4;
    public static final int TA_TOP = 8;
    public static final int TA_BOTTOM = 16;
    public static final int TA_MIDDLE = 32;
    public static Color hostColor = ResConstants.colorForName(SkinLoader.get(ResConstants.hostColor));

    public static int getNumberOfSignificantDigits(double d) {
        int n = 0;
        double d2 = d;
        while (d2 != (double)Math.round(d2) && n < 10) {
            d2 = d * Math.pow(10.0, ++n);
        }
        if (n == 0) {
            d2 = d;
            while (d2 == (double)Math.round(d2)) {
                d2 = d * Math.pow(10.0, --n);
            }
            ++n;
        }
        return n;
    }

    public static final void drawRelief(Graphics graphics, int n, int n2, int n3, int n4, Color color, Color color2) {
        int n5 = n2 + n4 - 1;
        int n6 = n + n3 - 1;
        graphics.setColor(color);
        graphics.drawLine(n, n2, n6, n2);
        graphics.drawLine(n, n2, n, n5);
        graphics.setColor(color2);
        graphics.drawLine(n, n5, n6, n5);
        graphics.drawLine(n6, n2, n6, n5);
    }

    public static void coverWith(Graphics graphics, Image image, int n, int n2, int n3, int n4, Color color, boolean bl, ImageObserver imageObserver) {
        if (image == null) {
            return;
        }
        if (bl) {
            CUtil.drawImage(graphics, image, n, n2, n3, n4, color, imageObserver);
            return;
        }
        int n5 = image.getWidth(imageObserver);
        int n6 = image.getHeight(imageObserver);
        if (n5 > 0 && n6 > 0) {
            graphics.setClip(n, n2, n3, n4);
            int n7 = 0;
            while (n7 < n3) {
                int n8 = 0;
                while (n8 < n4) {
                    CUtil.drawImage(graphics, image, n + n7, n2 + n8, color, imageObserver);
                    n8 += n6;
                }
                n7 += n5;
            }
            graphics.setClip(null);
        }
    }

    public static IItem imageToItem(final Image image, ImageObserver imageObserver) {
        return new IItem(imageObserver){
            private final /* synthetic */ ImageObserver val$obs;

            public void paint(Graphics graphics) {
                CUtil.drawImage(graphics, image, 0, 0, null, this.val$obs);
            }
            {
                this.val$obs = imageObserver;
            }

            public Rectangle getRoughRect() {
                return new Rectangle(new Dimension(image.getWidth(this.val$obs), image.getHeight(this.val$obs)));
            }
        };
    }

    public static Image itemToImage(IItem iItem, Color color, Color color2) {
        Rectangle rectangle = iItem.getRoughRect();
        Image image = ImageMagic.createImage(rectangle.width, rectangle.height);
        Graphics graphics = image.getGraphics();
        graphics.translate(-rectangle.x, -rectangle.y);
        graphics.setColor(color);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(color2);
        iItem.paint(graphics);
        image = ImageMagic.removeColor(image, color);
        return image;
    }

    public static final void drawTwinRelief(Graphics graphics, int n, int n2, int n3, int n4, Color color, Color color2, Color color3, Color color4) {
        CUtil.drawRelief(graphics, n, n2, n3, n4, color, color4);
        CUtil.drawRelief(graphics, n + 1, n2 + 1, n3 - 2, n4 - 2, color2, color3);
    }

    public static void drawImage(Graphics graphics, Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        if (image instanceof Image1x1) {
            String string = (String)image.getProperty("image", imageObserver);
            if (string.length() == 0) {
                return;
            }
            SkinLoader.drawSymbol(string, graphics, n, n2, color, imageObserver);
            return;
        }
        if (image instanceof Image3x3) {
            CUtil.drawImage(graphics, image, n, n2, image.getWidth(imageObserver), image.getHeight(imageObserver), color, imageObserver);
            return;
        }
        graphics.drawImage(image, n, n2, color, imageObserver);
    }

    public static void drawImage(Graphics graphics, Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        if (image instanceof Image1x1) {
            String string = (String)image.getProperty("image", imageObserver);
            if (string.length() == 0) {
                if (color != null) {
                    graphics.setColor(color);
                    graphics.fillRect(n, n2, n3, n4);
                }
                return;
            }
            if (IComponent.isMacOS9) {
                CUtil.coverWith(graphics, image, n, n2, n3, n4, color, false, imageObserver);
                return;
            }
            SkinLoader.drawSymbol(string, graphics, n, n2, n3, n4, color, imageObserver);
            return;
        }
        if (image instanceof Image3x3) {
            String string = (String)image.getProperty("image", imageObserver);
            if (string.length() == 0) {
                return;
            }
            boolean bl = (Boolean)image.getProperty("scale", imageObserver);
            if (IComponent.isMacOS9) {
                bl = false;
            }
            Image1x1[][] image1x1ArrayArray = new Image1x1[][]{{new Image1x1("tl" + string), new Image1x1("tc" + string), new Image1x1("tr" + string)}, {new Image1x1("ml" + string), new Image1x1("mc" + string), new Image1x1("mr" + string)}, {new Image1x1("bl" + string), new Image1x1("bc" + string), new Image1x1("br" + string)}};
            graphics.translate(n, n2);
            CUtil.coverWith(graphics, image1x1ArrayArray[0][0], 0, 0, image1x1ArrayArray[0][0].width, image1x1ArrayArray[0][0].height, null, bl, imageObserver);
            CUtil.coverWith(graphics, image1x1ArrayArray[0][2], n3 - image1x1ArrayArray[0][2].width, 0, image1x1ArrayArray[0][2].width, image1x1ArrayArray[0][2].height, null, bl, imageObserver);
            CUtil.coverWith(graphics, image1x1ArrayArray[2][2], n3 - image1x1ArrayArray[2][2].width, n4 - image1x1ArrayArray[2][2].height, image1x1ArrayArray[2][2].width, image1x1ArrayArray[2][2].height, null, bl, imageObserver);
            CUtil.coverWith(graphics, image1x1ArrayArray[2][0], 0, n4 - image1x1ArrayArray[2][0].height, image1x1ArrayArray[2][0].width, image1x1ArrayArray[2][0].height, null, bl, imageObserver);
            CUtil.coverWith(graphics, image1x1ArrayArray[0][1], image1x1ArrayArray[0][0].width, 0, n3 - (image1x1ArrayArray[0][0].width + image1x1ArrayArray[0][2].width), image1x1ArrayArray[0][1].height, null, bl, imageObserver);
            CUtil.coverWith(graphics, image1x1ArrayArray[1][2], n3 - image1x1ArrayArray[1][2].width, image1x1ArrayArray[0][2].height, image1x1ArrayArray[1][2].width, n4 - (image1x1ArrayArray[0][2].height + image1x1ArrayArray[2][2].height), null, bl, imageObserver);
            CUtil.coverWith(graphics, image1x1ArrayArray[2][1], image1x1ArrayArray[2][0].width, n4 - image1x1ArrayArray[2][1].height, n3 - (image1x1ArrayArray[2][0].width + image1x1ArrayArray[2][2].width), image1x1ArrayArray[2][1].height, null, bl, imageObserver);
            CUtil.coverWith(graphics, image1x1ArrayArray[1][0], 0, image1x1ArrayArray[0][0].height, image1x1ArrayArray[1][0].width, n4 - (image1x1ArrayArray[0][0].height + image1x1ArrayArray[2][0].height), null, bl, imageObserver);
            CUtil.coverWith(graphics, image1x1ArrayArray[1][1], image1x1ArrayArray[1][0].width, image1x1ArrayArray[0][1].height, n3 - (image1x1ArrayArray[1][0].width + image1x1ArrayArray[1][2].width), n4 - (image1x1ArrayArray[0][1].height + image1x1ArrayArray[2][1].height), color, bl, imageObserver);
            graphics.translate(-n, -n2);
            return;
        }
        graphics.drawImage(image, n, n2, n3, n4, color, imageObserver);
    }

    public static final void drawStandardTwinRelief(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        if (bl) {
            CUtil.drawTwinRelief(graphics, n, n2, n3, n4, SystemColor.controlDkShadow, SystemColor.controlShadow, SystemColor.controlHighlight, SystemColor.controlLtHighlight);
            return;
        }
        CUtil.drawTwinRelief(graphics, n, n2, n3, n4, SystemColor.controlLtHighlight, SystemColor.controlHighlight, SystemColor.controlShadow, SystemColor.controlDkShadow);
    }

    public static final String fString(double d, int n) {
        double d2 = Math.pow(10.0, n);
        d = (double)Math.round(d * d2) / d2;
        int n2 = (int)d;
        double d3 = Math.abs(d - (double)n2);
        double d4 = Math.pow(10.0, (double)(-n) - 1.0);
        double d5 = 1.0 + d3 + d4;
        return (d < 0.0 ? "-" : "") + String.valueOf(Math.abs(n2)) + (n <= 0 ? "" : String.valueOf(d5).substring(1, 2 + n));
    }

    public static final void drawStandardTwinRelief(Graphics graphics, int n, int n2, int n3, int n4) {
        CUtil.drawStandardTwinRelief(graphics, n, n2, n3, n4, true);
    }

    public static IItem stringToItem(String string, final Font font) {
        return new IItem(string){
            private final /* synthetic */ String val$str;

            public void paint(Graphics graphics) {
                graphics.setFont(font);
                CUtil.drawText(graphics, this.val$str, 0, this.getRoughRect().height / 2, 33);
            }
            {
                this.val$str = string;
            }

            public Rectangle getRoughRect() {
                FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
                return new Rectangle(new Dimension(fontMetrics.stringWidth(this.val$str), fontMetrics.getHeight()));
            }
        };
    }

    public static void drawText(Graphics graphics, String string, int n, int n2, int n3) {
        if (n3 != 0) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            if ((n3 & 2) != 0) {
                n -= fontMetrics.stringWidth(string);
            } else if ((n3 & 4) != 0) {
                n -= fontMetrics.stringWidth(string) / 2;
            }
            if ((n3 & 8) != 0) {
                n2 += fontMetrics.getAscent();
            } else if ((n3 & 0x10) != 0) {
                n2 -= fontMetrics.getDescent();
            } else if ((n3 & 0x20) != 0) {
                n2 += (fontMetrics.getAscent() - fontMetrics.getDescent()) / 2;
            }
        }
        graphics.drawString(string, n, n2);
    }

    public static void drawDisabledText(Graphics graphics, String string, int n, int n2, int n3) {
        graphics.setColor(new Color(128, 128, 128));
        CUtil.drawText(graphics, string, n, n2, n3);
    }

    public static class ScaleDrawer {
        private double min;
        private double max;
        private double blockStep;
        private int dashesPerBlock;
        private int orientation;
        private int accuracy;
        private String[] labels;
        private boolean drawLabel;
        private double refValue;
        private Color color;
        private Font font;
        private boolean fromLabelToLabel;
        private Color extraScaleColor;

        public void setOrientation(int n) {
            this.orientation = n;
        }

        public int getDashesPerBlock() {
            return this.dashesPerBlock;
        }

        public double getMin() {
            return this.min;
        }

        public void setMin(double d) {
            this.min = this.round(d);
        }

        public void setDashesPerBlock(int n) {
            this.dashesPerBlock = n;
        }

        public void setDrawLabel(boolean bl) {
            this.drawLabel = bl;
        }

        public void draw(Graphics graphics, Rectangle rectangle) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            if (this.getColor() != null) {
                graphics.setColor(this.getColor());
            }
            double d = this.getBlockStep() / (double)this.getDashesPerBlock();
            boolean bl = this.getDashesPerBlock() % 2 == 0;
            int n = this.getDashesPerBlock() / 2;
            double d2 = this.getMin();
            double d3 = this.getMax();
            if (this.isFromLabelToLabel()) {
                int n2 = (int)Math.floor((this.getMin() - this.getRefValue()) / this.getBlockStep());
                d2 = this.getRefValue() + (double)n2 * this.getBlockStep();
                n2 = (int)Math.ceil((this.getMax() - this.getRefValue()) / this.getBlockStep());
                d3 = this.getRefValue() + (double)n2 * this.getBlockStep();
            }
            double d4 = (double)(this.getOrientation() == 0 ? rectangle.width : rectangle.height) / (this.getMax() - this.getMin());
            Color color = graphics.getColor();
            int n3 = (int)Math.round((d2 - this.getMin()) / d);
            while (n3 <= (int)Math.round((d3 - this.getMin()) / d)) {
                int n4;
                int n5;
                double d5 = (double)n3 * d;
                double d6 = this.getMin() + d5;
                graphics.setColor(d6 < this.getMin() - d / 2.0 || d6 > this.getMax() + d / 2.0 ? this.getExtraScaleColor() : color);
                int n6 = 1;
                if (this.getOrientation() == 0) {
                    n5 = rectangle.x + (int)Math.round(d4 * d5);
                    n4 = rectangle.y;
                } else {
                    n5 = rectangle.x + rectangle.width;
                    n4 = rectangle.y + rectangle.height - (int)Math.round(d4 * d5);
                }
                int n7 = (int)Math.round((d6 - this.getRefValue()) / d);
                if (n7 % this.getDashesPerBlock() == 0) {
                    n6 = 5;
                    if (this.isDrawLabel()) {
                        String string = this.getLabels() == null ? CUtil.fString(d6, this.getAccuracy()) : this.getLabels()[n3 / this.getDashesPerBlock()];
                        int n8 = fontMetrics.stringWidth(string);
                        if (this.getOrientation() == 0) {
                            graphics.drawString(string, n5 - n8 / 2, n4 + n6 + fontMetrics.getAscent() - 1);
                        } else {
                            graphics.drawString(string, n5 - (n8 + n6), n4);
                        }
                    }
                } else if (bl && n7 % n == 0) {
                    n6 = 3;
                }
                if (this.getOrientation() == 0) {
                    graphics.drawLine(n5, n4, n5, n4 + n6);
                } else {
                    graphics.drawLine(n5, n4, n5 - n6, n4);
                }
                ++n3;
            }
        }

        public ScaleDrawer(double d, double d2, double d3, int n) {
            this(d, d2, d3, n, null);
        }

        public ScaleDrawer(double d, double d2, double d3, int n, Color color) {
            this.setAccuracy(CUtil.getNumberOfSignificantDigits(d3 / (double)n));
            this.setBlockStep(d3);
            this.setMin(d);
            this.setMax(d2);
            this.setDashesPerBlock(n);
            this.setColor(color);
            this.setLabels(null);
            this.setDrawLabel(true);
            this.setRefValue(0.0);
            this.setOrientation(0);
            this.setFromLabelToLabel(true);
            this.setExtraScaleColor(new Color(150, 150, 150));
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public void setFromLabelToLabel(boolean bl) {
            this.fromLabelToLabel = bl;
        }

        public Color getExtraScaleColor() {
            return this.extraScaleColor;
        }

        public int getAccuracy() {
            return this.accuracy;
        }

        public void setAccuracy(int n) {
            this.accuracy = n;
        }

        public void setExtraScaleColor(Color color) {
            this.extraScaleColor = color;
        }

        public double getBlockStep() {
            return this.blockStep;
        }

        public void setBlockStep(double d) {
            this.blockStep = this.round(d);
        }

        public double getRefValue() {
            return this.refValue;
        }

        public void setRefValue(double d) {
            this.refValue = this.round(d);
        }

        public Font getFont() {
            return this.font;
        }

        public boolean isDrawLabel() {
            return this.drawLabel;
        }

        public String[] getLabels() {
            return this.labels;
        }

        public void setLabels(String[] stringArray) {
            this.labels = stringArray;
        }

        public void setFont(Font font) {
            this.font = font;
        }

        public boolean isFromLabelToLabel() {
            return this.fromLabelToLabel;
        }

        public double getMax() {
            return this.max;
        }

        public void setMax(double d) {
            this.max = this.round(d);
        }

        private double round(double d) {
            double d2 = Math.pow(10.0, this.getAccuracy());
            return (double)Math.round(d2 * d) / d2;
        }

        public int getOrientation() {
            return this.orientation;
        }
    }
}

