/*
 * Decompiled with CFR 0.152.
 */
package physicon.ap.elfield;

import java.awt.Dimension;
import java.awt.Point;
import physicon.ap.elfield.Data;
import physicon.controls.CUtil;
import physicon.objava3.CompositeTextBlock;
import physicon.objava3.SimWindow;
import physicon.objava3.more.ReliefDecoration;

class OutputCanvas
extends SimWindow {
    private CompositeTextBlock mb;
    private boolean isE = true;
    private int ind = 0;

    public OutputCanvas(SimWindow parent, Point refPoint, Dimension size, boolean isE) {
        super(parent, refPoint, size);
        this.isE = isE;
        if (!isE) {
            ++this.ind;
        }
        new ReliefDecoration(this);
        this.mb = new CompositeTextBlock(this, new Point(8, 5), Data.res.getString("pre" + this.ind), "", Data.res.getString("post" + this.ind));
        this.setValues(0.0, 0.0);
    }

    void setValues(double E, double phy) {
        double d = this.isE ? E : phy;
        String val = CUtil.fString(d, 2);
        String post = Data.res.getString("post" + this.ind);
        if ((phy > 100000.0 || phy < -100000.0) && !this.isE) {
            val = "";
            post = (phy > 0.0 ? "+" : "-") + Data.res.getString("infty");
        }
        this.mb.setString(val);
        this.mb.setPostfix(post);
    }
}

