/*
 * Decompiled with CFR 0.152.
 */
package physicon.ap.elfield;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import physicon.ap.elfield.ApparatCanvas;
import physicon.ap.elfield.CastShadow;
import physicon.ap.elfield.Host;
import physicon.objava3.EventSubscriber;
import physicon.objava3.SimMetaTeXBlock;
import physicon.objava3.SimObject;
import physicon.objava3.SimWindow;
import physicon.objava3.more.RectPointAndClick;
import physicon.objava3.more.SimImage;

class Charge
extends SimImage
implements EventSubscriber {
    private static final Rectangle imageRect = new Rectangle(-5, -5, 10, 10);
    private SimImage plus;
    private SimImage minus;
    private ApparatCanvas parent;
    private RectPointAndClick poi;
    private SimMetaTeXBlock[] mt = new SimMetaTeXBlock[5];
    private double q;

    Charge(ApparatCanvas parent, Point refPoint, String event, String metaTeXlabel) {
        super((SimObject)parent, refPoint, imageRect, "images/charge.gif");
        this.parent = parent;
        this.plus = new SimImage((SimObject)this, new Point(), imageRect, "images/plus.gif");
        this.minus = new SimImage((SimObject)this, new Point(), imageRect, "images/minus.gif");
        String s = metaTeXlabel + "black";
        new CastShadow((SimObject)this, new Point(15, -5), metaTeXlabel, s);
        this.subscribe(event, this);
        this.poi = new RectPointAndClick(this, new Rectangle(imageRect), "event for Q"){

            public void mouseDown(MouseEvent evt) {
                super.mouseDown(evt);
                double d = 0.0;
                if (Charge.this.q > 0.04) {
                    d = 100001.0;
                } else if (Charge.this.q < -0.04) {
                    d = -100001.0;
                }
                Charge.this.updateOutput(d);
            }

            public void mouseUp(MouseEvent evt) {
                super.mouseUp(evt);
                Charge.this.updateOutput(0.0);
            }
        };
    }

    double getQ() {
        return this.q;
    }

    public void receiveEvent(Object value) {
        this.setQ((Double)value);
        this.getParent().paintAll();
        ((SimWindow)this.getParent()).flushBuffer();
    }

    void setQ(double newValue) {
        this.q = newValue;
        this.plus.setVisible(this.q > 0.04);
        this.minus.setVisible(this.q < -0.04);
    }

    private void updateOutput(double d) {
        ((Host)this.parent.host).updateOutput(0.0, d);
    }
}

