/*
 * Decompiled with CFR 0.152.
 */
package physicon.objava3.more;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import physicon.objava3.SimObject;
import physicon.objava3.more.ArrowDecorationBase;

public class ThickArrow
extends ArrowDecorationBase {
    private int m_lineWidth;
    private int m_pointerWidth;
    private double m_pointerLength;
    private Color m_fillColor;
    private Polygon m_poly = new Polygon();

    public void updatePolygon() {
        double d = Math.abs(this.getLength());
        double d2 = d - this.m_pointerLength;
        if (d2 < 0.5 * d) {
            d2 = 0.5 * d;
        }
        int n = (int)Math.floor((double)this.m_lineWidth * 0.5 + 0.1);
        int n2 = (int)Math.floor((double)this.m_pointerWidth * 0.5 + 0.1);
        Point[] pointArray = new Point[]{this.rotatePoint(0.0, n), this.rotatePoint(d2, n), this.rotatePoint(d2 + 0.25, n2), this.getVector(), this.rotatePoint(d2 + 0.25, n2 - this.m_pointerWidth + 1), this.rotatePoint(d2, n - this.m_lineWidth + 1), this.rotatePoint(0.0, n - this.m_lineWidth + 1)};
        this.m_poly = new Polygon();
        int n3 = 0;
        do {
            this.m_poly.addPoint(pointArray[n3].x, pointArray[n3].y);
        } while (++n3 < 7);
    }

    public ThickArrow(SimObject simObject, Point point, Point point2, Color color, Color color2, int n, int n2, int n3) {
        super(simObject, point, point2, color);
        this.m_fillColor = color2;
        this.setSizes(n, n2, n3);
    }

    public ThickArrow(SimObject simObject, Point point, Point point2, Color color, Color color2) {
        this(simObject, point, point2, color, color2, 4, 3, 60);
    }

    public void setFrameColor(Color color) {
        this.setColor(color);
    }

    public void paint(Graphics graphics) {
        if (Math.abs(this.getLength()) >= 3.0) {
            graphics.setColor(this.m_fillColor);
            graphics.setPaintMode();
            graphics.fillPolygon(this.m_poly);
            graphics.setColor(this.getColor());
            graphics.drawPolygon(this.m_poly);
            return;
        }
        graphics.setColor(this.getColor());
        graphics.drawLine(0, 0, 0, 1);
    }

    protected void updateSizes() {
        super.updateSizes();
        this.updatePolygon();
    }

    public boolean contains(int n, int n2) {
        return this.m_poly.contains(n, n2);
    }

    public void setFillColor(Color color) {
        this.m_fillColor = color;
    }

    public Rectangle getRoughRect() {
        Rectangle rectangle = this.m_poly.getBounds();
        ++rectangle.width;
        ++rectangle.height;
        return rectangle;
    }

    public void setSizes(int n, int n2, int n3) {
        this.m_lineWidth = n;
        this.m_pointerWidth = n + n2 * 2;
        this.m_pointerLength = Math.floor(0.5 * (double)this.m_pointerWidth + 0.1) / Math.tan(Math.PI * (double)n3 / 360.0);
        this.updatePolygon();
    }

    private Point rotatePoint(double d, int n) {
        double d2 = this.getSin();
        double d3 = this.getCos();
        Point point = new Point((int)Math.round((d -= 0.25) * d3 - (double)n * d2), -((int)Math.round(d * d2 + (double)n * d3)));
        if (this.getLength() > 0.0) {
            return point;
        }
        return new Point(-point.x, -point.y);
    }
}

