/*
 * Decompiled with CFR 0.152.
 */
package physicon.objava3;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import physicon.controls.IComponent;
import physicon.objava3.SimConfig;
import physicon.objava3.SimMetaTeXBlock;
import physicon.objava3.SimObject;
import physicon.objava3.TextRegion;

public class CompositeTextBlock
extends TextRegion {
    int space = 3;
    SimMetaTeXBlock prefix;
    SimMetaTeXBlock postfix;
    private Font font;
    private Color color;

    public void drawContent(Graphics graphics) {
        int n = Math.max(this.prefix.getAscent(), this.postfix.getAscent());
        graphics.translate(0, n - this.prefix.getAscent());
        this.prefix.drawContent(graphics);
        graphics.translate(this.prefix.getWidth() + this.space, this.prefix.getAscent());
        graphics.setFont(SimConfig.OUTPUT_FONT);
        int n2 = 0;
        if (this.getString() != null && this.getString().length() > 0) {
            graphics.drawString(this.getString(), 0, 0);
            n2 = this.stringWidth(this.getString(), graphics.getFontMetrics());
        }
        graphics.translate(n2 + this.space, -this.postfix.getAscent());
        this.postfix.drawContent(graphics);
        graphics.translate(this.postfix.getWidth() - this.getWidth(), this.postfix.getAscent() - n);
    }

    public CompositeTextBlock(SimObject simObject, Point point, String string, String string2, String string3) {
        this(simObject, point, string, string2, string3, 0);
    }

    public CompositeTextBlock(SimObject simObject, Point point, String string, String string2, String string3, int n) {
        this(simObject, point, string, string2, string3, 0, n);
    }

    public CompositeTextBlock(SimObject simObject, Point point, String string, String string2, String string3, int n, int n2) {
        super(simObject, point, string2, n2);
        this.prefix = this.createPrefix(string, n);
        this.prefix.setVisible(false);
        this.postfix = this.createPostfix(string3, n);
        this.postfix.setVisible(false);
        this.setString(string2);
        this.setColor(SimConfig.OUTPUT_FONT_COLOR);
        this.setFont(SimConfig.OUTPUT_FONT);
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void paint(Graphics graphics) {
        Font font = graphics.getFont();
        Color color = graphics.getColor();
        graphics.setFont(this.getFont());
        graphics.setColor(this.getColor());
        super.paint(graphics);
        graphics.setFont(font);
        graphics.setColor(color);
    }

    public Color getColor() {
        return this.color;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Font getFont() {
        return this.font;
    }

    public void setPostfix(String string) {
        this.postfix.setString(string);
    }

    protected int stringWidth(String string, FontMetrics fontMetrics) {
        int n = fontMetrics.stringWidth(string);
        if (IComponent.isMacOS9) {
            n = "2.2".equals(System.getProperty("mrj.version")) ? (int)(0.75 * (double)n) : (int)(0.94 * (double)n);
        }
        return n;
    }

    public void setPrefix(String string) {
        this.prefix.setString(string);
    }

    protected SimMetaTeXBlock createPostfix(String string, int n) {
        return new SimMetaTeXBlock(this.getParent(), new Point(), string, n, 0);
    }

    public int getHeight() {
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont());
        return Math.max(fontMetrics.getHeight(), Math.max(this.prefix.getHeight(), this.postfix.getHeight()));
    }

    public int getWidth() {
        return this.prefix.getWidth() + this.stringWidth(this.getString(), Toolkit.getDefaultToolkit().getFontMetrics(this.getFont())) + this.postfix.getWidth() + 2 * this.space;
    }

    protected SimMetaTeXBlock createPrefix(String string, int n) {
        return new SimMetaTeXBlock(this.getParent(), new Point(), string, n, 0);
    }
}

