/*
 * Decompiled with CFR 0.152.
 */
package physicon.metatex3;

import java.awt.Graphics;
import java.util.Vector;
import physicon.metatex3.Block;
import physicon.metatex3.MetaTexGraphics;
import physicon.metatex3.TagParser;

public class WideBraceBlock
extends Block
implements TagParser {
    private static String[] HANDLED_TAGS = new String[]{"overbrace", "underbrace", "overbracket", "underbracket"};
    public static final int BRACE = 0;
    public static final int BRACKET = 1;
    private static int BRACE_WIDTH = 8;
    private static int MIN_WIDTH = 2 * BRACE_WIDTH + 2;
    private int type;
    private boolean over;
    private char lbrace;
    private char rbrace;
    private int lwidth = 0;
    private int rwidth = 0;

    public boolean testArgs(Vector vector) {
        return vector.size() == 2;
    }

    public Block parseTag(String string) {
        int n;
        boolean bl = string.startsWith("over");
        if (string.endsWith("brace")) {
            n = 0;
        } else if (string.endsWith("bracket")) {
            n = 1;
        } else {
            throw new IllegalArgumentException(string + " is not supported by " + this.getClass().getName());
        }
        return new WideBraceBlock(n, bl);
    }

    public WideBraceBlock() {
    }

    public WideBraceBlock(int n, boolean bl) {
        super(2);
        this.type = n;
        this.over = bl;
    }

    public boolean isOver() {
        return this.over;
    }

    public void sizeSelf() {
        this.width = Math.max(this.blocks[0].width, this.blocks[1].width);
        if (this.width < MIN_WIDTH) {
            this.width = MIN_WIDTH;
        }
        int n = this.blocks[0].getHeight() + this.blocks[1].getHeight() + BRACE_WIDTH + 2;
        this.ascent = this.blocks[0].ascent + (this.over ? this.blocks[1].getHeight() + BRACE_WIDTH + 2 : 0);
        this.descent = n - this.ascent;
        this.coords[0].x = (this.width - this.blocks[0].width) / 2;
        this.coords[0].y = this.over ? this.blocks[1].getHeight() + BRACE_WIDTH + 2 : 0;
        this.coords[1].x = (this.width - this.blocks[1].width) / 2;
        this.coords[1].y = this.over ? 0 : this.blocks[0].getHeight() + BRACE_WIDTH + 2;
    }

    public int getArgType(int n) {
        if (n < 2) {
            return 1;
        }
        return -1;
    }

    public String[] getHandledTags() {
        return HANDLED_TAGS;
    }

    public void paintSelf(Graphics graphics) {
        int n = this.blocks[this.over ? 1 : 0].getHeight() + 1;
        if (this.type == 1) {
            graphics.drawLine(0, n, 0, n + BRACE_WIDTH);
            graphics.drawLine(this.width - 1, n, this.width - 1, n + BRACE_WIDTH);
            graphics.drawLine(0, n + (this.over ? 0 : BRACE_WIDTH), this.width - 1, n + (this.over ? 0 : BRACE_WIDTH));
            return;
        }
        if (this.type == 0) {
            int n2 = BRACE_WIDTH / 2;
            graphics.translate(0, n + n2);
            MetaTexGraphics metaTexGraphics = new MetaTexGraphics(graphics);
            if (this.over) {
                metaTexGraphics.drawQuater(2, n2, n2 - 1, n2);
                metaTexGraphics.drawQuater(4, this.width / 2 - n2 + 1, -n2 + 1, n2);
                metaTexGraphics.drawQuater(3, this.width / 2 + n2 - 1, -n2 + 1, n2);
                metaTexGraphics.drawQuater(1, this.width - n2, n2 - 1, n2);
            } else {
                metaTexGraphics.drawQuater(3, n2, -n2 + 1, n2);
                metaTexGraphics.drawQuater(1, this.width / 2 - n2 + 1, n2 - 1, n2);
                metaTexGraphics.drawQuater(2, this.width / 2 + n2 - 1, n2 - 1, n2);
                metaTexGraphics.drawQuater(4, this.width - n2, -n2 + 1, n2);
            }
            graphics.drawLine(this.width / 2 - n2, 0, n2, 0);
            graphics.drawLine(this.width / 2 + n2, 0, this.width - n2, 0);
            graphics.translate(0, -n - n2);
        }
    }

    public int getType() {
        return this.type;
    }

    protected void setChildrenScale(int n) {
        this.blocks[0].setScale(n);
        this.blocks[1].setScale(n - 1);
    }
}

