/*
 * Decompiled with CFR 0.152.
 */
package physicon.metatex3;

import java.awt.Graphics;
import java.util.Vector;
import physicon.metatex3.Block;
import physicon.metatex3.TagParser;

public class ReactionBlock
extends Block
implements TagParser {
    private static String HANDLED_TAG = "reaction";
    private String arrowName;
    private int arrw;
    private int arrhh;

    public boolean testArgs(Vector vector) {
        return vector.size() == 3;
    }

    public Block parseTag(String string) {
        if (string.equals(HANDLED_TAG)) {
            return new ReactionBlock();
        }
        throw new IllegalArgumentException(string + " is not supported by " + this.getClass().getName());
    }

    public ReactionBlock() {
        super(3);
    }

    public void setArgs(Vector vector) {
        this.arrowName = (String)vector.elementAt(0);
        this.blocks[0] = (Block)vector.elementAt(1);
        this.blocks[1] = (Block)vector.elementAt(2);
    }

    public void sizeSelf() {
        int[] nArray = this.getFont().getSpaceMetric();
        this.arrw = Math.max(3, nArray[0] / 2);
        this.arrhh = Math.max(2, nArray[1] / 4);
        if (this.arrowName.equals("lrarrow") || this.arrowName.equals("rlarrow")) {
            this.ascent = Math.max(this.blocks[0].getHeight() + 1, 4 * this.arrhh);
            this.descent = Math.max(this.blocks[1].getHeight() + 1, 4 * this.arrhh);
            this.width = Math.max(this.blocks[0].width, this.blocks[1].width);
        } else {
            this.ascent = Math.max(this.blocks[0].getHeight() + 1, this.arrhh * 2);
            this.descent = Math.max(this.blocks[1].getHeight() + 1, this.arrhh * 2);
            this.width = Math.max(this.blocks[0].width, this.blocks[1].width);
        }
        this.width = this.width != 0 ? (this.width += 4 * nArray[0]) : 3 * nArray[0];
        this.coords[0].x = (this.width - this.blocks[0].width) / 2;
        this.coords[0].y = 0;
        this.coords[1].x = (this.width - this.blocks[1].width) / 2;
        this.coords[1].y = this.ascent + 2;
    }

    public String getArrowName() {
        return this.arrowName;
    }

    public int getArgType(int n) {
        if (n == 0) {
            return 0;
        }
        if (n == 1 || n == 2) {
            return 1;
        }
        return -1;
    }

    public String[] getHandledTags() {
        return new String[]{HANDLED_TAG};
    }

    public void paintSelf(Graphics graphics) {
        if (this.arrowName != null) {
            if (this.arrowName.equals("rightarrow")) {
                graphics.drawLine(0, this.ascent, this.width - 1, this.ascent);
                graphics.drawLine(this.width - 1, this.ascent, this.width - 1 - this.arrw, this.ascent - this.arrhh);
                graphics.drawLine(this.width - 1, this.ascent, this.width - 1 - this.arrw, this.ascent + this.arrhh);
            }
            if (this.arrowName.equals("leftarrow")) {
                graphics.drawLine(0, this.ascent, this.width - 1, this.ascent);
                graphics.drawLine(0, this.ascent, this.arrw, this.ascent - this.arrhh);
                graphics.drawLine(0, this.ascent, this.arrw, this.ascent + this.arrhh);
            }
            if (this.arrowName.equals("leftrightarrow")) {
                graphics.drawLine(0, this.ascent, this.width - 1, this.ascent);
                graphics.drawLine(this.width - 1, this.ascent, this.width - 1 - this.arrw, this.ascent - this.arrhh);
                graphics.drawLine(this.width - 1, this.ascent, this.width - 1 - this.arrw, this.ascent + this.arrhh);
                graphics.drawLine(0, this.ascent, this.arrw, this.ascent - this.arrhh);
                graphics.drawLine(0, this.ascent, this.arrw, this.ascent + this.arrhh);
            }
            if (this.arrowName.equals("lrarrow")) {
                graphics.drawLine(0, this.ascent - this.arrhh, this.width - 1, this.ascent - this.arrhh);
                graphics.drawLine(this.width - 1, this.ascent - this.arrhh, this.width - 1 - this.arrw, this.ascent - 2 * this.arrhh);
                graphics.drawLine(this.width - 1, this.ascent - this.arrhh, this.width - 1 - this.arrw, this.ascent);
                graphics.drawLine(0, this.ascent + this.arrhh, this.width - 1, this.ascent + this.arrhh);
                graphics.drawLine(0, this.ascent + this.arrhh, this.arrw, this.ascent + 2 * this.arrhh);
                graphics.drawLine(0, this.ascent + this.arrhh, this.arrw, this.ascent);
            }
            if (this.arrowName.equals("rlarrow")) {
                graphics.drawLine(0, this.ascent - this.arrhh, this.width - 1, this.ascent - this.arrhh);
                graphics.drawLine(0, this.ascent - this.arrhh, this.arrw, this.ascent - 2 * this.arrhh);
                graphics.drawLine(0, this.ascent - this.arrhh, this.arrw, this.ascent);
                graphics.drawLine(0, this.ascent + this.arrhh, this.width - 1, this.ascent + this.arrhh);
                graphics.drawLine(this.width - 1 - this.arrw, this.ascent + 2 * this.arrhh, this.width - 1, this.ascent + this.arrhh);
                graphics.drawLine(this.width - 1 - this.arrw, this.ascent, this.width - 1, this.ascent + this.arrhh);
            }
        }
    }

    protected void setChildrenScale(int n) {
        this.blocks[0].setScale(n - 1);
        this.blocks[1].setScale(n - 1);
    }
}

