/*
 * Decompiled with CFR 0.152.
 */
package physicon.metatex3;

import java.util.StringTokenizer;
import physicon.metatex3.FontCache;

public class MetaTexFont {
    private String family;
    private int size;
    private int style;

    public int[] getSpaceMetric() {
        return FontCache.getCharMetric(this, "x");
    }

    public int[] getFontMetric() {
        return FontCache.getCharMetric(this, "W");
    }

    public String toString() {
        return "MetaTexFont[family=" + this.family + ", size=" + this.size + ", style=" + this.style;
    }

    MetaTexFont(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
        this.family = stringTokenizer.nextToken();
        this.size = Integer.parseInt(stringTokenizer.nextToken());
        this.style = 0;
    }

    MetaTexFont(MetaTexFont metaTexFont) {
        this.family = metaTexFont.family;
        this.size = metaTexFont.size;
        this.style = metaTexFont.style;
    }

    public int hashCode() {
        return (this.family + this.size).hashCode();
    }

    public int getStyle() {
        return this.style;
    }

    public MetaTexFont getStyled(int n) {
        MetaTexFont metaTexFont = new MetaTexFont(this);
        metaTexFont.style = n;
        return metaTexFont;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof MetaTexFont) {
            MetaTexFont metaTexFont = (MetaTexFont)object;
            return metaTexFont.family.equals(this.family) && metaTexFont.size == this.size;
        }
        return false;
    }

    public String getFamily() {
        return this.family;
    }

    public int getSize() {
        return this.size;
    }
}

