/*
 * Decompiled with CFR 0.152.
 */
package physicon.metatex3;

import java.awt.Graphics;
import java.util.Vector;
import physicon.metatex3.Block;
import physicon.metatex3.MetaTexGraphics;
import physicon.metatex3.TextBlock;

public class BracemBlock
extends Block {
    private static int BRACE_WIDTH = 8;
    private char lbrace;
    private char rbrace;
    private int lwidth;
    private int rwidth;
    private boolean smallChild;
    private TextBlock lBraceBlock;
    private TextBlock rBraceBlock;
    private Block b;

    public char getRBrace() {
        return this.rbrace;
    }

    public boolean testArgs(Vector vector) {
        return vector.size() == 2;
    }

    private void drawBrace(Graphics graphics, char c, int n, int n2, int n3, int n4) {
        MetaTexGraphics metaTexGraphics = new MetaTexGraphics(graphics);
        graphics.translate(n, n2);
        if (c == '(') {
            int n5 = this.smallChild ? 0 : 1;
            int n6 = 2 * BRACE_WIDTH;
            metaTexGraphics.drawQuaver(2, n5, 0, n6);
            graphics.drawLine(1 + n5, metaTexGraphics.getQuaverHeight(), 1 + n5, n4 - metaTexGraphics.getQuaverHeight());
            metaTexGraphics.drawQuaver(3, n5, n4 - metaTexGraphics.getQuaverHeight(), n6);
        } else if (c == ')') {
            int n7 = this.smallChild ? 0 : -3;
            int n8 = 2 * BRACE_WIDTH;
            metaTexGraphics.drawQuaver(1, 2 + n7, 0, n8);
            graphics.drawLine(n7 + metaTexGraphics.getQuaverWidth(), metaTexGraphics.getQuaverHeight(), n7 + metaTexGraphics.getQuaverWidth(), n4 - metaTexGraphics.getQuaverHeight());
            metaTexGraphics.drawQuaver(4, 2 + n7, n4 - metaTexGraphics.getQuaverHeight(), n8);
        } else if (c == '{' || c == '}') {
            int n9 = BRACE_WIDTH / 2;
            if (c == '{') {
                metaTexGraphics.drawQuater(2, 2 * n9 - 1, n9, n9);
                metaTexGraphics.drawQuater(4, 1, n4 / 2 - n9 + 1, n9);
                metaTexGraphics.drawQuater(1, 1, n4 / 2 + n9 - 1, n9);
                metaTexGraphics.drawQuater(3, 2 * n9 - 1, n4 - n9, n9);
            } else {
                metaTexGraphics.drawQuater(1, 1, n9, n9);
                metaTexGraphics.drawQuater(3, 2 * n9 - 1, n4 / 2 - n9 + 1, n9);
                metaTexGraphics.drawQuater(2, 2 * n9 - 1, n4 / 2 + n9 - 1, n9);
                metaTexGraphics.drawQuater(4, 1, n4 - n9 - 1, n9);
            }
            graphics.drawLine(n9, n9, n9, n4 / 2 - n9);
            graphics.drawLine(n9, n4 - n9 - 1, n9, n4 / 2 + n9);
        } else if (c == '[' || c == ']') {
            if (c == '[') {
                graphics.drawLine(1, 1, n3 / 2, 1);
                graphics.drawLine(1, n4 - 2, n3 / 2, n4 - 2);
                graphics.drawLine(1, 1, 1, n4 - 2);
            }
            if (c == ']') {
                graphics.drawLine(n3 - 2, 1, n3 / 2, 1);
                graphics.drawLine(n3 - 2, n4 - 2, n3 / 2, n4 - 2);
                graphics.drawLine(n3 - 2, 1, n3 - 2, n4 - 2);
            }
        } else if (c == '|') {
            graphics.drawLine(1, 0, 1, n4);
        } else if (c == 'c' || c == 'C' || c == 'f' || c == 'F') {
            int n10 = Character.isLowerCase(c) ? n3 - 2 : 1;
            int n11 = Character.toLowerCase(c) == 'f' ? n4 - 2 : 1;
            graphics.drawLine(n10, 1, n10, n4 - 2);
            graphics.drawLine(1, n11, n3 - 2, n11);
        } else if (c == ' ') {
            // empty if block
        }
        graphics.translate(-n, -n2);
    }

    public BracemBlock() {
        super(1);
    }

    public void setArgs(Vector vector) {
        this.blocks[0] = (Block)vector.elementAt(1);
        String string = (String)vector.elementAt(0);
        this.lbrace = (char)(string.length() < 1 ? 32 : (int)string.charAt(0));
        this.rbrace = (char)(string.length() < 2 ? 32 : (int)string.charAt(1));
    }

    public void sizeSelf() {
        boolean bl = this.smallChild = this.blocks[0].width < 6;
        if (this.blocks[0].isText() && this.lbrace == '(' && this.rbrace == ')') {
            try {
                this.lBraceBlock = new TextBlock(this.props, '(');
                this.rBraceBlock = new TextBlock(this.props, ')');
                this.b = new Block(3);
                Vector<Block> vector = new Vector<Block>();
                vector.addElement(this.lBraceBlock);
                vector.addElement(this.blocks[0]);
                vector.addElement(this.rBraceBlock);
                this.b.setArgs(vector);
                this.b.setProperties(this.props);
                this.b.setScale(this.scale);
                this.b.getSize();
                this.width = this.b.getWidth();
                this.ascent = this.b.ascent;
                this.descent = this.b.descent;
                this.coords[0].x = this.b.coords[1].x;
                this.coords[0].y = this.b.coords[1].y;
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
        int n = Math.max(this.blocks[0].ascent, this.blocks[0].descent) * 2;
        this.lwidth = this.braceWidth(this.lbrace, n);
        this.rwidth = this.braceWidth(this.rbrace, n);
        this.width = this.blocks[0].width + this.lwidth + this.rwidth;
        this.ascent = n / 2;
        this.descent = n - this.ascent;
        this.coords[0].x = this.lwidth;
        this.coords[0].y = this.ascent - this.blocks[0].ascent;
    }

    public int getArgType(int n) {
        if (n == 0) {
            return 0;
        }
        if (n == 1) {
            return 1;
        }
        return -1;
    }

    public void paintSelf(Graphics graphics) {
        if (this.blocks[0].isText()) {
            this.b.paint(graphics);
            return;
        }
        int n = 0;
        int n2 = this.lwidth + this.blocks[0].width;
        int n3 = this.ascent - this.getHeight() / 2;
        this.drawBrace(graphics, this.lbrace, n, n3, this.lwidth, this.getHeight());
        this.drawBrace(graphics, this.rbrace, n2, n3, this.rwidth, this.getHeight());
    }

    private int braceWidth(char c, int n) {
        if (c == '(' || c == ')') {
            return BRACE_WIDTH - (this.smallChild ? 0 : 2);
        }
        if (c == '[' || c == ']') {
            return BRACE_WIDTH;
        }
        if (c == '{' || c == '}') {
            return BRACE_WIDTH;
        }
        if (c == 'f' || c == 'c') {
            return (int)((double)n * 0.2);
        }
        if (c == 'F' || c == 'C') {
            return (int)((double)n * 0.2);
        }
        if (c == '|') {
            return 3;
        }
        if (c == ' ') {
            return 1;
        }
        return 0;
    }

    public char getLBrace() {
        return this.lbrace;
    }
}

