/*
 * Decompiled with CFR 0.152.
 */
package physicon.graphLib2;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import physicon.graphLib2.ArrowDrawer;

public class ThickArrowDrawer
extends ArrowDrawer {
    private Color borderColor;
    private int baseHeight;

    public void reset() {
        super.reset();
        this.beginPoint = null;
        this.endPoint = null;
    }

    public ThickArrowDrawer(Color color) {
        this(color, color, 10, 5, 3);
    }

    public ThickArrowDrawer(Color color, Color color2, int n, int n2, int n3) {
        super(color);
        this.borderColor = color2;
        this.arrowWidth = n;
        this.arrowHeight = n2;
        this.baseHeight = n3;
        this.beginPoint = null;
        this.endPoint = null;
    }

    public void drawLocal(Graphics graphics) {
        double d = this.endPoint.x - this.beginPoint.x;
        double d2 = this.endPoint.y - this.beginPoint.y;
        double d3 = Math.sqrt(d * d + d2 * d2);
        int n = d3 > (double)this.arrowWidth ? this.arrowWidth : (int)Math.floor(d3);
        double d4 = d * (d3 - (double)n) / d3;
        double d5 = d2 * (d3 - (double)n) / d3;
        Math.round(d4);
        Math.round(d5);
        double d6 = d / d3;
        double d7 = d2 / d3;
        int[] nArray = new int[7];
        int[] nArray2 = new int[7];
        nArray[0] = -((int)Math.round((double)this.baseHeight * d7));
        nArray2[0] = (int)Math.round((double)this.baseHeight * d6);
        nArray[1] = (int)Math.round((d3 - (double)n) * d6 + (double)nArray[0]);
        nArray2[1] = (int)Math.round((d3 - (double)n) * d7 + (double)nArray2[0]);
        nArray[2] = (int)Math.round((double)nArray[1] - (double)(this.arrowHeight - this.baseHeight) * d7);
        nArray2[2] = (int)Math.round((double)nArray2[1] + (double)(this.arrowHeight - this.baseHeight) * d6);
        nArray[3] = (int)Math.round(d3 * d6);
        nArray2[3] = (int)Math.round(d3 * d7);
        nArray[6] = (int)Math.round((double)this.baseHeight * d7);
        nArray2[6] = -((int)Math.round((double)this.baseHeight * d6));
        nArray[5] = (int)Math.round((d3 - (double)n) * d6 + (double)nArray[6]);
        nArray2[5] = (int)Math.round((d3 - (double)n) * d7 + (double)nArray2[6]);
        nArray[4] = (int)Math.round((double)nArray[5] + (double)(this.arrowHeight - this.baseHeight) * d7);
        nArray2[4] = (int)Math.round((double)nArray2[5] - (double)(this.arrowHeight - this.baseHeight) * d6);
        int n2 = 0;
        do {
            int n3 = n2;
            nArray[n3] = nArray[n3] + this.beginPoint.x;
            int n4 = n2++;
            nArray2[n4] = nArray2[n4] + this.beginPoint.y;
        } while (n2 < 7);
        graphics.setColor(this.color);
        graphics.fillPolygon(nArray, nArray2, 7);
        graphics.setColor(this.borderColor);
        graphics.drawPolygon(nArray, nArray2, 7);
    }

    public Rectangle getLocalRoughRect() {
        int n;
        int n2;
        int n3 = this.endPoint.x - this.beginPoint.x;
        int n4 = this.endPoint.y - this.beginPoint.y;
        if (n3 < 0) {
            n2 = this.endPoint.x;
            n3 *= -1;
        } else {
            n2 = this.beginPoint.x;
        }
        if (n4 < 0) {
            n = this.endPoint.y;
            n4 *= -1;
        } else {
            n = this.beginPoint.y;
        }
        Rectangle rectangle = new Rectangle(n2, n, n3, n4);
        rectangle.grow(this.arrowWidth + this.arrowHeight + 1, this.arrowWidth + this.arrowHeight + 1);
        return rectangle;
    }
}

