/*
 * Decompiled with CFR 0.152.
 */
package physicon.graphLib2;

import java.awt.Point;
import physicon.graphLib2.GraphContextBase;

public final class LinearGraphContext
extends GraphContextBase {
    private double lxINgx;
    private double lyINgy;

    public LinearGraphContext(int n, int n2) {
        this.zeroPoint = new Point(n, n2);
        this.lxINgx = 1.0;
        this.lyINgy = 1.0;
    }

    public double gp2lpY(int n, int n2) {
        int n3 = this.getOffsetY() + n2;
        return -this.lyINgy * (double)(n3 - this.zeroPoint.y);
    }

    public synchronized int lp2gpY(double d, double d2) {
        double d3 = -Math.round(d2 / this.lyINgy) + (long)this.zeroPoint.y - (long)this.getOffsetY();
        if (d3 > 2.147483647E9) {
            return Integer.MAX_VALUE;
        }
        if (d3 < -2.147483648E9) {
            return Integer.MIN_VALUE;
        }
        return (int)d3;
    }

    public void setScale(double d, double d2) {
        this.lxINgx = d;
        this.lyINgy = d2;
    }

    public double gl2llY(double d) {
        return this.lyINgy * d;
    }

    public double ll2glY(double d) {
        return d / this.lyINgy;
    }

    public double gp2lpX(int n, int n2) {
        int n3 = this.getOffsetX() + n;
        return this.lxINgx * (double)(n3 - this.zeroPoint.x);
    }

    public synchronized int lp2gpX(double d, double d2) {
        int n = (int)Math.round(d / this.lxINgx) + this.zeroPoint.x - this.getOffsetX();
        return n;
    }

    public double gl2llX(double d) {
        return this.lxINgx * d;
    }

    public double ll2glX(double d) {
        return d / this.lxINgx;
    }

    public void scale(double d, double d2) {
        if (d == 0.0 || d2 == 0.0) {
            System.out.println("Error:can't scale in 0 times");
            return;
        }
        this.lxINgx /= d;
        this.lyINgy /= d2;
    }
}

