/*
 * Decompiled with CFR 0.152.
 */
package physicon.graphLib2;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import physicon.graphLib2.ChartDrawerBase;
import physicon.graphLib2.MetaTeXBlock;

public class LinVertChartDrawer
extends ChartDrawerBase {
    Color dashColor;
    private int dashes;
    private int space;
    private MetaTeXBlock label = null;

    public LinVertChartDrawer(Color color, Color color2, int n, String string) {
        super(color);
        this.dashColor = color2;
        this.space = 3;
        int n2 = this.dashes = n != 0 ? n : 1;
        if (string != null) {
            this.label = new MetaTeXBlock(string, "graph.txt");
        }
    }

    public void drawLocal(Graphics graphics) {
        graphics.setColor(this.dashColor);
        double d = (double)this.height / (double)this.dashes;
        int n = 0;
        while (n < this.dashes + 1) {
            graphics.drawLine(this.x, this.y + (int)Math.round((double)n * d), this.x + this.width, this.y + (int)Math.round((double)n * d));
            ++n;
        }
        graphics.drawLine(this.x, this.y, this.x, this.y + this.height);
        graphics.drawLine(this.x + this.width, this.y, this.x + this.width, this.y + this.height);
        n = this.x;
        int n2 = this.y;
        int n3 = this.width;
        graphics.setColor(this.getColor());
        if (this.maxValue != 0.0) {
            int n4 = this.width >= 0 ? this.x : this.x + this.width;
            int n5 = this.height >= 0 ? this.y : this.y + (int)Math.round((double)this.height * this.curValue / this.maxValue);
            int n6 = this.width >= 0 ? this.width : -this.width;
            int n7 = this.height >= 0 ? this.height : -this.height;
            graphics.setColor(Color.black);
            graphics.fillRect((n4 += this.space) + 1, n5 + 1, (n6 -= this.space * 2) - 1, (int)Math.round((double)n7 * this.curValue / this.maxValue - 1.0));
            graphics.setColor(this.getColor());
            graphics.fillRect(n4 + 2, n5 + 2, n6 - 3, (int)Math.round((double)n7 * this.curValue / this.maxValue - 2.0));
            graphics.setColor(this.dashColor);
            graphics.drawLine(n, n2, n + n3, n2);
        } else {
            System.out.println("Warning!!! maxValue = 0.");
        }
        if (this.label != null) {
            this.label.setLocation(this.x + (this.width - this.label.getWidth()) / 2, this.y + this.height - (this.space + this.label.getHeight()));
            this.label.paint(graphics);
        }
    }

    public Rectangle getLocalRoughRect() {
        int n = this.width >= 0 ? this.x : this.x - this.width;
        int n2 = this.height >= 0 ? this.y : this.y - this.height;
        int n3 = this.width >= 0 ? this.width : -this.width;
        int n4 = this.height >= 0 ? this.height : -this.height;
        return new Rectangle(n, n2, n3, n4);
    }
}

