/*
 * Decompiled with CFR 0.152.
 */
package physicon.graphLib2;

import java.awt.Point;
import java.util.Vector;
import physicon.GraphEngine.GEInterface;
import physicon.GraphEngine.GEObject;
import physicon.graphLib2.DoublePoint;
import physicon.graphLib2.DoubleRectangle;
import physicon.graphLib2.DrawerBase;
import physicon.graphLib2.GraphContainerBase;
import physicon.graphLib2.GraphContextBase;
import physicon.graphLib2.GraphElementInterface;
import physicon.graphLib2.GraphLibData;

public abstract class GraphElementBase
implements GEInterface,
GraphElementInterface {
    private GraphContainerBase container = null;
    private DoublePoint refPoint;
    private boolean redrawFlag = true;
    private boolean visible = false;
    private DrawerBase drawer;
    private Vector depend = new Vector();

    protected void setContainer(GraphContainerBase graphContainerBase) {
        this.container = graphContainerBase;
    }

    public final GraphContainerBase getContainer() {
        return this.container;
    }

    public final boolean getRedrawFlag() {
        return this.redrawFlag;
    }

    public void setRedrawFlag(boolean bl) {
        this.redrawFlag = bl;
    }

    public GraphElementBase(DrawerBase drawerBase) {
        this.refPoint = new DoublePoint(0.0, 0.0);
        this.drawer = drawerBase;
    }

    public boolean isCreated() {
        GraphContainerBase graphContainerBase = this.getContainer();
        return graphContainerBase != null && graphContainerBase.getContext() != null && graphContainerBase.getComponent() != null;
    }

    public void setVisible(boolean bl) {
        if (bl == this.visible) {
            return;
        }
        this.visible = bl;
        this.redrawFlag = true;
    }

    public DrawerBase getDrawer() {
        return this.drawer;
    }

    public void setDrawer(DrawerBase drawerBase) {
        this.drawer = drawerBase;
    }

    public boolean contains(Point point) {
        return this.contains(point.x, point.y);
    }

    public boolean contains(int n, int n2) {
        Point point = new Point(n - this.getDrawer().getGlobalRefPoint().x, n2 - this.getDrawer().getGlobalRefPoint().y);
        return this.getDrawer().contains(point);
    }

    public void addDependent(GraphElementBase graphElementBase) {
        this.depend.addElement(graphElementBase);
    }

    public Vector getDepend() {
        return this.depend;
    }

    public void update() {
        int n = 0;
        while (n < this.depend.size()) {
            ((GraphElementBase)this.depend.elementAt(n)).update();
            ++n;
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public final GEObject getGEObject() {
        if (!this.isCreated()) {
            this.setRedrawFlag(true);
            return GraphLibData.nullDrawer;
        }
        try {
            if (this.getRedrawFlag()) {
                this.updateDrawer();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.drawer;
    }

    public DoubleRectangle getRoughRect() {
        return null;
    }

    public void updateDrawer() {
        try {
            this.drawer.reset();
            GraphContextBase graphContextBase = this.getContext();
            graphContextBase.setOffset(new Point(0, 0));
            Point point = graphContextBase.lp2gp(this.getRefPoint());
            this.drawer.setGlobalRefPoint(point);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public final GraphElementBase getGraphElement() {
        return this;
    }

    public DoublePoint getRefPoint() {
        return new DoublePoint(this.refPoint);
    }

    public void setRefPoint(DoublePoint doublePoint) {
        this.refPoint = doublePoint;
        this.setRedrawFlag(true);
        this.update();
    }

    public final void setZLevel(double d) {
        this.drawer.setGlobalLevel(d);
        this.setRedrawFlag(true);
    }

    public final double getZLevel() {
        return this.drawer.getGlobalLevel();
    }

    public final GraphContextBase getContext() {
        return this.container.getContext();
    }
}

